/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.parentheses.aroundConditional;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUnlessStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUntilStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RWhileStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElsifBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;

public final class RubyParenthesesAroundConditionInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyParenthesesAroundConditionInspection.$$$reportNull$$$0(0);
        }
        return new RubyParenthesesAroundConditionVisitor(holder);
    }

    private static boolean isAssignmentOnly(RGroupedExpression child) {
        List statements;
        RPsiElement innerExpression = child.getExpression();
        return innerExpression instanceof RCompoundStatement && (statements = ((RCompoundStatement)innerExpression).getStatements()).size() == 1 && statements.get(0) instanceof RAssignmentExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/ruby/ruby/inspections/parentheses/aroundConditional/RubyParenthesesAroundConditionInspection", "buildVisitor"));
    }

    private static class RubyParenthesesAroundConditionVisitor
    extends RubyInspectionVisitor {
        RubyParenthesesAroundConditionVisitor(ProblemsHolder holder) {
            super(holder);
        }

        public void visitRIfStatement(@NotNull RIfStatement ifStatement) {
            if (ifStatement == null) {
                RubyParenthesesAroundConditionVisitor.$$$reportNull$$$0(0);
            }
            this.checkCondition(ifStatement.getCondition());
        }

        public void visitRElsifBlock(@NotNull RElsifBlock rElsifBlock) {
            if (rElsifBlock == null) {
                RubyParenthesesAroundConditionVisitor.$$$reportNull$$$0(1);
            }
            this.checkCondition(rElsifBlock.getCondition());
        }

        public void visitRUnlessStatement(@NotNull RUnlessStatement rUnlessStatement) {
            if (rUnlessStatement == null) {
                RubyParenthesesAroundConditionVisitor.$$$reportNull$$$0(2);
            }
            this.checkCondition(rUnlessStatement.getCondition());
        }

        public void visitRWhileStatement(@NotNull RWhileStatement rWhileStatement) {
            if (rWhileStatement == null) {
                RubyParenthesesAroundConditionVisitor.$$$reportNull$$$0(3);
            }
            this.checkCondition(rWhileStatement.getCondition());
        }

        public void visitRUntilStatement(@NotNull RUntilStatement rUntilStatement) {
            if (rUntilStatement == null) {
                RubyParenthesesAroundConditionVisitor.$$$reportNull$$$0(4);
            }
            this.checkCondition(rUntilStatement.getCondition());
        }

        private void checkCondition(RCondition condition) {
            if (condition == null) {
                return;
            }
            PsiElement[] children = condition.getChildren();
            if (children.length != 1) {
                return;
            }
            PsiElement child = children[0];
            if (child instanceof RGroupedExpression && RubyPsiUtil.isInParentheses((RPsiElement)child)) {
                if (RubyParenthesesAroundConditionInspection.isAssignmentOnly((RGroupedExpression)child)) {
                    return;
                }
                this.registerProblem((PsiElement)condition, RBundle.message((String)"inspection.parentheses.around.conditional"), new ParenthesesAroundConditionalFix());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rElsifBlock";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rUnlessStatement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rWhileStatement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rUntilStatement";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/parentheses/aroundConditional/RubyParenthesesAroundConditionInspection$RubyParenthesesAroundConditionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRIfStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRElsifBlock";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRUnlessStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRWhileStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRUntilStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ParenthesesAroundConditionalFix
    extends RubyFix {
        private ParenthesesAroundConditionalFix() {
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement expression;
            if (project == null) {
                ParenthesesAroundConditionalFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                ParenthesesAroundConditionalFix.$$$reportNull$$$0(1);
            }
            PsiElement curExpr = expression = descriptor.getPsiElement().getFirstChild();
            while (curExpr instanceof RGroupedExpression && RubyPsiUtil.isInParentheses((RPsiElement)curExpr)) {
                List statements;
                if (!((curExpr = ((RGroupedExpression)curExpr).getExpression()) instanceof RCompoundStatement) || (statements = ((RCompoundStatement)curExpr).getStatements()).size() != 1 || !(statements.get(0) instanceof RGroupedExpression)) continue;
                curExpr = (PsiElement)statements.get(0);
            }
            String deparenthesized = curExpr != null ? curExpr.getText() : "";
            RPsiElement newExpression = RubyElementFactoryCore.createElementFromText((PsiElement)expression, (String)deparenthesized);
            expression.replace((PsiElement)newExpression);
        }

        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.parentheses.around.conditional.message");
            if (string == null) {
                ParenthesesAroundConditionalFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/parentheses/aroundConditional/RubyParenthesesAroundConditionInspection$ParenthesesAroundConditionalFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/parentheses/aroundConditional/RubyParenthesesAroundConditionInspection$ParenthesesAroundConditionalFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

