/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.nilanalysis;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ControlFlowHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.NilAnalysisUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.TypeInferenceContext;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.inspections.nilanalysis.RubyReferencesListTableFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;

public final class RubyRedundantSafeNavigationInspection
extends LocalInspectionTool {
    private static final List<RubyReferencesListTableFactory.Reference> DEFAULT_IGNORED_RECEIVERS = List.of(new RubyReferencesListTableFactory.Reference("Array#[]"), new RubyReferencesListTableFactory.Reference("Enumerable#group_by"), new RubyReferencesListTableFactory.Reference("Hash#[]"));
    public List<RubyReferencesListTableFactory.Reference> myIgnoredReceivers = new ArrayList<RubyReferencesListTableFactory.Reference>(DEFAULT_IGNORED_RECEIVERS);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyRedundantSafeNavigationInspection.$$$reportNull$$$0(0);
        }
        return new RubyInspectionVisitor(holder){

            public void visitRDotReference(@NotNull RDotReference rDotReference) {
                if (rDotReference == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!rDotReference.isSafeNavigation()) {
                    return;
                }
                RPsiElement receiver = rDotReference.getReceiver();
                if (!(receiver instanceof RExpression) || rDotReference.getPsiCommand() == null) {
                    return;
                }
                ControlFlowHolder holder = TypeInferenceContext.getControlFlowHolder((PsiElement)receiver);
                if (holder == null) {
                    return;
                }
                RubyReferencesListTableFactory.Reference receiverFqn = RubyReferencesListTableFactory.getReference((RExpression)receiver);
                if (receiverFqn != null && RubyRedundantSafeNavigationInspection.this.myIgnoredReceivers.contains(receiverFqn)) {
                    return;
                }
                if (NilAnalysisUtil.getCanBeNil(receiver, holder) == ThreeState.NO) {
                    this.registerProblem((PsiElement)rDotReference, RBundle.message((String)"inspection.redundant.safe.navigation.warning"), new RubyRedundantSafeNavigationFix());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rDotReference", "org/jetbrains/plugins/ruby/ruby/inspections/nilanalysis/RubyRedundantSafeNavigationInspection$1", "visitRDotReference"));
            }
        };
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.stringList((String)"myIgnoredReceivers", (String)RBundle.message((String)"inspection.references.list.table.title"))});
        if (optPane == null) {
            RubyRedundantSafeNavigationInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onValue("myIgnoredReceivers", () -> StreamEx.of(this.myIgnoredReceivers).map(RubyReferencesListTableFactory.Reference::get).toMutableList(), newList -> {
            this.myIgnoredReceivers.clear();
            StreamEx.of((Collection)newList).map(RubyReferencesListTableFactory.Reference::new).into(this.myIgnoredReceivers);
        });
        if (optionController == null) {
            RubyRedundantSafeNavigationInspection.$$$reportNull$$$0(2);
        }
        return optionController;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/nilanalysis/RubyRedundantSafeNavigationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/nilanalysis/RubyRedundantSafeNavigationInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    public static class RubyRedundantSafeNavigationFix
    extends RubyFix {
        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            if (project == null) {
                RubyRedundantSafeNavigationFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                RubyRedundantSafeNavigationFix.$$$reportNull$$$0(1);
            }
            RDotReference element = (RDotReference)descriptor.getPsiElement();
            RDotReference generated = RubyRedundantSafeNavigationFix.deleteSafeNavigation(element);
            element.replace((PsiElement)generated);
        }

        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.redundant.safe.navigation.message");
            if (string == null) {
                RubyRedundantSafeNavigationFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        private static RDotReference deleteSafeNavigation(@NotNull RDotReference element) {
            if (element == null) {
                RubyRedundantSafeNavigationFix.$$$reportNull$$$0(3);
            }
            RPsiElement receiver = element.getReceiver();
            RPsiElement command = (RPsiElement)element.getPsiCommand();
            assert (receiver != null);
            assert (command != null);
            String replacedText = receiver.getText() + "." + command.getText();
            RDotReference rDotReference = (RDotReference)RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)replacedText);
            if (rDotReference == null) {
                RubyRedundantSafeNavigationFix.$$$reportNull$$$0(4);
            }
            return rDotReference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/nilanalysis/RubyRedundantSafeNavigationInspection$RubyRedundantSafeNavigationFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/nilanalysis/RubyRedundantSafeNavigationInspection$RubyRedundantSafeNavigationFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "deleteSafeNavigation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteSafeNavigation";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    }
}

