/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.naming;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyRenameFix;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.ConventionInspection;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.search.overriden.RubySuperMethodsSearch;

public class RubyInstanceMethodNamingConventionInspection
extends ConventionInspection {
    public static final String DEFAULT_REGEX = TextUtil.IDENTIFIER_LOWERCASE_PATTERN.pattern() + "[!?=]?";
    private static final int DEFAULT_MIN_LENGTH = 2;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @Override
    protected String getDefaultRegex() {
        return DEFAULT_REGEX;
    }

    @Override
    protected int getDefaultMinLength() {
        return 2;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    protected RubyFix buildFix(PsiElement location) {
        return new RubyRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            String string = RBundle.message((String)"method.name.ref.is.too.short");
            if (string == null) {
                RubyInstanceMethodNamingConventionInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (className.length() > this.getMaxLength()) {
            String string = RBundle.message((String)"method.name.ref.is.too.long");
            if (string == null) {
                RubyInstanceMethodNamingConventionInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = RBundle.message((String)"method.name.ref.doesn.t.match.regex", (Object[])new Object[]{this.getRegex()});
        if (string == null) {
            RubyInstanceMethodNamingConventionInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public RubyInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/ruby/inspections/naming/RubyInstanceMethodNamingConventionInspection", "buildErrorString"));
    }

    private class NamingConventionsVisitor
    extends RubyInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitRMethod(@NotNull RMethod rMethod) {
            if (rMethod == null) {
                NamingConventionsVisitor.$$$reportNull$$$0(0);
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)rMethod, RContainer.class) instanceof RObjectClass) {
                return;
            }
            String name = rMethod.getName();
            if (RubyInstanceMethodNamingConventionInspection.this.isValid(name, (PsiElement)rMethod) || RubySuperMethodsSearch.search(rMethod).findFirst() != null) {
                return;
            }
            this.registerMethodError(rMethod, name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rMethod", "org/jetbrains/plugins/ruby/ruby/inspections/naming/RubyInstanceMethodNamingConventionInspection$NamingConventionsVisitor", "visitRMethod"));
        }
    }
}

