/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.naming;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyRenameFix;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.ConventionInspection;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;

public final class RubyConstantNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 2;
    private static final int DEFAULT_MAX_LENGTH = 64;
    private static final String RUBY_NAME_CONVENTION_CLASS = "Class.new";
    private static final String RUBY_NAME_CONVENTION_STRUCT = "Struct.new";

    @Override
    protected String getDefaultRegex() {
        return TextUtil.CONST_PATTERN.pattern();
    }

    @Override
    protected int getDefaultMinLength() {
        return 2;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 64;
    }

    @Override
    protected RubyFix buildFix(PsiElement location) {
        return new RubyRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            String string = RBundle.message((String)"constant.name.ref.is.too.short");
            if (string == null) {
                RubyConstantNamingConventionInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (className.length() > this.getMaxLength()) {
            String string = RBundle.message((String)"constant.name.ref.is.too.long");
            if (string == null) {
                RubyConstantNamingConventionInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = RBundle.message((String)"constant.name.ref.doesn.t.match.regex", (Object[])new Object[]{this.getRegex()});
        if (string == null) {
            RubyConstantNamingConventionInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public RubyInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/ruby/inspections/naming/RubyConstantNamingConventionInspection", "buildErrorString"));
    }

    private class NamingConventionsVisitor
    extends RubyInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitRConstant(@NotNull RConstant rConstant) {
            RPsiElement structOrClassExpr;
            if (rConstant == null) {
                NamingConventionsVisitor.$$$reportNull$$$0(0);
            }
            if (!RubyPsiUtilCore.isDeclaration((PsiElement)rConstant)) {
                return;
            }
            String name = rConstant.getName();
            if (RubyConstantNamingConventionInspection.this.isValid(name, (PsiElement)rConstant)) {
                return;
            }
            String typeName = rConstant.getType().getPresentableName();
            if ("Class".equals(typeName) || "Struct".equals(typeName)) {
                return;
            }
            PsiElement assignmentExpr = rConstant.getParent();
            if (assignmentExpr instanceof RAssignmentExpression && (structOrClassExpr = ((RAssignmentExpression)assignmentExpr).getValue()) != null) {
                String structClassPattern = structOrClassExpr.getText();
                if (structOrClassExpr instanceof RCall) {
                    structClassPattern = ((RCall)structOrClassExpr).getCommand();
                } else if (structOrClassExpr instanceof RDoBlockCall) {
                    structClassPattern = ((RDoBlockCall)structOrClassExpr).getCall().getText();
                }
                if (RubyConstantNamingConventionInspection.RUBY_NAME_CONVENTION_CLASS.equals(structClassPattern) || RubyConstantNamingConventionInspection.RUBY_NAME_CONVENTION_STRUCT.equals(structClassPattern)) {
                    return;
                }
            }
            this.registerConstantError(rConstant, name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rConstant", "org/jetbrains/plugins/ruby/ruby/inspections/naming/RubyConstantNamingConventionInspection$NamingConventionsVisitor", "visitRConstant"));
        }
    }
}

