/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.naming;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyRenameFix;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.ConventionInspection;
import org.jetbrains.plugins.ruby.ruby.lang.RubyTextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public final class RubyClassModuleNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 2;
    private static final int DEFAULT_MAX_LENGTH = 64;

    @Override
    protected String getDefaultRegex() {
        return RubyTextUtil.CID_PATTERN.pattern();
    }

    @Override
    protected int getDefaultMinLength() {
        return 2;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 64;
    }

    @Override
    protected RubyFix buildFix(PsiElement location) {
        return new RubyRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            String string = RBundle.message((String)"class.module.name.ref.is.too.short");
            if (string == null) {
                RubyClassModuleNamingConventionInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (className.length() > this.getMaxLength()) {
            String string = RBundle.message((String)"class.module.name.ref.is.too.long");
            if (string == null) {
                RubyClassModuleNamingConventionInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = RBundle.message((String)"class.module.name.ref.doesn.t.match.regex", (Object[])new Object[]{this.getRegex()});
        if (string == null) {
            RubyClassModuleNamingConventionInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public RubyInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/ruby/inspections/naming/RubyClassModuleNamingConventionInspection", "buildErrorString"));
    }

    private class NamingConventionsVisitor
    extends RubyInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitRClass(@NotNull RClass rClass) {
            if (rClass == null) {
                NamingConventionsVisitor.$$$reportNull$$$0(0);
            }
            this.checkClassOrModule((RContainer)rClass);
        }

        public void visitRModule(@NotNull RModule rModule) {
            if (rModule == null) {
                NamingConventionsVisitor.$$$reportNull$$$0(1);
            }
            this.checkClassOrModule((RContainer)rModule);
        }

        private void checkClassOrModule(RContainer container) {
            String name = container.getName();
            if (RubyClassModuleNamingConventionInspection.this.isValid(name, (PsiElement)container)) {
                return;
            }
            this.registerContainerError(container, name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rModule";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/naming/RubyClassModuleNamingConventionInspection$NamingConventionsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRModule";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

