/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.mismatchedTypes;

import com.intellij.codeInspection.options.OptCheckbox;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.intellij.lang.annotations.Language;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;

final class RubyMismatchedTypeInspectionUtil {
    private RubyMismatchedTypeInspectionUtil() {
    }

    @NotNull
    public static OptRegularComponent createOptCheckNilabilityComponent(@Language(value="jvm-field-name") @NotNull String bindId) {
        if (bindId == null) {
            RubyMismatchedTypeInspectionUtil.$$$reportNull$$$0(0);
        }
        OptCheckbox optCheckbox = OptPane.checkbox((String)bindId, (String)RBundle.message((String)"inspection.mismatched.type.nilability.setting"), (OptRegularComponent[])new OptRegularComponent[0]);
        if (optCheckbox == null) {
            RubyMismatchedTypeInspectionUtil.$$$reportNull$$$0(1);
        }
        return optCheckbox;
    }

    @NotNull
    public static <T> List<? extends OptRegularComponent> createOptExtensionComponents(@NotNull ExtensionPointName<T> epName, @NotNull Function<T, String> idProvider, @NotNull Function<T, @Nullable String> displayNameProvider, @NotNull String bindPrefix) {
        if (epName == null) {
            RubyMismatchedTypeInspectionUtil.$$$reportNull$$$0(2);
        }
        if (idProvider == null) {
            RubyMismatchedTypeInspectionUtil.$$$reportNull$$$0(3);
        }
        if (displayNameProvider == null) {
            RubyMismatchedTypeInspectionUtil.$$$reportNull$$$0(4);
        }
        if (bindPrefix == null) {
            RubyMismatchedTypeInspectionUtil.$$$reportNull$$$0(5);
        }
        ArrayList<OptCheckbox> components = new ArrayList<OptCheckbox>();
        for (Object extension : ContainerUtil.sorted((Collection)epName.getExtensionList(), Comparator.comparing(displayNameProvider, Comparator.nullsFirst(Comparator.naturalOrder())))) {
            String displayName = displayNameProvider.apply(extension);
            if (displayName == null) continue;
            String label = RBundle.message((String)"inspection.mismatched.type.extension.setting.prefix", (Object[])new Object[]{displayName});
            components.add(OptPane.checkbox((String)idProvider.apply(extension), (String)label, (OptRegularComponent[])new OptRegularComponent[0]).prefix(bindPrefix));
        }
        ArrayList<OptCheckbox> arrayList = components;
        if (arrayList == null) {
            RubyMismatchedTypeInspectionUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public static OptionController createOptionController(@NotNull Set<String> disabledIds) {
        if (disabledIds == null) {
            RubyMismatchedTypeInspectionUtil.$$$reportNull$$$0(7);
        }
        return RubyMismatchedTypeInspectionUtil.createOptionController(key -> !disabledIds.contains(key), (key, value) -> {
            if (value.booleanValue()) {
                disabledIds.remove(key);
            } else {
                disabledIds.add((String)key);
            }
        });
    }

    @NotNull
    public static OptionController createOptionController(@NotNull Function<String, Boolean> getter, @NotNull BiConsumer<String, Boolean> setter) {
        if (getter == null) {
            RubyMismatchedTypeInspectionUtil.$$$reportNull$$$0(8);
        }
        if (setter == null) {
            RubyMismatchedTypeInspectionUtil.$$$reportNull$$$0(9);
        }
        OptionController optionController = OptionController.of(key -> getter.apply((String)key), (key, value) -> {
            Boolean bool;
            setter.accept((String)key, value instanceof Boolean ? (bool = (Boolean)value) : Boolean.valueOf(false));
        });
        if (optionController == null) {
            RubyMismatchedTypeInspectionUtil.$$$reportNull$$$0(10);
        }
        return optionController;
    }

    public static boolean readCheckNilabilitySetting(@NotNull Element node) {
        if (node == null) {
            RubyMismatchedTypeInspectionUtil.$$$reportNull$$$0(11);
        }
        for (Element option : node.getChildren("option")) {
            if (!"myCheckNilability".equals(option.getAttributeValue("name"))) continue;
            return Boolean.parseBoolean((String)ObjectUtils.coalesce((Object)option.getAttributeValue("value"), (Object)"true"));
        }
        return true;
    }

    @NotNull
    public static List<Pair<String, Boolean>> readExtensionSettings(@NotNull Element node) {
        if (node == null) {
            RubyMismatchedTypeInspectionUtil.$$$reportNull$$$0(12);
        }
        ArrayList<Pair<String, Boolean>> settings = new ArrayList<Pair<String, Boolean>>();
        for (Element extension : node.getChildren("extension")) {
            String id = extension.getAttributeValue("id");
            if (id == null) continue;
            settings.add((Pair<String, Boolean>)new Pair((Object)id, (Object)Boolean.parseBoolean((String)ObjectUtils.coalesce((Object)extension.getAttributeValue("enabled"), (Object)"true"))));
        }
        ArrayList<Pair<String, Boolean>> arrayList = settings;
        if (arrayList == null) {
            RubyMismatchedTypeInspectionUtil.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    public static void writeCheckNilabilitySetting(@NotNull Element node, boolean checkNilability) {
        if (node == null) {
            RubyMismatchedTypeInspectionUtil.$$$reportNull$$$0(14);
        }
        if (!checkNilability) {
            node.addContent(new Element("option").setAttribute("name", "myCheckNilability").setAttribute("value", "false"));
        }
    }

    public static void writeExtensionSettings(@NotNull Element node, @NotNull Set<String> disabledIds) {
        if (node == null) {
            RubyMismatchedTypeInspectionUtil.$$$reportNull$$$0(15);
        }
        if (disabledIds == null) {
            RubyMismatchedTypeInspectionUtil.$$$reportNull$$$0(16);
        }
        for (String id : disabledIds) {
            node.addContent(new Element("extension").setAttribute("id", id).setAttribute("enabled", "false"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindId";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/mismatchedTypes/RubyMismatchedTypeInspectionUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayNameProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindPrefix";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledIds";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/mismatchedTypes/RubyMismatchedTypeInspectionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptCheckNilabilityComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptExtensionComponents";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionController";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "readExtensionSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createOptCheckNilabilityComponent";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 13: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createOptExtensionComponents";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createOptionController";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readCheckNilabilitySetting";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readExtensionSettings";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writeCheckNilabilitySetting";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "writeExtensionSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 10, 13 -> new IllegalStateException(string);
        };
    }
}

