/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.mismatchedTypes;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeWithNilability;
import org.jetbrains.plugins.ruby.ruby.inspections.mismatchedTypes.RubyExpectedReturnTypeProvider;
import org.jetbrains.plugins.ruby.ruby.inspections.mismatchedTypes.RubyMismatchedTypeInspectionUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.mismatchedTypes.RubyMismatchedTypeVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.RControlFlowUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RReturnStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;

public final class RubyMismatchedReturnTypeInspection
extends LocalInspectionTool {
    private final Set<String> myDisabledExpectedTypeProviders = new TreeSet<String>();
    private boolean myCheckNilability = true;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyMismatchedReturnTypeInspection.$$$reportNull$$$0(0);
        }
        if (RubyPsiUtil.isRbiFile(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                RubyMismatchedReturnTypeInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new MyVisitor(holder, this.myDisabledExpectedTypeProviders, this.myCheckNilability);
    }

    @NotNull
    public OptPane getOptionsPane() {
        ArrayList<OptRegularComponent> components = new ArrayList<OptRegularComponent>(RubyMismatchedTypeInspectionUtil.createOptExtensionComponents(RubyExpectedReturnTypeProvider.EP_NAME, it -> it.getId(), it -> it.getDisplayName(), "RubyExpectedTypeProvider"));
        components.add(RubyMismatchedTypeInspectionUtil.createOptCheckNilabilityComponent("myCheckNilability"));
        OptPane optPane = OptPane.pane((OptRegularComponent[])components.toArray(new OptRegularComponent[0]));
        if (optPane == null) {
            RubyMismatchedReturnTypeInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onPrefix("RubyExpectedTypeProvider", RubyMismatchedTypeInspectionUtil.createOptionController(this.myDisabledExpectedTypeProviders));
        if (optionController == null) {
            RubyMismatchedReturnTypeInspection.$$$reportNull$$$0(3);
        }
        return optionController;
    }

    public void readSettings(@NotNull Element node) {
        if (node == null) {
            RubyMismatchedReturnTypeInspection.$$$reportNull$$$0(4);
        }
        for (Pair<String, Boolean> extension : RubyMismatchedTypeInspectionUtil.readExtensionSettings(node)) {
            if (((Boolean)extension.getSecond()).booleanValue()) continue;
            this.myDisabledExpectedTypeProviders.add((String)extension.getFirst());
        }
        this.myCheckNilability = RubyMismatchedTypeInspectionUtil.readCheckNilabilitySetting(node);
    }

    @TestOnly
    public void setDisabledExpectedTypeProviders(@NotNull Set<String> disabledExpectedTypeProviders) {
        if (disabledExpectedTypeProviders == null) {
            RubyMismatchedReturnTypeInspection.$$$reportNull$$$0(5);
        }
        this.myDisabledExpectedTypeProviders.clear();
        this.myDisabledExpectedTypeProviders.addAll(disabledExpectedTypeProviders);
    }

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            RubyMismatchedReturnTypeInspection.$$$reportNull$$$0(6);
        }
        RubyMismatchedTypeInspectionUtil.writeExtensionSettings(node, this.myDisabledExpectedTypeProviders);
        RubyMismatchedTypeInspectionUtil.writeCheckNilabilitySetting(node, this.myCheckNilability);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/mismatchedTypes/RubyMismatchedReturnTypeInspection";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledExpectedTypeProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/mismatchedTypes/RubyMismatchedReturnTypeInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setDisabledExpectedTypeProviders";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    private static final class MyVisitor
    extends RubyMismatchedTypeVisitor {
        private final Set<String> myDisabledExpectedTypeProviders;
        private final boolean myCheckNilability;

        private MyVisitor(@NotNull ProblemsHolder holder, @NotNull Set<String> disabledExpectedTypeProviders, boolean checkNilability) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (disabledExpectedTypeProviders == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            super(holder);
            this.myDisabledExpectedTypeProviders = Set.copyOf(disabledExpectedTypeProviders);
            this.myCheckNilability = checkNilability;
        }

        public void visitRCodeBlock(@NotNull RCodeBlock block) {
            RBlockCall call;
            if (block == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if ((call = RBlockCallNavigator.getByBlock((RCodeBlock)block)) == null) {
                return;
            }
            for (RubyExpectedReturnTypeProvider extension : this.getEnabledExpectedTypeProviders()) {
                RTypeWithNilability returnTypeWithNilability = extension.getExpectedReturnTypeWithNilability(call, block);
                if (returnTypeWithNilability == null) continue;
                for (PsiElement element : ContainerUtil.mapNotNull((Collection)RControlFlowUtil.findExitInstructions((ControlFlow)block.getControlFlow()), Instruction::getElement)) {
                    RListOfExpressions returns = (RListOfExpressions)ObjectUtils.doIfCast((Object)element, RReturnStatement.class, RReturnStatement::getReturnList);
                    PsiElement highlightedElement = (PsiElement)ObjectUtils.coalesce((Object)returns, (Object)element);
                    if (highlightedElement.getTextRange().isEmpty()) continue;
                    RTypeWithNilability actualTypeWithNilability = RTypeWithNilability.fromPsiElement(element);
                    RType expectedType = returnTypeWithNilability.getType();
                    RType actualType = actualTypeWithNilability.getType();
                    this.checkExpectedType(expectedType, actualType, highlightedElement, extension.getMismatchedTypeQuickFixes(highlightedElement));
                    if (!this.myCheckNilability) continue;
                    this.checkExpectedNilability(returnTypeWithNilability, actualTypeWithNilability, highlightedElement, extension.getMismatchedTypeQuickFixes(highlightedElement));
                }
            }
        }

        public void visitRMethod(@NotNull RMethod method) {
            if (method == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if (method.isConstructor()) {
                return;
            }
            for (RubyExpectedReturnTypeProvider extension : this.getEnabledExpectedTypeProviders()) {
                RTypeWithNilability returnTypeWithNilability = extension.getExpectedReturnTypeWithNilability(method);
                if (returnTypeWithNilability == null) continue;
                for (PsiElement element : ContainerUtil.mapNotNull((Collection)RControlFlowUtil.findExitInstructions((ControlFlow)method.getControlFlow()), Instruction::getElement)) {
                    RListOfExpressions returns = (RListOfExpressions)ObjectUtils.doIfCast((Object)element, RReturnStatement.class, RReturnStatement::getReturnList);
                    PsiElement highlightedElement = (PsiElement)ObjectUtils.coalesce((Object)returns, (Object)element);
                    if (highlightedElement.getTextRange().isEmpty()) continue;
                    RTypeWithNilability actualTypeWithNilability = RTypeWithNilability.fromPsiElement(element);
                    RType expectedType = returnTypeWithNilability.getType();
                    RType actualType = actualTypeWithNilability.getType();
                    this.checkExpectedType(expectedType, actualType, highlightedElement, extension.getMismatchedTypeQuickFixes(highlightedElement));
                    if (!this.myCheckNilability) continue;
                    this.checkExpectedNilability(returnTypeWithNilability, actualTypeWithNilability, highlightedElement, extension.getMismatchedTypeQuickFixes(highlightedElement));
                }
            }
        }

        public void visitRSingletonMethod(@NotNull RSingletonMethod method) {
            if (method == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            this.visitRMethod((RMethod)method);
        }

        @NotNull
        private List<RubyExpectedReturnTypeProvider> getEnabledExpectedTypeProviders() {
            List list = ContainerUtil.filter((Collection)RubyExpectedReturnTypeProvider.EP_NAME.getExtensionList(), it -> !this.myDisabledExpectedTypeProviders.contains(it.getId()));
            if (list == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disabledExpectedTypeProviders";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/mismatchedTypes/RubyMismatchedReturnTypeInspection$MyVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/mismatchedTypes/RubyMismatchedReturnTypeInspection$MyVisitor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnabledExpectedTypeProviders";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRCodeBlock";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRMethod";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRSingletonMethod";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

