/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.literalarray;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RBaseString;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RWords;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.baseString.RDStringLiteralImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.baseString.RStringLiteralImpl;

public final class RubyLiteralArrayInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyLiteralArrayInspection.$$$reportNull$$$0(0);
        }
        return new RubyLiteralArrayVisitor(holder, isOnTheFly);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/ruby/ruby/inspections/literalarray/RubyLiteralArrayInspection", "buildVisitor"));
    }

    private static class RubyLiteralArrayVisitor
    extends RubyInspectionVisitor {
        RubyLiteralArrayVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
            if (holder == null) {
                RubyLiteralArrayVisitor.$$$reportNull$$$0(0);
            }
            super(holder, isOnTheFly);
        }

        private static String @Nullable [] getBoundSymbols(List<RPsiElement> elements) {
            String[] stringArray;
            ArrayList startSymbols = new ArrayList();
            ArrayList endSymbols = new ArrayList();
            Collections.addAll(startSymbols, "[", "(", "{", "|", "<", "_", "&", "+", "-", "*", "=");
            Collections.addAll(endSymbols, "]", ")", "}", "|", ">", "_", "&", "+", "-", "*", "=");
            for (RPsiElement e : elements) {
                String content = ((RStringLiteral)e).getContent();
                int index = startSymbols.indexOf(content);
                if (index == -1) {
                    index = endSymbols.indexOf(content);
                }
                if (index == -1) continue;
                startSymbols.remove(index);
                endSymbols.remove(index);
            }
            if (!startSymbols.isEmpty()) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = (String)startSymbols.get(0);
                stringArray = stringArray2;
                stringArray2[1] = (String)endSymbols.get(0);
            } else {
                stringArray = null;
            }
            return stringArray;
        }

        public void visitRArray(@NotNull RArray array) {
            List elements;
            if (array == null) {
                RubyLiteralArrayVisitor.$$$reportNull$$$0(1);
            }
            if ((elements = array.getElements()).size() <= 1) {
                return;
            }
            boolean singleQuoted = true;
            boolean doubleQuoted = true;
            boolean withoutSpaces = true;
            boolean withoutExpressions = true;
            boolean hasComments = false;
            for (RPsiElement element : elements) {
                if (!(element instanceof RStringLiteralImpl)) {
                    singleQuoted = false;
                }
                if (!(element instanceof RDStringLiteralImpl)) {
                    doubleQuoted = false;
                }
                if (element instanceof RBaseString) {
                    RBaseString string = (RBaseString)element;
                    String content = string.getContent();
                    if (content.isEmpty() || content.contains(" ")) {
                        withoutSpaces = false;
                    }
                    if (string.hasExpressionSubstitutions()) {
                        withoutExpressions = false;
                    }
                }
                hasComments |= RubyCommentsUtil.getArrayElementComment((PsiElement)element) != null;
                if ((singleQuoted || doubleQuoted) && withoutSpaces && (withoutExpressions || doubleQuoted)) continue;
                break;
            }
            if (!singleQuoted && !doubleQuoted || !withoutSpaces || !withoutExpressions && !doubleQuoted) {
                return;
            }
            String[] boundSymbols = RubyLiteralArrayVisitor.getBoundSymbols(elements);
            if (boundSymbols != null) {
                ProblemHighlightType highlightType;
                if (hasComments) {
                    if (!this.myOnTheFly) {
                        return;
                    }
                    highlightType = ProblemHighlightType.INFORMATION;
                } else {
                    highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                }
                this.registerProblem((PsiElement)array, RBundle.message((String)"inspection.literal.array"), highlightType, new RubyLiteralArrayFix(boundSymbols));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/literalarray/RubyLiteralArrayInspection$RubyLiteralArrayVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRArray";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RubyLiteralArrayFix
    extends RubyFix {
        private final String[] boundSymbols;

        RubyLiteralArrayFix(String[] symbols) {
            this.boundSymbols = symbols;
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element;
            if (project == null) {
                RubyLiteralArrayFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                RubyLiteralArrayFix.$$$reportNull$$$0(1);
            }
            if (!((element = descriptor.getPsiElement()) instanceof RArray)) {
                return;
            }
            String text = this.constructWordsText((RArray)element);
            if (text != null) {
                RWords generated = (RWords)RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)text);
                element.replace((PsiElement)generated);
            }
        }

        @Nullable
        private String constructWordsText(RArray element) {
            StringBuilder builder2 = new StringBuilder();
            List elements = element.getElements();
            if (this.boundSymbols == null) {
                return null;
            }
            boolean hasExpressionsOrBackslash = false;
            for (RPsiElement e : elements) {
                RBaseString string = (RBaseString)e;
                if (!string.hasExpressionSubstitutions() && (!(string instanceof RDStringLiteralImpl) || !string.getContent().contains("\\"))) continue;
                hasExpressionsOrBackslash = true;
                break;
            }
            builder2.append(hasExpressionsOrBackslash ? "%W" + this.boundSymbols[0] : "%w" + this.boundSymbols[0]);
            for (RPsiElement e : elements) {
                String content = ((RStringLiteral)e).getContent();
                builder2.append(content).append(" ");
            }
            builder2.deleteCharAt(builder2.length() - 1);
            builder2.append(this.boundSymbols[1]);
            return builder2.toString();
        }

        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.literal.array.msg");
            if (string == null) {
                RubyLiteralArrayFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/literalarray/RubyLiteralArrayInspection$RubyLiteralArrayFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/literalarray/RubyLiteralArrayInspection$RubyLiteralArrayFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

