/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.largeclass;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.testing.testunit.RTestUnitUtil;

public final class RubyTooManyMethodsInspection
extends LocalInspectionTool {
    private static final int DEFAULT_METHOD_COUNT_LIMIT = 25;
    public int m_limit = 25;
    public boolean ignoreTestClasses = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"m_limit", (String)RBundle.message((String)"inspection.large.class.methods.property"), (int)2, (int)1000), OptPane.checkbox((String)"ignoreTestClasses", (String)RBundle.message((String)"inspection.large.class.methods.checkbox.name"), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            RubyTooManyMethodsInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyTooManyMethodsInspection.$$$reportNull$$$0(1);
        }
        return new RubyTooManyMethodsVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/largeclass/RubyTooManyMethodsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/largeclass/RubyTooManyMethodsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private class RubyTooManyMethodsVisitor
    extends RubyInspectionVisitor {
        RubyTooManyMethodsVisitor(ProblemsHolder holder) {
            super(holder);
        }

        public void visitRClass(@NotNull RClass rClass) {
            if (rClass == null) {
                RubyTooManyMethodsVisitor.$$$reportNull$$$0(0);
            }
            if (!RubyTooManyMethodsInspection.this.ignoreTestClasses || !RTestUnitUtil.isUnitTestCaseLikeClass(rClass)) {
                this.check(rClass.getMethods(), rClass.getClassName(), rClass.getFQNWithNesting());
            }
        }

        public void visitRModule(@NotNull RModule rModule) {
            if (rModule == null) {
                RubyTooManyMethodsVisitor.$$$reportNull$$$0(1);
            }
            this.check(rModule.getMethods(), rModule.getModuleName(), rModule.getFQNWithNesting());
        }

        private void check(@NotNull List<RMethod> methods, @Nullable RName name, @NotNull FQN fqn) {
            if (methods == null) {
                RubyTooManyMethodsVisitor.$$$reportNull$$$0(2);
            }
            if (fqn == null) {
                RubyTooManyMethodsVisitor.$$$reportNull$$$0(3);
            }
            if (methods.size() > RubyTooManyMethodsInspection.this.m_limit) {
                this.registerProblem((PsiElement)name, RBundle.message((String)"inspection.large.class.methods", (Object[])new Object[]{fqn.getFullPath(), methods.size()}));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rModule";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methods";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/largeclass/RubyTooManyMethodsInspection$RubyTooManyMethodsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRModule";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "check";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

