/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.hash;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.mongoid.MongoidUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.inspections.hash.RubyHashUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyTextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RBaseString;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.testing.testunit.RTestUnitUtil;

public final class RubyStringKeysInHashInspection
extends LocalInspectionTool {
    private static final RubyFix STRING_KEYS_IN_HASH_FIX = new RubyFix(){

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            if (project == null) {
                1.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                1.$$$reportNull$$$0(1);
            }
            PsiElement string = descriptor.getPsiElement();
            assert (string instanceof RBaseString);
            RBaseString rdString = (RBaseString)string;
            PsiElement beginning = rdString.getStringBeginning();
            PsiElement ending = rdString.getStringEnding();
            if (beginning != null && ending != null) {
                String text = ":" + rdString.getContent();
                rdString.replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)rdString, (String)text));
            }
        }

        @NotNull
        @Nls
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.hash.double.quoted.keys.fix");
            if (string == null) {
                1.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/hash/RubyStringKeysInHashInspection$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/hash/RubyStringKeysInHashInspection$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    };

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyStringKeysInHashInspection.$$$reportNull$$$0(0);
        }
        return new RubyHashKeysVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/ruby/ruby/inspections/hash/RubyStringKeysInHashInspection", "buildVisitor"));
    }

    private static class RubyHashKeysVisitor
    extends RubyInspectionVisitor {
        RubyHashKeysVisitor(ProblemsHolder holder) {
            super(holder);
        }

        public void visitRArrayIndexing(@NotNull RArrayIndexing arrayIndexing) {
            if (arrayIndexing == null) {
                RubyHashKeysVisitor.$$$reportNull$$$0(0);
            }
            switch (RubyHashUtil.checkSyntax(arrayIndexing)) {
                case ARRAY_TYPE: {
                    this.checkArray(arrayIndexing.getIndexes());
                    break;
                }
                case ASSOC_TYPE: {
                    this.checkAssocList(arrayIndexing.getIndexes());
                    break;
                }
                case LIST_TYPE: {
                    this.checkList(arrayIndexing.getIndexes());
                    break;
                }
            }
        }

        private void checkList(List<RPsiElement> indexes) {
            for (int i = 0; i < indexes.size(); i += 2) {
                RPsiElement element = indexes.get(i);
                if (!(element instanceof RBaseString) || !RubyTextUtil.isCID((String)((RBaseString)element).getContent())) continue;
                this.registerStringHashKeyProblem(element);
            }
        }

        private void checkAssocList(List<RPsiElement> list) {
            for (RPsiElement element : list) {
                RPsiElement key;
                if (!(element instanceof RAssoc) || !((key = ((RAssoc)element).getKey()) instanceof RBaseString) || !RubyTextUtil.isCID((String)((RBaseString)key).getContent())) continue;
                this.registerStringHashKeyProblem(key);
            }
        }

        private void checkArray(List<RPsiElement> indexes) {
            List<RPsiElement> list = RubyHashUtil.collectKeysFromArray(indexes, false);
            for (RPsiElement element : list) {
                if (!(element instanceof RBaseString) || !RubyTextUtil.isCID((String)((RBaseString)element).getContent())) continue;
                this.registerStringHashKeyProblem(element);
            }
        }

        public void visitRAssocList(@NotNull RAssocList rAssocList) {
            RContainer container;
            if (rAssocList == null) {
                RubyHashKeysVisitor.$$$reportNull$$$0(1);
            }
            if ((container = rAssocList.getParentContainer()) instanceof RClass && MongoidUtil.isMongoidIncluded((RClass)container)) {
                return;
            }
            for (RAssoc assoc : rAssocList.getAssocElements()) {
                RClass klass = RContainerUtil.getFirstClassInFile(assoc.getContainingFile());
                if (klass != null && RTestUnitUtil.isUnitTestCaseLikeClass(klass)) {
                    return;
                }
                RPsiElement key = assoc.getKey();
                if (!(key instanceof RBaseString) || !RubyTextUtil.isCID((String)((RBaseString)key).getContent())) continue;
                this.registerStringHashKeyProblem(key);
            }
        }

        private void registerStringHashKeyProblem(RPsiElement element) {
            this.registerProblem((PsiElement)element, RBundle.message((String)"inspection.hash.double.quoted.keys"), STRING_KEYS_IN_HASH_FIX);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayIndexing";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rAssocList";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/hash/RubyStringKeysInHashInspection$RubyHashKeysVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRArrayIndexing";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRAssocList";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

