/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.hash;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;

public class RubyRemoveHashKeyFix
extends RubyFix {
    private static final Logger LOG = Logger.getInstance(RubyRemoveHashKeyFix.class);

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
        RPsiElement element;
        RPsiElement pair;
        if (project == null) {
            RubyRemoveHashKeyFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            RubyRemoveHashKeyFix.$$$reportNull$$$0(1);
        }
        Object object = pair = (element = (RPsiElement)descriptor.getPsiElement()) instanceof RAssoc ? element : PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{RAssoc.class, RArray.class, RArrayIndexing.class});
        if (pair == null) {
            return;
        }
        PsiElement containingList = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{RAssocList.class, RListOfExpressions.class});
        if (containingList == null) {
            return;
        }
        PsiElement commaLeft = PsiTreeUtil.skipWhitespacesBackward((PsiElement)pair);
        if (RubyRemoveHashKeyFix.isComma(commaLeft)) {
            containingList.deleteChildRange(commaLeft, (PsiElement)pair);
        } else {
            PsiElement nextAssocKey = PsiTreeUtil.getNextSiblingOfType((PsiElement)pair, RAssoc.class);
            LOG.assertTrue(nextAssocKey != null, (Object)"Duplicated hash key shouldn't be null.");
            PsiElement childBeforeNextAssoc = PsiTreeUtil.getPrevSiblingOfType((PsiElement)nextAssocKey, PsiElement.class);
            LOG.assertTrue(childBeforeNextAssoc != null, (Object)"Child before duplicated hash key shouldn't be null.");
            containingList.deleteChildRange((PsiElement)pair, childBeforeNextAssoc);
        }
    }

    private static boolean isComma(PsiElement comma) {
        return comma != null && comma.getNode().getElementType() == RubyTokenTypes.tCOMMA;
    }

    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"inspection.duplicated.keys.in.hash.fix.delete");
        if (string == null) {
            RubyRemoveHashKeyFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/hash/RubyRemoveHashKeyFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/hash/RubyRemoveHashKeyFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

