/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.fortoforeach;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RForStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RRangeExpression;

public class RubyForLoopFix
extends RubyFix {
    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
        if (project == null) {
            RubyForLoopFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            RubyForLoopFix.$$$reportNull$$$0(1);
        }
        PsiElement element = descriptor.getPsiElement();
        PsiElement parent = element.getParent();
        RPsiElement replacement = RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)RubyForLoopFix.createReplacementText((RForStatement)parent));
        parent.replace((PsiElement)replacement);
    }

    private static String createReplacementText(RForStatement forStatement) {
        String variables = forStatement.getVariable().getText();
        RPsiElement loopExpression = forStatement.getExpression();
        Object expression = loopExpression instanceof RRangeExpression ? "(" + loopExpression.getText() + ")" : loopExpression.getText();
        int startOffset = loopExpression.getTextRange().getEndOffset() - forStatement.getTextRange().getStartOffset();
        ASTNode endToken = forStatement.getEndToken();
        int endOffset = endToken != null ? endToken.getStartOffset() - forStatement.getTextRange().getStartOffset() : 0;
        String body = forStatement.getText().substring(startOffset, endOffset);
        if (body.startsWith(" do\n")) {
            body = body.replaceFirst("\\s+do\\n", "\n");
        }
        return (String)expression + ".each { |" + variables + "|" + body + "}";
    }

    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"inspection.for.to.each.quickfix.message");
        if (string == null) {
            RubyForLoopFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/fortoforeach/RubyForLoopFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/fortoforeach/RubyForLoopFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

