/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.fixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.RefactoringQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringFactory;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;

public class RubyRenameFix
extends RubyFix
implements RefactoringQuickFix {
    private final String targetName;

    public RubyRenameFix() {
        this(null);
    }

    public RubyRenameFix(@NonNls @Nullable String targetName) {
        this.targetName = targetName;
    }

    @NotNull
    public String getName() {
        if (this.targetName == null) {
            String string = RBundle.message((String)"rename.quick.fix.name");
            if (string == null) {
                RubyRenameFix.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = RBundle.message((String)"rename.quick.fix.name.to", (Object[])new Object[]{this.targetName});
        if (string == null) {
            RubyRenameFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @Nls
    public String getFamilyName() {
        String string = RBundle.message((String)"rename.quick.fix.family.name");
        if (string == null) {
            RubyRenameFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            RubyRenameFix.$$$reportNull$$$0(3);
        }
        if (previewDescriptor == null) {
            RubyRenameFix.$$$reportNull$$$0(4);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            RubyRenameFix.$$$reportNull$$$0(5);
        }
        return intentionPreviewInfo;
    }

    @Override
    public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            RubyRenameFix.$$$reportNull$$$0(6);
        }
        if (descriptor == null) {
            RubyRenameFix.$$$reportNull$$$0(7);
        }
        PsiElement element = descriptor.getPsiElement();
        if (this.targetName == null) {
            this.doFix(descriptor.getPsiElement());
        } else {
            PsiElement elementToRename = element instanceof RName ? element.getParent() : element;
            RefactoringFactory.getInstance((Project)project).createRename(elementToRename, this.targetName).run();
        }
    }

    @NotNull
    public RefactoringActionHandler getHandler() {
        RefactoringActionHandler refactoringActionHandler = RefactoringActionHandlerFactory.getInstance().createRenameHandler();
        if (refactoringActionHandler == null) {
            RubyRenameFix.$$$reportNull$$$0(8);
        }
        return refactoringActionHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/fixes/RubyRenameFix";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/fixes/RubyRenameFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

