/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.expressioninstring;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.IncorrectOperationException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;

public final class RubyExpressionInStringInspection
extends LocalInspectionTool {
    private static final Pattern PATTERN = Pattern.compile(".*[^\\\\]#\\{.*\\}.*");

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyExpressionInStringInspection.$$$reportNull$$$0(0);
        }
        return new ExpressionInStringVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/ruby/ruby/inspections/expressioninstring/RubyExpressionInStringInspection", "buildVisitor"));
    }

    private static class ExpressionInStringVisitor
    extends RubyInspectionVisitor {
        ExpressionInStringVisitor(ProblemsHolder holder) {
            super(holder);
        }

        public void visitRStringLiteral(@NotNull RStringLiteral rStringLiteral) {
            Matcher matcher;
            if (rStringLiteral == null) {
                ExpressionInStringVisitor.$$$reportNull$$$0(0);
            }
            if ((matcher = PATTERN.matcher(rStringLiteral.getContent())).matches()) {
                this.registerProblem((PsiElement)rStringLiteral, RBundle.message((String)"inspection.expression.in.string"), new ExpressionInStringFix());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rStringLiteral", "org/jetbrains/plugins/ruby/ruby/inspections/expressioninstring/RubyExpressionInStringInspection$ExpressionInStringVisitor", "visitRStringLiteral"));
        }
    }

    private static class ExpressionInStringFix
    extends RubyFix {
        private ExpressionInStringFix() {
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element;
            RStringLiteral string;
            if (project == null) {
                ExpressionInStringFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                ExpressionInStringFix.$$$reportNull$$$0(1);
            }
            if ((string = (RStringLiteral)(element = descriptor.getPsiElement())) == null) {
                return;
            }
            String text = ExpressionInStringFix.createText(string);
            RStringLiteral newString = (RStringLiteral)RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)text);
            string.replace((PsiElement)newString);
        }

        private static String createText(RStringLiteral string) {
            String content = string.getContent();
            String text = content.replace("\"", "\\\"");
            return "\"" + text + "\"";
        }

        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.expression.in.string.msg");
            if (string == null) {
                ExpressionInStringFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/expressioninstring/RubyExpressionInStringInspection$ExpressionInStringFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/expressioninstring/RubyExpressionInStringInspection$ExpressionInStringFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

