/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.emptyrescue;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RRescueBlock;

public final class RubyEmptyRescueBlockInspection
extends LocalInspectionTool {
    public boolean m_includeComments = true;
    public boolean m_ignoreIgnoreParameter = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_includeComments", (String)RBundle.message((String)"inspection.empty.rescue.block.with.comments.checkbox.label"), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"m_ignoreIgnoreParameter", (String)RBundle.message((String)"inspection.empty.rescue.block.param.underscore.checkbox.label"), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            RubyEmptyRescueBlockInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyEmptyRescueBlockInspection.$$$reportNull$$$0(1);
        }
        return new RubyEmptyRescueBlockVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/emptyrescue/RubyEmptyRescueBlockInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/emptyrescue/RubyEmptyRescueBlockInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private class RubyEmptyRescueBlockVisitor
    extends RubyInspectionVisitor {
        RubyEmptyRescueBlockVisitor(ProblemsHolder holder) {
            super(holder);
        }

        @Override
        protected void registerProblem(PsiElement element, String message) {
            super.registerProblem(element, message);
        }

        public void visitRRescueBlock(@NotNull RRescueBlock block) {
            if (block == null) {
                RubyEmptyRescueBlockVisitor.$$$reportNull$$$0(0);
            }
            if (!this.isRescueBlockEmpty(block)) {
                return;
            }
            RPsiElement variable = block.getReceiver();
            if (variable == null) {
                if (RubyEmptyRescueBlockInspection.this.m_includeComments) {
                    this.registerProblem(block.getFirstChild(), RBundle.message((String)"inspection.empty.rescue.block"), new AddIgnoredCommentToEmptyRescueBlockFix());
                } else {
                    this.registerProblem(block.getFirstChild(), RBundle.message((String)"inspection.empty.rescue.block"));
                }
            } else {
                @NonNls String variableName = variable.getText();
                if (!RubyEmptyRescueBlockInspection.this.m_ignoreIgnoreParameter || !"_".equals(variableName)) {
                    if (RubyEmptyRescueBlockInspection.this.m_includeComments) {
                        this.registerProblem(block.getFirstChild(), RBundle.message((String)"inspection.empty.rescue.block"), new AddIgnoredCommentToEmptyRescueBlockFix());
                    } else {
                        this.registerProblem(block.getFirstChild(), RBundle.message((String)"inspection.empty.rescue.block"));
                    }
                }
            }
        }

        private boolean isRescueBlockEmpty(@NotNull RRescueBlock block) {
            RCompoundStatement compoundStatement;
            if (block == null) {
                RubyEmptyRescueBlockVisitor.$$$reportNull$$$0(1);
            }
            if ((compoundStatement = block.getBody()) != null) {
                if (!compoundStatement.getStatements().isEmpty()) {
                    return false;
                }
                if (RubyEmptyRescueBlockInspection.this.m_includeComments) {
                    return PsiTreeUtil.findChildOfType((PsiElement)compoundStatement, PsiComment.class) == null;
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "block";
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/emptyrescue/RubyEmptyRescueBlockInspection$RubyEmptyRescueBlockVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRRescueBlock";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isRescueBlockEmpty";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AddIgnoredCommentToEmptyRescueBlockFix
    extends RubyFix {
        private AddIgnoredCommentToEmptyRescueBlockFix() {
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement psiElement;
            PsiElement element;
            if (project == null) {
                AddIgnoredCommentToEmptyRescueBlockFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                AddIgnoredCommentToEmptyRescueBlockFix.$$$reportNull$$$0(1);
            }
            if ((element = descriptor.getPsiElement()).getParent() == null || !((psiElement = element.getParent()) instanceof RRescueBlock)) {
                return;
            }
            RRescueBlock block = (RRescueBlock)psiElement;
            PsiComment comment = RubyElementFactoryCore.createPsiComment((Project)project, (String)"# Ignored");
            PsiElement compoundStatement = AddIgnoredCommentToEmptyRescueBlockFix.getCompoundStatementElement((PsiElement)block);
            if (compoundStatement != null) {
                compoundStatement.add((PsiElement)comment);
                CodeEditUtil.markToReformat((ASTNode)block.getNode(), (boolean)true);
            }
        }

        @Nullable
        private static PsiElement getCompoundStatementElement(PsiElement block) {
            for (ASTNode node = block.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
                if (node.getElementType() != RubyElementTypes.COMPOUND_STATEMENT) continue;
                return node.getPsi();
            }
            return null;
        }

        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.empty.rescue.block.msg");
            if (string == null) {
                AddIgnoredCommentToEmptyRescueBlockFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/emptyrescue/RubyEmptyRescueBlockInspection$AddIgnoredCommentToEmptyRescueBlockFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/emptyrescue/RubyEmptyRescueBlockInspection$AddIgnoredCommentToEmptyRescueBlockFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

