/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.defparentheses;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RFunctionArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;

public final class RubyDefParenthesesInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyDefParenthesesInspection.$$$reportNull$$$0(0);
        }
        return new DefParenthesesVisitor(holder);
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            RubyDefParenthesesInspection.$$$reportNull$$$0(1);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/defparentheses/RubyDefParenthesesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/defparentheses/RubyDefParenthesesInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class DefParenthesesVisitor
    extends RubyInspectionVisitor {
        DefParenthesesVisitor(ProblemsHolder holder) {
            super(holder);
        }

        public void visitRSingletonMethod(@NotNull RSingletonMethod rsMethod) {
            if (rsMethod == null) {
                DefParenthesesVisitor.$$$reportNull$$$0(0);
            }
            this.visitMethod((RMethod)rsMethod);
        }

        public void visitRMethod(@NotNull RMethod rMethod) {
            if (rMethod == null) {
                DefParenthesesVisitor.$$$reportNull$$$0(1);
            }
            this.visitMethod(rMethod);
        }

        private void visitMethod(RMethod rMethod) {
            RName name;
            if (rMethod == null) {
                return;
            }
            ASTNode node = rMethod.getChildren()[1].getNode().getTreePrev();
            if (node.getText().trim().isEmpty()) {
                node = node.getTreePrev();
            }
            int size = rMethod.getArguments().size();
            boolean par = "(".equals(node.getText());
            if (size > 0 && !par) {
                this.registerProblem((PsiElement)rMethod.getArgumentList(), RBundle.message((String)"inspection.def.no.parentheses"), new DefParenthesesQuickFix());
            }
            if (size == 0 && par && (name = rMethod.getMethodName()) != null) {
                this.registerProblem((PsiElement)name, RBundle.message((String)"inspection.def.parentheses.no.arg"), new RemoveDefParenthesesFix());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rsMethod";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rMethod";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/defparentheses/RubyDefParenthesesInspection$DefParenthesesVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRSingletonMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRMethod";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DefParenthesesQuickFix
    extends RubyFix {
        private DefParenthesesQuickFix() {
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element;
            if (project == null) {
                DefParenthesesQuickFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                DefParenthesesQuickFix.$$$reportNull$$$0(1);
            }
            if (!((element = descriptor.getPsiElement()) instanceof RArgumentList) || element instanceof RFunctionArgumentList) {
                return;
            }
            RPsiElement generated = RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)String.format("def lol (%s)\nend\n", element.getText()));
            ASTNode argumentsNode = generated.getChildren()[1].getNode();
            PsiElement lPar = argumentsNode.getTreePrev().getPsi();
            PsiElement rPar = argumentsNode.getTreeNext().getPsi();
            if (argumentsNode.getPsi() instanceof RFunctionArgumentList) {
                PsiElement prev = element.getPrevSibling();
                if (prev instanceof PsiWhiteSpace) {
                    prev.delete();
                }
                element.getParent().addBefore(lPar, element);
                element.getParent().addAfter(rPar, element);
                CodeEditUtil.markToReformat((ASTNode)element.getParent().getNode(), (boolean)true);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.def.parentheses.msg");
            if (string == null) {
                DefParenthesesQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/defparentheses/RubyDefParenthesesInspection$DefParenthesesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/defparentheses/RubyDefParenthesesInspection$DefParenthesesQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class RemoveDefParenthesesFix
    extends RubyFix {
        private RemoveDefParenthesesFix() {
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element;
            PsiElement parent;
            if (project == null) {
                RemoveDefParenthesesFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                RemoveDefParenthesesFix.$$$reportNull$$$0(1);
            }
            if (!((parent = (element = descriptor.getPsiElement()).getParent()) instanceof RMethod)) {
                return;
            }
            ASTNode argumentNode = parent.getChildren()[1].getNode();
            argumentNode.getTreeNext().getPsi().delete();
            argumentNode.getTreePrev().getPsi().delete();
        }

        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.def.parentheses.msg2");
            if (string == null) {
                RemoveDefParenthesesFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/defparentheses/RubyDefParenthesesInspection$RemoveDefParenthesesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/defparentheses/RubyDefParenthesesInspection$RemoveDefParenthesesFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

