/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.controlflowconversion;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUnlessStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElseBlock;

public class RubyUnlessWithElseFix
extends RubyFix {
    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement element;
        PsiElement parent;
        if (project == null) {
            RubyUnlessWithElseFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            RubyUnlessWithElseFix.$$$reportNull$$$0(1);
        }
        if ((parent = (element = descriptor.getPsiElement()).getParent()) instanceof RUnlessStatement && ((RUnlessStatement)parent).getElseBlock() != null && ((RUnlessStatement)parent).getEndToken() != null) {
            String thenText = RubyUnlessWithElseFix.getThenText(element, (RUnlessStatement)parent);
            String elseText = RubyUnlessWithElseFix.getElseText((RUnlessStatement)parent);
            String text = RubyTokenTypes.kIF.toString() + " " + element.getText() + elseText + String.valueOf(RubyTokenTypes.kELSE) + thenText + String.valueOf(RubyTokenTypes.kEND);
            RPsiElement newElement = RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)text);
            parent.replace((PsiElement)newElement);
        }
    }

    private static String getThenText(PsiElement element, RUnlessStatement parent) {
        int startOffset = element.getTextRange().getEndOffset() - parent.getTextRange().getStartOffset();
        RElseBlock elseBlock = parent.getElseBlock();
        int endOffset = 0;
        if (elseBlock != null) {
            endOffset = elseBlock.getStartOffsetInParent();
        }
        return parent.getText().substring(startOffset, endOffset);
    }

    private static String getElseText(RUnlessStatement parent) {
        PsiElement firstChild;
        RElseBlock elseBlock = parent.getElseBlock();
        int startOffset = 0;
        if (elseBlock != null && (firstChild = elseBlock.getFirstChild()) != null) {
            startOffset = elseBlock.getStartOffsetInParent() + firstChild.getTextLength();
        }
        ASTNode endToken = parent.getEndToken();
        int endOffset = 0;
        if (endToken != null) {
            endOffset = endToken.getStartOffset() - parent.getTextRange().getStartOffset();
        }
        return parent.getText().substring(startOffset, endOffset);
    }

    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"inspection.unless.with.else.quickfix.message");
        if (string == null) {
            RubyUnlessWithElseFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/controlflowconversion/RubyUnlessWithElseFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/controlflowconversion/RubyUnlessWithElseFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

