/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.controlflowconversion;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RBlockStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RConditionalStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RModifierStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyRefactoringUtil;

public class RubyControlFlowStatementFix
extends RubyFix {
    @NotNull
    private final ExpressionInfo myOriginal;
    @NotNull
    private final ExpressionInfo myReplacement;

    RubyControlFlowStatementFix(RConditionalStatement element) {
        this.myOriginal = RubyControlFlowStatementFix.getOriginal(element);
        this.myReplacement = RubyControlFlowStatementFix.getReplacement(element);
    }

    @NotNull
    private static ExpressionInfo getOriginal(RConditionalStatement element) {
        RCondition condition = element.getCondition();
        assert (condition != null);
        if (element instanceof RBlockStatement) {
            return new ExpressionInfo(element.getFirstChild().getText(), (PsiElement)condition);
        }
        if (element instanceof RModifierStatement) {
            return new ExpressionInfo(((RModifierStatement)element).getModifierKeyword().getText(), (PsiElement)condition);
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    private static ExpressionInfo getReplacement(RConditionalStatement element) {
        RCondition condition = element.getCondition();
        assert (condition != null);
        PsiElement conditionChild = condition.getFirstChild();
        RPsiElement negatedCondition = RubyRefactoringUtil.negateExpression((PsiElement)(conditionChild != null ? conditionChild : condition));
        IElementType replacedKeyword = RubyPsiUtil.getNegativeKeyword(element);
        if (replacedKeyword != null) {
            return new ExpressionInfo(replacedKeyword, (PsiElement)negatedCondition);
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement element1;
        PsiElement element;
        if (project == null) {
            RubyControlFlowStatementFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            RubyControlFlowStatementFix.$$$reportNull$$$0(1);
        }
        Object object = element = (element1 = descriptor.getPsiElement().getParent()) instanceof RConditionalStatement ? ((RConditionalStatement)element1).getCondition() : element1;
        if (element == null) {
            return;
        }
        PsiElement parent = element.getParent();
        int offset = element.getTextRange().getStartOffset() + element.getTextLength() - parent.getTextRange().getStartOffset();
        if (parent instanceof RConditionalStatement) {
            Object text = "";
            if (parent instanceof RBlockStatement) {
                String body = parent.getText().substring(offset);
                text = this.myReplacement.getType() + " " + this.myReplacement.getExpression() + body;
            } else if (parent instanceof RModifierStatement) {
                RModifierStatement modifier = (RModifierStatement)parent;
                text = modifier.getCommand().getText() + " " + this.myReplacement.getType() + " " + this.myReplacement.getExpression();
            }
            parent.replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)text));
        }
    }

    @NotNull
    public String getName() {
        String string = RBundle.message((String)"inspection.control.flow.conversion.quickfix.message", (Object[])new Object[]{this.myOriginal.getType(), this.myReplacement.getType()});
        if (string == null) {
            RubyControlFlowStatementFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @Nls
    public String getFamilyName() {
        String string = RBundle.message((String)"inspection.control.flow.conversion.quickfix.family.name");
        if (string == null) {
            RubyControlFlowStatementFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/controlflowconversion/RubyControlFlowStatementFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/controlflowconversion/RubyControlFlowStatementFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    @FileModifier.SafeTypeForPreview
    private static final class ExpressionInfo {
        @NotNull
        private final String myType;
        @NotNull
        private final String myExpression;

        private ExpressionInfo(@NotNull String type, @NotNull PsiElement element) {
            if (type == null) {
                ExpressionInfo.$$$reportNull$$$0(0);
            }
            if (element == null) {
                ExpressionInfo.$$$reportNull$$$0(1);
            }
            this.myType = type;
            this.myExpression = element instanceof RGroupedExpression ? RubyPsiUtil.deparenthesize((RGroupedExpression)element) : element.getText();
        }

        private ExpressionInfo(@NotNull IElementType type, @NotNull PsiElement element) {
            if (type == null) {
                ExpressionInfo.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ExpressionInfo.$$$reportNull$$$0(3);
            }
            this(type.toString(), element);
        }

        @NotNull
        public String getType() {
            String string = this.myType;
            if (string == null) {
                ExpressionInfo.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getExpression() {
            String string = this.myExpression;
            if (string == null) {
                ExpressionInfo.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/controlflowconversion/RubyControlFlowStatementFix$ExpressionInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/controlflowconversion/RubyControlFlowStatementFix$ExpressionInfo";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

