/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.bracketerror;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.templates.TemplateIntegrationUtils;

public final class RubyBracketErrorInspection
extends LocalInspectionTool {
    @NotNull
    private static final Map<String, IElementType> STRING_TO_CLOSING_TOKEN_MATCHINGS = new HashMap<String, IElementType>();

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(0);
        }
        return new RubyBracketErrorVisitor(holder);
    }

    @Nullable
    private static PsiElement findLastCorrectIndentedChild(@NotNull Document document, @NotNull PsiElement element, @NotNull PsiElement startElement, @NotNull Document tmpDoc) {
        if (document == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(1);
        }
        if (element == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(2);
        }
        if (startElement == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(3);
        }
        if (tmpDoc == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(4);
        }
        PsiElement last = null;
        for (ASTNode childNode : element.getNode().getChildren(null)) {
            PsiElement candidate;
            PsiElement child = childNode.getPsi();
            if (child instanceof PsiErrorElement) {
                return last;
            }
            if (RubySpaceUtil.isAnySpace((PsiElement)child)) continue;
            if (RubyBracketErrorInspection.atOneLine(document, element, child) || child.getText().trim().isEmpty() || childNode.getElementType() == RubyTokenTypes.tCOMMA) {
                last = child;
                continue;
            }
            if (document.getText(new TextRange(document.getLineStartOffset(RubyBracketErrorInspection.getLine(document, child)), child.getTextRange().getStartOffset())).trim().isEmpty() && RubyBracketErrorInspection.getCorrectIndent(document, child, tmpDoc) != RubyBracketErrorInspection.getIndent(document, child)) {
                return last;
            }
            if (!RubyBracketErrorInspection.atOneLine(document, startElement, child) && !RubyBracketErrorInspection.atOneLine(document, element) && (candidate = RubyBracketErrorInspection.findLastCorrectIndentedChild(document, child, startElement, tmpDoc)) != child) {
                if (candidate == null) {
                    return last;
                }
                return candidate;
            }
            last = child;
        }
        return element;
    }

    @Nullable
    private static PsiElement findLastChildAtOneLine(@NotNull Document document, @NotNull PsiElement element, @NotNull PsiElement startElement) {
        if (document == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(5);
        }
        if (element == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(6);
        }
        if (startElement == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(7);
        }
        PsiElement last = null;
        for (ASTNode childNode : element.getNode().getChildren(null)) {
            PsiElement child = childNode.getPsi();
            if (RubySpaceUtil.isEol((ASTNode)childNode) || child instanceof PsiComment) {
                return last;
            }
            if (!RubyBracketErrorInspection.atOneLine(document, startElement, child)) {
                PsiElement candidate = RubyBracketErrorInspection.findLastChildAtOneLine(document, child, startElement);
                if (candidate == null) {
                    return last;
                }
                return candidate;
            }
            if (child instanceof PsiWhiteSpace) continue;
            last = child;
        }
        return element;
    }

    @Nullable
    private static IElementType findExpectedClosingToken(@NotNull PsiErrorElement error) {
        String description;
        String[] descriptionTokens;
        if (error == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(8);
        }
        if ((descriptionTokens = (description = error.getErrorDescription()).split(" ")).length >= 2 && "Expected:".equals(descriptionTokens[0])) {
            return STRING_TO_CLOSING_TOKEN_MATCHINGS.get(descriptionTokens[1]);
        }
        return null;
    }

    private static boolean isIndentOfClosingTokenCorrect(@NotNull Document document, @NotNull PsiElement closingElement, @NotNull Document tmpDoc) {
        if (document == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(9);
        }
        if (closingElement == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(10);
        }
        if (tmpDoc == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(11);
        }
        if (!TokenBNF.tCLOSING_TOKENS.contains(closingElement.getNode().getElementType())) {
            return true;
        }
        PsiElement parent = closingElement.getParent();
        int indent = RubyBracketErrorInspection.getIndent(document, closingElement);
        int parentIndent = RubyBracketErrorInspection.getIndent(document, parent);
        int line = RubyBracketErrorInspection.getLine(document, closingElement);
        int parentLine = RubyBracketErrorInspection.getLine(document, parent);
        int expectedIndent = RubyBracketErrorInspection.getCorrectIndent(document, closingElement, tmpDoc);
        int expectedParentIndent = RubyBracketErrorInspection.getCorrectIndent(document, parent, tmpDoc);
        return line == parentLine || indent == expectedIndent || parentIndent != expectedParentIndent;
    }

    private static int getCorrectIndent(@NotNull Document document, @NotNull PsiElement element, @NotNull Document tmpDoc) {
        int delta;
        if (document == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(12);
        }
        if (element == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(13);
        }
        if (tmpDoc == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(14);
        }
        int line = RubyBracketErrorInspection.getLine(document, element);
        String docLine = document.getText(new TextRange(document.getLineStartOffset(line), document.getLineEndOffset(line)));
        String tmpDocLine = tmpDoc.getText(new TextRange(tmpDoc.getLineStartOffset(line), tmpDoc.getLineEndOffset(line)));
        for (delta = 0; delta < docLine.length() && docLine.charAt(docLine.length() - 1 - delta) <= ' '; ++delta) {
        }
        return RubyBracketErrorInspection.getIndent(document, element) + tmpDocLine.length() - docLine.length() + delta;
    }

    private static int getLine(@NotNull Document document, @NotNull PsiElement element) {
        TextRange range;
        if (document == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(15);
        }
        if (element == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(16);
        }
        if ((range = element.getTextRange()) == null) {
            return -1;
        }
        int offset = element.getTextRange().getStartOffset();
        return document.getLineNumber(offset);
    }

    private static int getIndent(@NotNull Document document, @NotNull PsiElement element) {
        if (document == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(17);
        }
        if (element == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(18);
        }
        int offset = element.getTextRange().getStartOffset();
        return offset - DocumentUtil.getLineStartOffset((int)offset, (Document)document);
    }

    private static boolean atOneLine(@NotNull Document document, @NotNull PsiElement element) {
        TextRange range;
        if (document == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(19);
        }
        if (element == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(20);
        }
        if ((range = element.getTextRange()) == null) {
            return false;
        }
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        if (element.getText().endsWith("\n")) {
            --endOffset;
        }
        return document.getLineNumber(startOffset) == document.getLineNumber(endOffset);
    }

    private static boolean atOneLine(@NotNull Document document, @NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (document == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(21);
        }
        if (element1 == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(22);
        }
        if (element2 == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(23);
        }
        return RubyBracketErrorInspection.getLine(document, element1) == document.getLineNumber(element2.getTextRange().getEndOffset());
    }

    private static boolean atLineBeginning(@NotNull Document document, @NotNull PsiElement element) {
        if (document == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(24);
        }
        if (element == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(25);
        }
        return document.getText(new TextRange(document.getLineStartOffset(RubyBracketErrorInspection.getLine(document, element)), element.getTextRange().getStartOffset())).trim().isEmpty();
    }

    private static boolean atLineEnding(@NotNull Document document, @NotNull PsiElement element) {
        if (document == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(26);
        }
        if (element == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(27);
        }
        return document.getText(new TextRange(element.getTextRange().getEndOffset(), document.getLineEndOffset(RubyBracketErrorInspection.getLine(document, element)))).trim().isEmpty();
    }

    private static boolean textBeforeElementEndsWith(@NotNull PsiElement element, @NotNull String text) {
        if (element == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(28);
        }
        if (text == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(29);
        }
        return element.getParent().getText().substring(0, element.getStartOffsetInParent()).replace(" ", "").endsWith(text);
    }

    @NotNull
    private static String getLineEnding(@NotNull Document document, @NotNull PsiElement element, int startOffset) {
        if (document == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(30);
        }
        if (element == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(31);
        }
        String string = element.getText().substring(startOffset, document.getLineEndOffset(RubyBracketErrorInspection.getLine(document, element)) - element.getTextRange().getStartOffset()).trim();
        if (string == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(32);
        }
        return string;
    }

    @Nullable
    private static PsiElement getPrevNewLine(@NotNull PsiElement element) {
        PsiElement newLine;
        if (element == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(33);
        }
        if ((newLine = element.getPrevSibling()) == null) {
            return null;
        }
        while (!"\n".equals(newLine.getText().replace(" ", ""))) {
            if ((newLine = newLine.getPrevSibling()) != null) continue;
            return null;
        }
        return newLine;
    }

    @Nullable
    private static PsiElement getIncorrectlyIndentedBracket(@NotNull CodeStyleManager codeStyleManager, @NotNull Document document, @NotNull PsiElement element, @NotNull IElementType myType, @NotNull Document tmpDoc) {
        if (codeStyleManager == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(34);
        }
        if (document == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(35);
        }
        if (element == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(36);
        }
        if (myType == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(37);
        }
        if (tmpDoc == null) {
            RubyBracketErrorInspection.$$$reportNull$$$0(38);
        }
        for (PsiElement child : element.getChildren()) {
            PsiElement rec;
            PsiElement bracket = child.getLastChild();
            if (bracket == null || bracket.getNode() == null || !TokenBNF.tCLOSING_TOKENS.contains(bracket.getNode().getElementType())) {
                rec = RubyBracketErrorInspection.getIncorrectlyIndentedBracket(codeStyleManager, document, child, myType, tmpDoc);
                if (rec == null) continue;
                return rec;
            }
            if (bracket.getNode().getElementType() != myType || RubyBracketErrorInspection.isIndentOfClosingTokenCorrect(document, bracket, tmpDoc)) continue;
            rec = RubyBracketErrorInspection.getIncorrectlyIndentedBracket(codeStyleManager, document, child, myType, tmpDoc);
            return rec != null ? rec : bracket;
        }
        return null;
    }

    static {
        for (IElementType type : TokenBNF.tCLOSING_TOKENS.getTypes()) {
            STRING_TO_CLOSING_TOKEN_MATCHINGS.put(type.toString(), type);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 6: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 4: 
            case 11: 
            case 14: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tmpDoc";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closingElement";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/bracketerror/RubyBracketErrorInspection";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleManager";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/bracketerror/RubyBracketErrorInspection";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineEnding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findLastCorrectIndentedChild";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findLastChildAtOneLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findExpectedClosingToken";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isIndentOfClosingTokenCorrect";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCorrectIndent";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLine";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getIndent";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "atOneLine";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "atLineBeginning";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "atLineEnding";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "textBeforeElementEndsWith";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getLineEnding";
                break;
            }
            case 32: {
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPrevNewLine";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getIncorrectlyIndentedBracket";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 32 -> new IllegalStateException(string);
        };
    }

    private static final class RubyBracketErrorVisitor
    extends RubyInspectionVisitor {
        RubyBracketErrorVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                RubyBracketErrorVisitor.$$$reportNull$$$0(0);
            }
            super(holder);
        }

        public void visitErrorElement(@NotNull PsiErrorElement errorElement) {
            if (errorElement == null) {
                RubyBracketErrorVisitor.$$$reportNull$$$0(1);
            }
            if (!this.myHolder.isOnTheFly()) {
                return;
            }
            PsiElement parent = errorElement.getParent();
            IElementType type = RubyBracketErrorInspection.findExpectedClosingToken(errorElement);
            if (type != null) {
                if (type == RubyTokenTypes.kEND && !TemplateIntegrationUtils.mustCloseRubyBlock((PsiElement)errorElement)) {
                    return;
                }
                this.registerProblem(parent, RBundle.message((String)"inspection.bracket.balance.message", (Object[])new Object[]{type}), ProblemHighlightType.INFORMATION, new RubyBracketErrorFix(type));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorElement";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/bracketerror/RubyBracketErrorInspection$RubyBracketErrorVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitErrorElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class RubyBracketErrorFix
    extends RubyFix {
        @FileModifier.SafeFieldForPreview
        @NotNull
        private final IElementType myType;
        private final boolean isPreview;

        RubyBracketErrorFix(@NotNull IElementType type) {
            if (type == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(0);
            }
            this(type, false);
        }

        RubyBracketErrorFix(@NotNull IElementType type, boolean preview) {
            if (type == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(1);
            }
            this.myType = type;
            this.isPreview = preview;
        }

        @NotNull
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
            if (target == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(2);
            }
            return new RubyBracketErrorFix(this.myType, true);
        }

        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.bracket.balance.fix", (Object[])new Object[]{this.myType});
            if (string == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            CommonCodeStyleSettings.IndentOptions tmpIndentOptions;
            if (project == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(5);
            }
            PsiElement element = descriptor.getPsiElement();
            PsiFile file = element.getContainingFile();
            Editor editor = PsiEditorUtil.findEditor((PsiElement)element);
            if (editor == null) {
                return;
            }
            Document document = editor.getDocument();
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            PsiFile tmpFile = PsiFileFactory.getInstance((Project)project).createFileFromText((CharSequence)file.getText(), file);
            CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getIndentOptions((PsiFile)file);
            if (!indentOptions.equals((Object)(tmpIndentOptions = CodeStyle.getIndentOptions((PsiFile)tmpFile)))) {
                tmpIndentOptions.copyFrom(indentOptions);
            }
            codeStyleManager.adjustLineIndent(tmpFile, element.getTextRange());
            Document tmpDoc = EditorFactory.getInstance().createDocument((CharSequence)tmpFile.getText());
            PsiElement incorrectBracket = RubyBracketErrorInspection.getIncorrectlyIndentedBracket(codeStyleManager, document, element, this.myType, tmpDoc);
            PsiElement elementToFix = incorrectBracket != null ? incorrectBracket.getParent() : element;
            int endLine = document.getLineNumber(elementToFix.getTextRange().getEndOffset());
            if (this.isOneLineElement(document, elementToFix)) {
                int beginLine = this.fixOneLineElement(documentManager, document, elementToFix);
                this.fixIndentation(documentManager, codeStyleManager, editor, file, document, beginLine, Math.max(beginLine + 1, endLine));
                return;
            }
            boolean setToOneLine = this.hasElementsOnFirstLine(document, elementToFix);
            PsiElement lastElement = setToOneLine ? RubyBracketErrorInspection.findLastChildAtOneLine(document, elementToFix, elementToFix) : RubyBracketErrorInspection.findLastCorrectIndentedChild(document, elementToFix, elementToFix, tmpDoc);
            PsiElement bracket = RubyElementFactory.createClosingBracket(elementToFix, this.myType);
            assert (bracket != null);
            if (lastElement == null) {
                bracket = elementToFix.addBefore(bracket, elementToFix.getFirstChild());
            } else {
                if (this.isOneLineElement(document, lastElement) && RubyBracketErrorInspection.getLine(document, elementToFix) == RubyBracketErrorInspection.getLine(document, lastElement)) {
                    setToOneLine = true;
                }
                bracket = lastElement.getParent().addAfter(bracket, lastElement);
            }
            if (!setToOneLine && !RubyBracketErrorInspection.atLineBeginning(document, bracket)) {
                bracket.getParent().addBefore(RubyElementFactoryCore.createNewLine((PsiElement)bracket), bracket);
            }
            if (!(setToOneLine || PsiTreeUtil.nextVisibleLeaf((PsiElement)bracket) != null && PsiTreeUtil.nextVisibleLeaf((PsiElement)bracket).getNode().getElementType() == RubyTokenTypes.tCOMMA || RubyBracketErrorInspection.atLineEnding(document, bracket))) {
                bracket.getParent().addAfter(RubyElementFactoryCore.createNewLine((PsiElement)bracket), bracket);
            }
            int line = this.refreshDocumentAndFixNewLines(documentManager, document, file, elementToFix, bracket, setToOneLine);
            file = documentManager.getPsiFile(document);
            this.fixIndentation(documentManager, codeStyleManager, editor, file, document, line, Math.max(line + 1, endLine));
        }

        private int refreshDocumentAndFixNewLines(@NotNull PsiDocumentManager documentManager, @NotNull Document document, @NotNull PsiFile file, @NotNull PsiElement elementToFix, @NotNull PsiElement bracket, boolean setToOneLine) {
            if (documentManager == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(6);
            }
            if (document == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(7);
            }
            if (file == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(8);
            }
            if (elementToFix == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(9);
            }
            if (bracket == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(10);
            }
            int start = elementToFix.getTextRange().getStartOffset();
            int end = bracket.getTextRange().getEndOffset();
            if (!this.isPreview) {
                documentManager.reparseFiles(Collections.singleton(file.getVirtualFile()), true);
                file = documentManager.getPsiFile(document);
            }
            PsiElement first = file.findElementAt(start);
            PsiElement last = file.findElementAt(Math.min(file.getTextLength() - 1, end - 1));
            assert (first != null && last != null);
            if (RubyElementFactory.CLOSING_TO_OPENING_PAIRS.get(this.myType) == first.getNode().getElementType()) {
                bracket = first.getParent().getLastChild();
            } else {
                PsiElement common = PsiTreeUtil.findCommonParent((PsiElement)first, (PsiElement)last);
                if (common != null && ((bracket = PsiTreeUtil.getDeepestLast((PsiElement)common)).getNode() == null || bracket.getNode().getElementType() != this.myType)) {
                    bracket = last;
                }
            }
            int line = RubyBracketErrorInspection.getLine(document, bracket);
            if (bracket.getNode() == null || bracket.getNode().getElementType() != this.myType) {
                return line;
            }
            if (setToOneLine && RubyBracketErrorInspection.textBeforeElementEndsWith(bracket, "\n") || RubyBracketErrorInspection.textBeforeElementEndsWith(bracket, "\n\n")) {
                PsiElement newLine = RubyBracketErrorInspection.getPrevNewLine(bracket);
                if (newLine == null) {
                    return line;
                }
                --line;
                PsiElement emptyElement = PsiParserFacade.getInstance((Project)newLine.getProject()).createWhiteSpaceFromText("");
                newLine.replace(emptyElement);
            }
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            if (setToOneLine) {
                this.addWhiteSpaceBefore(documentManager, document, bracket);
            }
            return line;
        }

        private void fixIndentation(@NotNull PsiDocumentManager documentManager, @NotNull CodeStyleManager codeStyleManager, @NotNull Editor editor, @NotNull PsiFile file, @NotNull Document document, int firstLine, int lastLine) {
            if (documentManager == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(11);
            }
            if (codeStyleManager == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(12);
            }
            if (editor == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(13);
            }
            if (file == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(14);
            }
            if (document == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(15);
            }
            lastLine = Math.min(lastLine + 1, document.getLineCount() - 1);
            firstLine = Math.min(firstLine, lastLine);
            int startOffset = document.getLineStartOffset(firstLine);
            int endOffset = document.getLineEndOffset(lastLine);
            if (!this.isPreview) {
                documentManager.reparseFiles(Collections.singleton(file.getVirtualFile()), true);
                file = documentManager.getPsiFile(document);
            }
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            codeStyleManager.adjustLineIndent(file, new TextRange(startOffset, endOffset));
            editor.getCaretModel().moveToOffset(document.getLineEndOffset(firstLine));
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }

        private void addWhiteSpaceBefore(@NotNull PsiDocumentManager documentManager, @NotNull Document document, @NotNull PsiElement element) {
            if (documentManager == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(16);
            }
            if (document == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(17);
            }
            if (element == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(18);
            }
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            String lineText = document.getText(new TextRange(document.getLineStartOffset(RubyBracketErrorInspection.getLine(document, element)), document.getLineEndOffset(RubyBracketErrorInspection.getLine(document, element))));
            boolean afterOpeningBracket = false;
            int start = 0;
            int end = lineText.length();
            for (int i = 0; i < lineText.length(); ++i) {
                char ch = lineText.charAt(i);
                if (afterOpeningBracket && ch != ' ') {
                    end = i;
                    break;
                }
                if (ch != RubyElementFactory.CLOSING_TO_OPENING_PAIRS.get(this.myType).toString().charAt(0)) continue;
                afterOpeningBracket = true;
                start = i + 1;
            }
            if (afterOpeningBracket && start < end) {
                PsiElement whitespace = PsiParserFacade.getInstance((Project)element.getProject()).createWhiteSpaceFromText(lineText.substring(start, end));
                element.getParent().addBefore(whitespace, element);
            }
        }

        private int fixOneLineElement(@NotNull PsiDocumentManager documentManager, @NotNull Document document, @NotNull PsiElement elementToFix) {
            if (documentManager == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(19);
            }
            if (document == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(20);
            }
            if (elementToFix == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(21);
            }
            boolean needNewLine = elementToFix.getText().endsWith("\n");
            PsiElement bracket = RubyElementFactory.createClosingBracket(elementToFix, this.myType);
            assert (bracket != null);
            bracket = elementToFix.addAfter(bracket, elementToFix.getLastChild() != null ? elementToFix.getLastChild() : elementToFix);
            PsiElement newLine = RubyBracketErrorInspection.getPrevNewLine(elementToFix.getLastChild());
            if (newLine != null) {
                PsiElement emptyElement = PsiParserFacade.getInstance((Project)newLine.getProject()).createWhiteSpaceFromText("");
                newLine.replace(emptyElement);
            }
            if (needNewLine) {
                elementToFix.addAfter(RubyElementFactoryCore.createNewLine((PsiElement)elementToFix), elementToFix.getLastChild());
            }
            this.addWhiteSpaceBefore(documentManager, document, bracket);
            return RubyBracketErrorInspection.getLine(document, elementToFix);
        }

        private boolean isOneLineElement(@NotNull Document document, @NotNull PsiElement element) {
            if (document == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(22);
            }
            if (element == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(23);
            }
            return RubyBracketErrorInspection.atOneLine(document, element) && this.myType != RubyTokenTypes.kEND;
        }

        private boolean hasElementsOnFirstLine(@NotNull Document document, @NotNull PsiElement element) {
            if (document == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(24);
            }
            if (element == null) {
                RubyBracketErrorFix.$$$reportNull$$$0(25);
            }
            if (this.myType == RubyTokenTypes.kEND) {
                return false;
            }
            if (element instanceof RCodeBlock) {
                RBlockArgumentList args = ((RCodeBlock)element).getBlockArguments();
                if (args != null) {
                    int offset = args.getStartOffsetInParent() + args.getTextLength() + 1;
                    return !RubyBracketErrorInspection.getLineEnding(document, element, offset).isEmpty();
                }
                return !RubyBracketErrorInspection.getLineEnding(document, element, 0).endsWith(RubyElementFactory.CLOSING_TO_OPENING_PAIRS.get(this.myType).toString());
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/bracketerror/RubyBracketErrorInspection$RubyBracketErrorFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 6: 
                case 11: 
                case 16: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "documentManager";
                    break;
                }
                case 7: 
                case 15: 
                case 17: 
                case 20: 
                case 22: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 8: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 9: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementToFix";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bracket";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codeStyleManager";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 18: 
                case 23: 
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/bracketerror/RubyBracketErrorInspection$RubyBracketErrorFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileModifierForPreview";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "refreshDocumentAndFixNewLines";
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "fixIndentation";
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "addWhiteSpaceBefore";
                    break;
                }
                case 19: 
                case 20: 
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "fixOneLineElement";
                    break;
                }
                case 22: 
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "isOneLineElement";
                    break;
                }
                case 24: 
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "hasElementsOnFirstLine";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

