/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.blocktoreference;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.blocktoreference.RubyBlockToMethodReferenceUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;

final class RubyBlockToMethodReferenceFix
extends RubyFix {
    @NotNull
    private final String myReference;

    RubyBlockToMethodReferenceFix(@NotNull String reference) {
        if (reference == null) {
            RubyBlockToMethodReferenceFix.$$$reportNull$$$0(0);
        }
        this.myReference = reference;
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement element;
        RBlockCall blockCall;
        if (project == null) {
            RubyBlockToMethodReferenceFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            RubyBlockToMethodReferenceFix.$$$reportNull$$$0(2);
        }
        if ((blockCall = (RBlockCall)PsiTreeUtil.getParentOfType((PsiElement)(element = descriptor.getPsiElement()), RBlockCall.class)) == null) {
            return;
        }
        RubyBlockToMethodReferenceUtil.replaceBlock(blockCall, this.myReference);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"inspection.block.replace.with.method.reference.msg");
        if (string == null) {
            RubyBlockToMethodReferenceFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/blocktoreference/RubyBlockToMethodReferenceFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/blocktoreference/RubyBlockToMethodReferenceFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

