/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.blocktoreference;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RUnaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RLambdaCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFid;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;

public final class MethodDescriptor {
    @NotNull
    private final PsiElement myElement;
    @NotNull
    private final String myReference;
    @NotNull
    private final List<String> myArguments;

    private MethodDescriptor(@NotNull PsiElement element, @NotNull String reference, @NotNull List<String> arguments) {
        if (element == null) {
            MethodDescriptor.$$$reportNull$$$0(0);
        }
        if (reference == null) {
            MethodDescriptor.$$$reportNull$$$0(1);
        }
        if (arguments == null) {
            MethodDescriptor.$$$reportNull$$$0(2);
        }
        this.myElement = element;
        this.myReference = reference;
        this.myArguments = Collections.unmodifiableList(arguments);
    }

    @NotNull
    public List<String> getArguments() {
        List<String> list = this.myArguments;
        if (list == null) {
            MethodDescriptor.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            MethodDescriptor.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    @NotNull
    public String getReference() {
        String string = this.myReference;
        if (string == null) {
            MethodDescriptor.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    static MethodDescriptor fromElement(@NotNull PsiElement element) {
        if (element == null) {
            MethodDescriptor.$$$reportNull$$$0(6);
        }
        MyVisitor visitor = new MyVisitor();
        element.accept((PsiElementVisitor)visitor);
        return visitor.getMethodDescriptor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/blocktoreference/MethodDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/blocktoreference/MethodDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    private static final class MyVisitor
    extends RubyElementVisitor {
        @Nullable
        private MethodDescriptor myMethodDescriptor;

        private MyVisitor() {
        }

        @Nullable
        public MethodDescriptor getMethodDescriptor() {
            return this.myMethodDescriptor;
        }

        public void visitRUnaryExpression(@NotNull RUnaryExpression unaryExpression) {
            RPsiElement argument;
            if (unaryExpression == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if ((argument = unaryExpression.getElement()) != null) {
                String reference = MyVisitor.createMethodReference(unaryExpression.getOperationName());
                List<String> arguments = Collections.singletonList(argument.getText());
                this.myMethodDescriptor = new MethodDescriptor((PsiElement)unaryExpression, reference, arguments);
            }
        }

        public void visitRBinaryExpression(@NotNull RBinaryExpression binaryExpression) {
            if (binaryExpression == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            RPsiElement leftOperand = binaryExpression.getLeftOperand();
            RPsiElement rightOperand = binaryExpression.getRightOperand();
            if (leftOperand != null && rightOperand != null) {
                String reference = MyVisitor.createMethodReference(binaryExpression.getOperation().getText());
                List<String> arguments = List.of(leftOperand.getText(), rightOperand.getText());
                this.myMethodDescriptor = new MethodDescriptor((PsiElement)binaryExpression, reference, arguments);
            }
        }

        public void visitRIdentifier(@NotNull RIdentifier identifier) {
            if (identifier == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            String reference = MyVisitor.createStaticMethodReference(identifier.getText());
            this.myMethodDescriptor = new MethodDescriptor((PsiElement)identifier, reference, Collections.emptyList());
        }

        public void visitRFid(@NotNull RFid fid) {
            if (fid == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            String reference = MyVisitor.createStaticMethodReference(fid.getText());
            this.myMethodDescriptor = new MethodDescriptor((PsiElement)fid, reference, Collections.emptyList());
        }

        public void visitRReference(@NotNull RReference reference) {
            if (reference == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            RPsiElement receiver = reference.getReceiver();
            RPsiElement value = reference.getValue();
            if (receiver != null && value != null) {
                String methodReference = MyVisitor.createMethodReference(value.getText());
                List<String> arguments = Collections.singletonList(receiver.getText());
                this.myMethodDescriptor = new MethodDescriptor((PsiElement)reference, methodReference, arguments);
            }
        }

        public void visitRLambdaCall(@NotNull RLambdaCall lambdaCall) {
            RPsiElement receiver;
            if (lambdaCall == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            if ((receiver = lambdaCall.getReceiver()) != null) {
                String reference = MyVisitor.createMethodReference("call");
                List arguments = ContainerUtil.prepend((List)ContainerUtil.map((Collection)lambdaCall.getCallArguments().getElements(), PsiElement::getText), (Object[])new String[]{receiver.getText()});
                this.myMethodDescriptor = new MethodDescriptor((PsiElement)lambdaCall, reference, arguments);
            }
        }

        public void visitRCall(@NotNull RCall call) {
            PsiElement psiCommand;
            if (call == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            if ((psiCommand = call.getPsiCommand()) instanceof RReference) {
                RReference reference = (RReference)psiCommand;
                RPsiElement receiver = reference.getReceiver();
                RPsiElement value = reference.getValue();
                if (receiver != null && value != null) {
                    String methodReference = MyVisitor.createMethodReference(value.getText());
                    List arguments = ContainerUtil.prepend((List)ContainerUtil.map((Collection)call.getCallArguments().getElements(), PsiElement::getText), (Object[])new String[]{receiver.getText()});
                    this.myMethodDescriptor = new MethodDescriptor((PsiElement)call, methodReference, arguments);
                }
            } else if (psiCommand instanceof RIdentifier || psiCommand instanceof RFid) {
                String reference = MyVisitor.createStaticMethodReference(psiCommand.getText());
                List arguments = ContainerUtil.map((Collection)call.getCallArguments().getElements(), PsiElement::getText);
                this.myMethodDescriptor = new MethodDescriptor((PsiElement)call, reference, arguments);
            }
        }

        @NotNull
        private static String createMethodReference(@NotNull String name) {
            if (name == null) {
                MyVisitor.$$$reportNull$$$0(7);
            }
            String string = "&:" + name;
            if (string == null) {
                MyVisitor.$$$reportNull$$$0(8);
            }
            return string;
        }

        @NotNull
        private static String createStaticMethodReference(@NotNull String name) {
            if (name == null) {
                MyVisitor.$$$reportNull$$$0(9);
            }
            String string = "&method(:" + name + ")";
            if (string == null) {
                MyVisitor.$$$reportNull$$$0(10);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unaryExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "binaryExpression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "identifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fid";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lambdaCall";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/blocktoreference/MethodDescriptor$MyVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/blocktoreference/MethodDescriptor$MyVisitor";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMethodReference";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStaticMethodReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRUnaryExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRBinaryExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRIdentifier";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRFid";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRReference";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRLambdaCall";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRCall";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createMethodReference";
                    break;
                }
                case 8: 
                case 10: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createStaticMethodReference";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8, 10 -> new IllegalStateException(string);
            };
        }
    }
}

