/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.assignmentinconditional;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.RubyParenthesesExpressionUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RReturnStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBeginEndBlockStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolBinExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolMatchingExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolNegExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RMathBinExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class RubyAssignmentExpressionInConditionalInspection
extends LocalInspectionTool {
    public boolean m_assignmentWithParentheses = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_assignmentWithParentheses", (String)RBundle.message((String)"inspection.assignment.in.conditional.parentheses.checkbox.label"), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            RubyAssignmentExpressionInConditionalInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyAssignmentExpressionInConditionalInspection.$$$reportNull$$$0(1);
        }
        return new RubyAssignmentExpressionInConditionalVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/assignmentinconditional/RubyAssignmentExpressionInConditionalInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/assignmentinconditional/RubyAssignmentExpressionInConditionalInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private class RubyAssignmentExpressionInConditionalVisitor
    extends RubyInspectionVisitor {
        RubyAssignmentExpressionInConditionalVisitor(ProblemsHolder holder) {
            super(holder);
        }

        public void visitRAssignmentExpression(@NotNull RAssignmentExpression assignmentExpression) {
            PsiElement rightOperand;
            IElementType type;
            PsiElement parent;
            if (assignmentExpression == null) {
                RubyAssignmentExpressionInConditionalVisitor.$$$reportNull$$$0(0);
            }
            boolean hasParenthesesAround = (parent = assignmentExpression.getParent()) instanceof RCompoundStatement && parent.getParent() instanceof RGroupedExpression;
            if ((parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)parent, (Class[])new Class[]{RBeginEndBlockStatement.class, RBoolMatchingExpression.class, RBoolBinExpression.class, RBoolNegExpression.class, RCondition.class, RCodeBlock.class})) instanceof RBoolBinExpression && ((type = ((RBoolBinExpression)parent).getOperationType()) == RubyTokenTypes.kOR || type == RubyTokenTypes.kAND) && ((rightOperand = RubyParenthesesExpressionUtil.getExpression((PsiElement)((RBoolBinExpression)parent).getRightOperand())) instanceof RMathBinExpressionImpl || rightOperand instanceof RCall || rightOperand instanceof RReturnStatement)) {
                return;
            }
            if (!(parent == null || parent instanceof RBoolMatchingExpression || parent instanceof RBeginEndBlockStatement || parent instanceof RCodeBlock || hasParenthesesAround && !RubyAssignmentExpressionInConditionalInspection.this.m_assignmentWithParentheses)) {
                if (!RubyAssignmentExpressionInConditionalInspection.this.m_assignmentWithParentheses) {
                    this.registerProblem((PsiElement)assignmentExpression, RBundle.message((String)"inspection.assignment.in.conditional"), new ConditionalFix(), new AddParenthesesFix());
                } else {
                    this.registerProblem((PsiElement)assignmentExpression, RBundle.message((String)"inspection.assignment.in.conditional"), new ConditionalFix());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignmentExpression", "org/jetbrains/plugins/ruby/ruby/inspections/assignmentinconditional/RubyAssignmentExpressionInConditionalInspection$RubyAssignmentExpressionInConditionalVisitor", "visitRAssignmentExpression"));
        }
    }

    private static class AddParenthesesFix
    extends RubyFix {
        private AddParenthesesFix() {
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            if (project == null) {
                AddParenthesesFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                AddParenthesesFix.$$$reportNull$$$0(1);
            }
            RAssignmentExpression expression = (RAssignmentExpression)descriptor.getPsiElement();
            RExpression generated = RubyElementFactoryCore.createExpressionFromText((PsiElement)expression, (String)("(" + expression.getText() + ")"));
            expression.replace((PsiElement)generated);
        }

        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.assignment.in.conditional.msg2");
            if (string == null) {
                AddParenthesesFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/assignmentinconditional/RubyAssignmentExpressionInConditionalInspection$AddParenthesesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/assignmentinconditional/RubyAssignmentExpressionInConditionalInspection$AddParenthesesFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class ConditionalFix
    extends RubyFix {
        private ConditionalFix() {
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement generatedOperation;
            RAssignmentExpression expression;
            PsiElement operation;
            if (project == null) {
                ConditionalFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                ConditionalFix.$$$reportNull$$$0(1);
            }
            if ((operation = (expression = (RAssignmentExpression)descriptor.getPsiElement()).getOperation()) == null) {
                return;
            }
            String text = "a == 1";
            RPsiElement fromText = RubyElementFactoryCore.createElementFromText((PsiElement)expression, (String)"a == 1");
            PsiElement sibling = fromText.getFirstChild().getNextSibling();
            if (sibling != null && (generatedOperation = sibling.getNextSibling()) != null) {
                operation.replace(generatedOperation);
                expression.replace((PsiElement)RubyElementFactoryCore.createExpressionFromText((PsiElement)expression, (String)expression.getText()));
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.assignment.in.conditional.msg");
            if (string == null) {
                ConditionalFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/assignmentinconditional/RubyAssignmentExpressionInConditionalInspection$ConditionalFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/assignmentinconditional/RubyAssignmentExpressionInConditionalInspection$ConditionalFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

