/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RemoveReturnFix;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.RControlFlowUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RConditionalStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RLoopStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RReturnStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;

public final class RubyUnnecessaryReturnStatementInspection
extends LocalInspectionTool {
    public boolean myWarnMultipleValues = true;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyUnnecessaryReturnStatementInspection.$$$reportNull$$$0(0);
        }
        return new RubyInspectionVisitor(holder){

            public void visitRMethod(@NotNull RMethod rMethod) {
                String name;
                if (rMethod == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean assignmentMethod = (name = rMethod.getName()).endsWith("=") && !name.equals("==") && !name.equals("===");
                for (RReturnStatement unnecessaryStatement : RubyUnnecessaryReturnStatementInspection.inspectMethod(rMethod, RubyUnnecessaryReturnStatementInspection.this.myWarnMultipleValues)) {
                    String quickFixText = unnecessaryStatement.getReturnValues().isEmpty() ? RBundle.message((String)"inspection.unnecessary.return.statement.replace.with.nil.fix") : RBundle.message((String)"inspection.unnecessary.return.statement.remove.fix");
                    this.registerProblem((PsiElement)(assignmentMethod ? unnecessaryStatement : unnecessaryStatement.getFirstChild()), assignmentMethod ? RBundle.message((String)"inspection.unnecessary.return.statement.in.assignment.message") : RBundle.message((String)"inspection.unnecessary.return.statement.message"), new RemoveReturnFix(quickFixText));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rMethod", "org/jetbrains/plugins/ruby/ruby/inspections/RubyUnnecessaryReturnStatementInspection$1", "visitRMethod"));
            }
        };
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myWarnMultipleValues", (String)RBundle.message((String)"inspection.unnecessary.return.statement.warn.multiple.values.return"), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            RubyUnnecessaryReturnStatementInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    public static List<RReturnStatement> inspectMethod(RMethod rMethod, boolean warnMultipleValues) {
        ArrayList<RReturnStatement> unnecessaryReturnStatements = new ArrayList<RReturnStatement>();
        Instruction[] instructions = rMethod.getControlFlow().getInstructions();
        for (Instruction instruction : RControlFlowUtil.findExitInstructions((ControlFlow)rMethod.getControlFlow())) {
            List statements;
            RPsiElement statement;
            int n;
            Instruction scopeInstruction;
            RPsiElement parent;
            RReturnStatement scope2Check;
            RReturnStatement returnStatement;
            PsiElement element = instruction.getElement();
            if (element == null || (returnStatement = element instanceof RReturnStatement ? (RReturnStatement)element : (RReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)element, RReturnStatement.class)) == null || !warnMultipleValues && returnStatement.getReturnValues().size() > 1 || PsiTreeUtil.getParentOfType((PsiElement)returnStatement, RLoopStatement.class) != null || (scope2Check = (parent = (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, (Class[])new Class[]{RMethod.class, RConditionalStatement.class})) instanceof RMethod ? returnStatement : parent) == null || (scopeInstruction = rMethod.getControlFlow().getInstructionByElement((PsiElement)scope2Check)) == null || !RubyUnnecessaryReturnStatementInspection.allThePendingInstructionsInside(instructions, n = scopeInstruction.num(), (PsiElement)scope2Check) || (statement = RubyPsiUtilCore.getStatement((PsiElement)scope2Check)) == null || rMethod.getCompoundStatement() != statement.getParent() || (statements = ((RCompoundStatement)statement.getParent()).getStatements()).get(statements.size() - 1) != statement) continue;
            unnecessaryReturnStatements.add(returnStatement);
        }
        return unnecessaryReturnStatements;
    }

    private static boolean allThePendingInstructionsInside(Instruction[] flow, int instructionNum, PsiElement scope) {
        return ControlFlowUtil.process((Instruction[])flow, (int)instructionNum, instruction -> RControlFlowUtil.collectPredecessorsWithoutCompoundAndBlockStatements((Instruction[])flow, (Instruction)instruction).stream().map(it -> it.getElement()).allMatch(element -> element == null || PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)element, (boolean)false)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/RubyUnnecessaryReturnStatementInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/RubyUnnecessaryReturnStatementInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

