/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RReturnStatement;

public class RemoveReturnFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(RemoveReturnFix.class);
    @NotNull
    @IntentionFamilyName
    private final String myText;

    public RemoveReturnFix(@NotNull @IntentionFamilyName String text) {
        if (text == null) {
            RemoveReturnFix.$$$reportNull$$$0(0);
        }
        this.myText = text;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myText;
        if (string == null) {
            RemoveReturnFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        if (project == null) {
            RemoveReturnFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            RemoveReturnFix.$$$reportNull$$$0(3);
        }
        if ((element = descriptor.getPsiElement()) instanceof RReturnStatement) {
            PsiElement prev = element.getPrevSibling();
            PsiElement firstToDelete = null;
            IElementType prevElementType = PsiUtilCore.getElementType((PsiElement)prev);
            if (RubySpaceUtil.isAnyNewLine((IElementType)prevElementType)) {
                firstToDelete = prev;
            }
            if (firstToDelete != null) {
                element.getParent().deleteChildRange(firstToDelete, element);
            } else {
                element.delete();
            }
            return;
        }
        RReturnStatement statement = (RReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)element, RReturnStatement.class);
        if (statement != null) {
            RemoveReturnFix.removeUnnecessaryReturn(statement);
        }
    }

    public static void removeUnnecessaryReturn(RReturnStatement statement) {
        RPsiElement elementForReplacement;
        LOG.assertTrue(statement != null, (Object)"Return statement cannot be null");
        List values = statement.getReturnValues();
        if (values.isEmpty()) {
            elementForReplacement = RubyElementFactoryCore.createElementFromText((PsiElement)statement, (String)"nil");
        } else if (values.size() == 1) {
            elementForReplacement = (RPsiElement)values.get(0);
        } else {
            String elementForReplacementText = "[" + StringUtil.join((Collection)values, PsiElement::getText, (String)", ") + "]";
            elementForReplacement = RubyElementFactoryCore.createElementFromText((PsiElement)statement, (String)elementForReplacementText);
        }
        statement.replace((PsiElement)elementForReplacement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/RemoveReturnFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/RemoveReturnFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

