/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;

public final class RUnnecessarySemicolonInspection
extends LocalInspectionTool {
    private static final TokenSet SEMICOLON_EOL = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{RubyTokenTypes.tSEMICOLON}), RubySpaceUtil.HARD_WHITESPACES});

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RUnnecessarySemicolonInspection.$$$reportNull$$$0(0);
        }
        return new RubyInspectionVisitor(this, holder){

            public void visitRCompoundStatement(@NotNull RCompoundStatement rCompoundStatement) {
                boolean isMultiLiner;
                if (rCompoundStatement == null) {
                    1.$$$reportNull$$$0(0);
                }
                ASTNode[] children = rCompoundStatement.getNode().getChildren(null);
                ASTNode lastSemicolon = null;
                boolean semicolonOrNewLineSeen = false;
                for (ASTNode child : children) {
                    IElementType type = child.getElementType();
                    if (SEMICOLON_EOL.contains(type) || child.getPsi() instanceof PsiWhiteSpace && child.getText().contains("\n")) {
                        if (type == RubyTokenTypes.tSEMICOLON) {
                            if (semicolonOrNewLineSeen) {
                                this.registerProblem(child.getPsi(), RBundle.message((String)"inspection.unnecessary.semicolon.message"), new RemoveUnnecessarySemicolonQuickFix());
                            } else {
                                lastSemicolon = child;
                            }
                        } else if (lastSemicolon != null) {
                            this.registerProblem(lastSemicolon.getPsi(), RBundle.message((String)"inspection.unnecessary.semicolon.message"), new RemoveUnnecessarySemicolonQuickFix());
                            lastSemicolon = null;
                        }
                        semicolonOrNewLineSeen = true;
                        continue;
                    }
                    semicolonOrNewLineSeen = false;
                    lastSemicolon = null;
                }
                if (semicolonOrNewLineSeen && lastSemicolon != null && (isMultiLiner = ((LeafPsiElement)lastSemicolon).getParent().getText().contains("\n"))) {
                    this.registerProblem(lastSemicolon.getPsi(), RBundle.message((String)"inspection.unnecessary.semicolon.message"), new RemoveUnnecessarySemicolonQuickFix());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rCompoundStatement", "org/jetbrains/plugins/ruby/ruby/inspections/RUnnecessarySemicolonInspection$1", "visitRCompoundStatement"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/ruby/ruby/inspections/RUnnecessarySemicolonInspection", "buildVisitor"));
    }

    private static class RemoveUnnecessarySemicolonQuickFix
    implements LocalQuickFix {
        private RemoveUnnecessarySemicolonQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.unnecessary.semicolon.quickfix.message");
            if (string == null) {
                RemoveUnnecessarySemicolonQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                RemoveUnnecessarySemicolonQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveUnnecessarySemicolonQuickFix.$$$reportNull$$$0(2);
            }
            descriptor.getPsiElement().delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/RUnnecessarySemicolonInspection$RemoveUnnecessarySemicolonQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/RUnnecessarySemicolonInspection$RemoveUnnecessarySemicolonQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

