/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.gem.facet;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.util.text.VersionComparatorUtil;
import icons.RubyIcons;
import java.util.StringJoiner;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.application.wizard.GemWizardSettings;
import org.jetbrains.plugins.ruby.gem.gem.GemRunner;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.GemProjectUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.wizard.GemGeneratorPeer;
import org.jetbrains.plugins.ruby.wizard.RubyFrameworkProjectGenerator;
import org.jetbrains.plugins.ruby.wizard.RubyWizardSharedSettings;

@InternalIgnoreDependencyViolation
public final class GemProjectGenerator
extends RubyFrameworkProjectGenerator<GemWizardSettings> {
    private static final Logger LOG = Logger.getInstance(GemProjectGenerator.class);

    @NotNull
    @Nls
    public String getName() {
        String string = RBundle.message((String)"gem.project.generator.name");
        if (string == null) {
            GemProjectGenerator.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public Icon getLogo() {
        Icon icon = RubyIcons.Ruby.Rubygems;
        if (icon == null) {
            GemProjectGenerator.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @Override
    public void doGenerateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull GemWizardSettings settings, @NotNull Module module) {
        Sdk sdk;
        if (project == null) {
            GemProjectGenerator.$$$reportNull$$$0(2);
        }
        if (baseDir == null) {
            GemProjectGenerator.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            GemProjectGenerator.$$$reportNull$$$0(4);
        }
        if (module == null) {
            GemProjectGenerator.$$$reportNull$$$0(5);
        }
        if ((sdk = ModuleRootManager.getInstance((Module)module).getSdk()) == null) {
            LOG.error("Cannot detect ruby SDK...");
            return;
        }
        if (BundlerUtil.getBundlerGem(sdk, null, false) == null) {
            GemProjectUtil.installBundler(module, sdk);
        }
        StringJoiner stringJoiner = new StringJoiner(" ").add(module.getName()).add(GemProjectGenerator.getOption(GemProjectGenerator.getExeOptionName(module, sdk), settings.isGenerateBinaryExecutable())).add(GemProjectGenerator.getOption("coc", settings.isGenerateCodeOfConduct())).add(GemProjectGenerator.getOption("ext", settings.isGenerateCExtensionBoilerplate())).add(GemProjectGenerator.getOption("mit", settings.isGenerateMitLicense())).add("--test=" + settings.getTestType().getOptionName());
        GemRunner.bundle(module, sdk, "gem", null, baseDir.getParent(), () -> VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{baseDir}), stringJoiner.toString());
        ModuleRootModificationUtil.updateModel((Module)module, model -> GemProjectGenerator.setupStandardTestSourceRoots(baseDir, model));
    }

    @Override
    @Nullable
    protected Sdk getSdkForNewProject(@NotNull GemWizardSettings settings) {
        if (settings == null) {
            GemProjectGenerator.$$$reportNull$$$0(6);
        }
        return settings.getSdk();
    }

    @NotNull
    private static String getOption(@NotNull String optionName, boolean isEnabled) {
        if (optionName == null) {
            GemProjectGenerator.$$$reportNull$$$0(7);
        }
        String string = "--" + (isEnabled ? "" : "no-") + optionName;
        if (string == null) {
            GemProjectGenerator.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String getExeOptionName(@NotNull Module module, @NotNull Sdk sdk) {
        GemInfo gem;
        if (module == null) {
            GemProjectGenerator.$$$reportNull$$$0(9);
        }
        if (sdk == null) {
            GemProjectGenerator.$$$reportNull$$$0(10);
        }
        if ((gem = RubyGemSearchUtil.findGem(module, sdk, "bundler")) == null || VersionComparatorUtil.compare((String)gem.getVersion(), (String)"1.12.0") >= 0) {
            return "exe";
        }
        return "bin";
    }

    @Override
    @NotNull
    public String getParentGroupName() {
        return "Ruby";
    }

    @Override
    @NotNull
    protected ProjectGeneratorPeer<GemWizardSettings> createPeer(@NotNull RubyWizardSharedSettings sharedSettings) {
        if (sharedSettings == null) {
            GemProjectGenerator.$$$reportNull$$$0(11);
        }
        return new GemGeneratorPeer(sharedSettings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/gem/facet/GemProjectGenerator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/gem/facet/GemProjectGenerator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOption";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateProject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSdkForNewProject";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOption";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getExeOptionName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createPeer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }
}

