/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.values;

import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.ImmediateFullValueEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.evaluate.XValueCompactPresentation;
import com.intellij.xdebugger.impl.pinned.items.PinToTopMemberValue;
import com.intellij.xdebugger.impl.pinned.items.PinnedItemInfo;
import com.intellij.xdebugger.impl.pinned.items.XDebuggerPinToTopManager;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RPsiPolyVariantReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebuggerSupportUtils;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyStackFrame;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyValueModifier;
import org.jetbrains.plugins.ruby.ruby.debugger.values.PinnedItemsRepresentation;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyArrayValue;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyHashItemValue;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyHashValue;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyStringValue;
import org.jetbrains.plugins.ruby.ruby.lang.RubyTextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyExpressionCodeFragmentImpl;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.RubyFullValue;
import org.rubyforge.debugcommons.model.RubyValue;
import org.rubyforge.debugcommons.model.RubyVariable;
import org.rubyforge.debugcommons.model.RubyVariableInfo;

public abstract class RubyDebugValue
extends XValue
implements PinToTopMemberValue {
    private static final Logger LOG = Logger.getInstance(RubyDebugValue.class);
    private static final String RUBY_STRING_CLASS = "String";
    protected final Project myProject;
    @Nullable
    protected final XSourcePosition myPosition;
    @NotNull
    private final String myName;
    @NotNull
    protected RubyValue myValue;
    @Nullable
    private Map<String, RubyVariable> myInstanceVariableNames;
    protected final RubyStackFrame myFrame;
    @Nullable
    protected final RubyDebugValue myParentDebugValue;
    @NotNull
    private final Icon myIcon;

    public RubyDebugValue(Project project, XSourcePosition position, @NotNull String name, @NotNull RubyValue value, RubyStackFrame frame, @Nullable RubyDebugValue parentDebugValue) {
        if (name == null) {
            RubyDebugValue.$$$reportNull$$$0(0);
        }
        if (value == null) {
            RubyDebugValue.$$$reportNull$$$0(1);
        }
        this(project, position, name, value, frame, parentDebugValue, AllIcons.Debugger.Value);
    }

    protected RubyDebugValue(Project project, @Nullable XSourcePosition position, @NotNull String name, @NotNull RubyValue value, RubyStackFrame frame, @Nullable RubyDebugValue parentDebugValue, @NotNull Icon icon) {
        if (name == null) {
            RubyDebugValue.$$$reportNull$$$0(2);
        }
        if (value == null) {
            RubyDebugValue.$$$reportNull$$$0(3);
        }
        if (icon == null) {
            RubyDebugValue.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myPosition = position;
        this.myName = name;
        this.myValue = value;
        this.myFrame = frame;
        this.myParentDebugValue = parentDebugValue;
        this.myIcon = icon;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            RubyDebugValue.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    protected Icon computeIconForNode(@NotNull XValueNode node) {
        if (node == null) {
            RubyDebugValue.$$$reportNull$$$0(6);
        }
        return this.getWatchesAwareIcon(node);
    }

    @Nullable
    private Map<String, RubyVariable> getInstanceVariableNames() {
        if (this.myInstanceVariableNames == null) {
            try {
                HashMap<String, RubyVariable> ans = new HashMap<String, RubyVariable>();
                for (RubyVariable variable : this.myValue.getVariables()) {
                    ans.put(variable.getName(), variable);
                }
                this.myInstanceVariableNames = ans;
            }
            catch (RubyDebuggerException e) {
                LOG.error("Error while obtaining instance variables for variable of type:" + this.myValue.getOwner().getReferenceTypeName(), (Throwable)e);
            }
        }
        return this.myInstanceVariableNames;
    }

    @NotNull
    protected XValuePresentation getPresentation(@NotNull XValuePlace place) {
        List<String> pinnedChildrenNames;
        List pinnedItemInfos;
        XDebuggerPinToTopManager manager;
        if (place == null) {
            RubyDebugValue.$$$reportNull$$$0(7);
        }
        if ((manager = XDebuggerPinToTopManager.Companion.getInstance(this.myProject)).isEnabled() && !(pinnedItemInfos = ContainerUtil.filter((Collection)XDebuggerPinToTopManager.Companion.getInstance(this.myProject).getPinnedItemInfos(), info -> info.getParentTag().equals(this.myValue.getReferenceTypeName()))).isEmpty() && this.getInstanceVariableNames() != null && !this.getInstanceVariableNames().isEmpty() && !(pinnedChildrenNames = pinnedItemInfos.stream().map(PinnedItemInfo::getMemberName).filter(name -> this.getInstanceVariableNames().containsKey(name)).collect(Collectors.toList())).isEmpty()) {
            return new PinnedItemsRepresentation(this.myValue, pinnedChildrenNames, this.myFrame, this, this.getPresentableTypeName(place), this.myPosition, place, this.myProject, this.getInstanceVariableNames());
        }
        boolean isCollection = this.myValue.getOwner().getVariableInfo().isCollection();
        String valueString = isCollection ? this.myValue.getOwner().getCompactValue() : this.myValue.getOwner().getValue().getValueString();
        return new RubyInlinePresentation(StringUtil.shortenTextWithEllipsis((String)RubyDebuggerSupportUtils.convertToIdeEncoding(valueString), (int)1000, (int)0, (boolean)true), this.getPresentableTypeName(place));
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            RubyDebugValue.$$$reportNull$$$0(8);
        }
        if (place == null) {
            RubyDebugValue.$$$reportNull$$$0(9);
        }
        if (node.isObsolete()) {
            return;
        }
        this.myValue.getProxy().submitRequest(ClientId.decorateRunnable(() -> {
            if (node.isObsolete()) {
                return;
            }
            node.setPresentation(this.computeIconForNode(node), this.getPresentation(place), this.myValue.hasVariables());
            this.setEvaluator(node);
        }));
    }

    private void setEvaluator(@NotNull XValueNode node) {
        RubyFrame rubyFrame;
        RubyDebuggerProxy debuggerProxy;
        if (node == null) {
            RubyDebugValue.$$$reportNull$$$0(10);
        }
        if (!(debuggerProxy = (rubyFrame = this.myFrame.getRubyFrame()).getProxy()).isSupportsLoadingFullValue()) {
            String fullValueString = this.myValue.getValueString();
            if (fullValueString.length() > 1000) {
                node.setFullValueEvaluator((XFullValueEvaluator)new ImmediateFullValueEvaluator(fullValueString));
            }
            return;
        }
        RubyVariableInfo rubyVariableInfo = this.myValue.getOwner().getVariableInfo();
        long valueSize = rubyVariableInfo.getValueStringSize();
        boolean isCollection = rubyVariableInfo.isCollection();
        String typeName = this.myValue.getReferenceTypeName();
        boolean isString = RUBY_STRING_CLASS.equals(typeName);
        if ((!isCollection || isString) && valueSize < 1000L) {
            return;
        }
        this.setFullValueEvaluator(node, RBundle.message((String)"ruby.debugger.inspect.value"));
    }

    private void setFullValueEvaluator(@NotNull XValueNode node, @Nls @NotNull String label) {
        if (node == null) {
            RubyDebugValue.$$$reportNull$$$0(11);
        }
        if (label == null) {
            RubyDebugValue.$$$reportNull$$$0(12);
        }
        final RubyFrame rubyFrame = this.myFrame.getRubyFrame();
        final RubyDebuggerProxy debuggerProxy = rubyFrame.getProxy();
        final String evaluationExpression = this.getEvaluationExpression();
        if (evaluationExpression == null) {
            return;
        }
        XFullValueEvaluator fullValueEvaluator = new XFullValueEvaluator(label){

            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                if (callback == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    if (!debuggerProxy.waitForDebuggerProxyReady()) {
                        callback.errorOccurred(RBundle.message((String)"ruby.debugger.is.not.ready"));
                    }
                    try {
                        RubyFullValue rubyFullValue = debuggerProxy.readFullValue(rubyFrame, true, evaluationExpression);
                        callback.evaluated(rubyFullValue.getFullValue());
                    }
                    catch (RubyDebuggerException e) {
                        LOG.info((Throwable)e);
                        String builder2 = RBundle.message((String)"ruby.debugger.could.not.evaluate", (Object[])new Object[]{RubyDebugValue.this.myName}) + "\n" + e.getMessage();
                        callback.errorOccurred(builder2);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/plugins/ruby/ruby/debugger/values/RubyDebugValue$1", "startEvaluation"));
            }
        };
        node.setFullValueEvaluator(fullValueEvaluator);
    }

    @Nullable
    protected String getPresentableTypeName(@NotNull XValuePlace place) {
        String typeName;
        if (place == null) {
            RubyDebugValue.$$$reportNull$$$0(13);
        }
        if ("Array".equals(typeName = this.myValue.getReferenceTypeName()) || "Hash".equals(typeName)) {
            return this.myValue.getValueString();
        }
        if ("NilClass".equals(typeName) || "TrueClass".equals(typeName) || "FalseClass".equals(typeName) || "Bignum".equals(typeName) || "Fixnum".equals(typeName) || "Float".equals(typeName) || RUBY_STRING_CLASS.equals(typeName) || "Integer".equals(typeName) || "Symbol".equals(typeName)) {
            return null;
        }
        return typeName;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            RubyDebugValue.$$$reportNull$$$0(14);
        }
        this.computeChildren(-1, node);
    }

    protected void computeChildren(int remainingElements, @NotNull XCompositeNode node) {
        if (node == null) {
            RubyDebugValue.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.doComputeChildren(remainingElements, node);
            }
            catch (RubyDebuggerException e) {
                LOG.info((Throwable)e);
            }
        });
    }

    protected void doComputeChildren(int remainingElements, @NotNull XCompositeNode node) throws RubyDebuggerException {
        if (node == null) {
            RubyDebugValue.$$$reportNull$$$0(16);
        }
        RubyDebuggerSupportUtils.addRubyVariablesToNode(this.myProject, this.myPosition, node, this.myValue.getVariables(), this.myFrame, this, true);
    }

    @Nullable
    public String getEvaluationExpression() {
        if (this.myParentDebugValue instanceof RubyStringValue) {
            return null;
        }
        if (this.myParentDebugValue == null) {
            return this.myName;
        }
        String parentExpression = this.myParentDebugValue.getEvaluationExpression();
        if (parentExpression == null) {
            return null;
        }
        if (this.myParentDebugValue instanceof RubyHashItemValue || this.myParentDebugValue instanceof RubyHashValue) {
            return parentExpression;
        }
        if (this.myParentDebugValue instanceof RubyArrayValue && this.myName.startsWith("[") && this.myName.endsWith("]")) {
            return parentExpression + this.myName;
        }
        return parentExpression + RubyDebuggerSupportUtils.getObtainFieldCommand(this.myName, this.myValue.getOwner());
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            RubyDebugValue.$$$reportNull$$$0(17);
        }
        this.computeSourcePosition(navigatable, false);
    }

    private void computeSourcePosition(@NotNull XNavigatable navigatable, boolean inline) {
        if (navigatable == null) {
            RubyDebugValue.$$$reportNull$$$0(18);
        }
        if ("self".equals(this.myName) || "block".equals(this.myName) || this.myPosition == null) {
            return;
        }
        if (!RubyTextUtil.isCID((String)this.myName) && !TextUtil.isField((String)this.myName)) {
            return;
        }
        VirtualFile positionFile = this.myPosition.getFile();
        int positionOffset = this.myPosition.getOffset();
        ApplicationManager.getApplication().executeOnPooledThread(() -> DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> {
            Document document = RubyDebuggerSupportUtils.createDocument(this.myName, this.myProject, positionFile, positionOffset);
            PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            LOG.assertTrue(file != null);
            PsiReference reference = ((RPsiElement)((RubyExpressionCodeFragmentImpl)file).getCompoundStatement().getStatements().get(0)).getReference();
            if (!(reference instanceof RPsiPolyVariantReference)) {
                return;
            }
            List<PsiElement> resolveResults = ResolveUtil.multiResolve(reference, true);
            PsiElement resolveResult = resolveResults.size() == 1 ? resolveResults.get(0) : (PsiElement)resolveResults.stream().filter(r -> positionFile.equals(PsiUtilCore.getVirtualFile((PsiElement)r)) && r.getTextRange().getStartOffset() < positionOffset).max(Comparator.comparing(PsiElement::getTextOffset)).orElse(null);
            if (resolveResult != null) {
                XSourcePosition position = XDebuggerUtil.getInstance().createPositionByOffset(resolveResult.getContainingFile().getVirtualFile(), resolveResult.getTextOffset());
                navigatable.setSourcePosition(position);
            }
            if (inline) {
                navigatable.setSourcePosition(this.myPosition);
            }
        }));
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback) {
        if (callback == null) {
            RubyDebugValue.$$$reportNull$$$0(19);
        }
        this.computeSourcePosition(arg_0 -> ((XInlineDebuggerDataCallback)callback).computed(arg_0), true);
        ThreeState threeState = ThreeState.YES;
        if (threeState == null) {
            RubyDebugValue.$$$reportNull$$$0(20);
        }
        return threeState;
    }

    public void computeTypeSourcePosition(@NotNull XNavigatable navigatable) {
        PsiFile psiFile;
        PsiElement declaration;
        Symbol symbol;
        if (navigatable == null) {
            RubyDebugValue.$$$reportNull$$$0(21);
        }
        if ((symbol = SymbolUtil.findConstantByFQN(this.myProject, this.myValue.getReferenceTypeName())) != null && (declaration = (PsiElement)ContainerUtil.getFirstItem((Collection)symbol.getAllDeclarations(psiFile = this.myPosition != null ? PsiManager.getInstance((Project)this.myProject).findFile(this.myPosition.getFile()) : null))) != null) {
            XSourcePosition position = XDebuggerUtil.getInstance().createPositionByOffset(declaration.getContainingFile().getVirtualFile(), declaration.getTextOffset());
            navigatable.setSourcePosition(position);
        }
    }

    public boolean canNavigateToSource() {
        return this.myPosition != null;
    }

    public boolean canNavigateToTypeSource() {
        return true;
    }

    public XValueModifier getModifier() {
        return new RubyValueModifier(this.myFrame, this.myName, this.myValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RubyDebugValue)) {
            return false;
        }
        RubyDebugValue value = (RubyDebugValue)((Object)o);
        if (!this.myName.equals(value.myName)) {
            return false;
        }
        return this.myValue.equals((Object)value.myValue);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + this.myValue.hashCode();
        return result;
    }

    @NotNull
    private Icon getWatchesAwareIcon(@NotNull XValueNode node) {
        XDebugSessionTab tab;
        if (node == null) {
            RubyDebugValue.$$$reportNull$$$0(22);
        }
        if (!(node instanceof WatchNodeImpl)) {
            Icon icon = this.myIcon;
            if (icon == null) {
                RubyDebugValue.$$$reportNull$$$0(23);
            }
            return icon;
        }
        XDebugSession session = XDebuggerManager.getInstance((Project)this.myProject).getCurrentSession();
        if (session != null && (tab = ((XDebugSessionImpl)session).getSessionTab()) != null && !tab.isWatchesInVariables()) {
            Icon icon = this.myIcon;
            if (icon == null) {
                RubyDebugValue.$$$reportNull$$$0(24);
            }
            return icon;
        }
        Icon icon = AllIcons.Debugger.Db_watch;
        if (icon == null) {
            RubyDebugValue.$$$reportNull$$$0(25);
        }
        return icon;
    }

    public boolean canBePinned() {
        RubyVariable parent = this.myValue.getOwner().getParent();
        return parent != null && !parent.getVariableInfo().isCollection();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 20, 23, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 5: 
            case 20: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/values/RubyDebugValue";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/values/RubyDebugValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInlineDebuggerData";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getWatchesAwareIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 20: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeIconForNode";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setEvaluator";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setFullValueEvaluator";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableTypeName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doComputeChildren";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "computeSourcePosition";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "computeInlineDebuggerData";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "computeTypeSourcePosition";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getWatchesAwareIcon";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 20, 23, 24, 25 -> new IllegalStateException(string);
        };
    }

    private static class RubyInlinePresentation
    extends XRegularValuePresentation
    implements XValueCompactPresentation {
        RubyInlinePresentation(@NotNull String valueText, @Nullable String typeText) {
            if (valueText == null) {
                RubyInlinePresentation.$$$reportNull$$$0(0);
            }
            super(valueText, typeText);
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer, @Nullable XValueNodeImpl node) {
            if (renderer == null) {
                RubyInlinePresentation.$$$reportNull$$$0(1);
            }
            this.renderValue(renderer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/values/RubyDebugValue$RubyInlinePresentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

