/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SimpleConfigurable;
import com.intellij.util.PlatformUtils;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.debugger.renderers.RubyTypeRenderersConfigurable;
import org.jetbrains.plugins.ruby.ruby.debugger.settings.RubyDebuggerConfigurable;
import org.jetbrains.plugins.ruby.ruby.debugger.settings.RubySteppingConfigurable;

public final class RubyDebuggerSettings
extends XDebuggerSettings<RubyDebuggerSettingsState> {
    private RubyDebuggerSettingsState myState = new RubyDebuggerSettingsState();

    public RubyDebuggerSettings() {
        super("ruby");
    }

    public static RubyDebuggerSettings getInstance() {
        return (RubyDebuggerSettings)RubyDebuggerSettings.getInstance(RubyDebuggerSettings.class);
    }

    @NotNull
    public Collection<? extends Configurable> createConfigurables(@NotNull DebuggerSettingsCategory category) {
        if (category == null) {
            RubyDebuggerSettings.$$$reportNull$$$0(0);
        }
        if (category == DebuggerSettingsCategory.GENERAL) {
            List<SimpleConfigurable> list = Collections.singletonList(SimpleConfigurable.create((String)"ruby.debug.configurable", (String)"Ruby", (String)"reference.settings.debugger.ruby", RubyDebuggerConfigurable.class, () -> this));
            if (list == null) {
                RubyDebuggerSettings.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (category == DebuggerSettingsCategory.STEPPING) {
            List<SimpleConfigurable> list = Collections.singletonList(SimpleConfigurable.create((String)"ruby.stepping.configurable", (String)"Ruby", (String)"reference.settings.debugger.ruby", RubySteppingConfigurable.class, () -> this));
            if (list == null) {
                RubyDebuggerSettings.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (category == DebuggerSettingsCategory.DATA_VIEWS) {
            List<RubyTypeRenderersConfigurable> list = Collections.singletonList(new RubyTypeRenderersConfigurable());
            if (list == null) {
                RubyDebuggerSettings.$$$reportNull$$$0(3);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            RubyDebuggerSettings.$$$reportNull$$$0(4);
        }
        return list;
    }

    public boolean isTargetedToProduct(@NotNull Configurable configurable) {
        if (configurable == null) {
            RubyDebuggerSettings.$$$reportNull$$$0(5);
        }
        return PlatformUtils.isRubyMine() && "Ruby".equals(configurable.getDisplayName());
    }

    @NotNull
    public RubyDebuggerSettingsState getState() {
        RubyDebuggerSettingsState rubyDebuggerSettingsState = this.myState;
        if (rubyDebuggerSettingsState == null) {
            RubyDebuggerSettings.$$$reportNull$$$0(6);
        }
        return rubyDebuggerSettingsState;
    }

    public void loadState(@NotNull RubyDebuggerSettingsState state) {
        if (state == null) {
            RubyDebuggerSettings.$$$reportNull$$$0(7);
        }
        this.myState = state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/settings/RubyDebuggerSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/settings/RubyDebuggerSettings";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurables";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurables";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isTargetedToProduct";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6 -> new IllegalStateException(string);
        };
    }

    public static final class RubyDebuggerSettingsState {
        private int myTimeout = 10;
        private boolean myEvaluationControl = true;
        private boolean myKeyValueHashPresentation = true;
        private int myTimeLimit = 100;
        private int myMemoryLimit = 0;
        private boolean myVerboseOutput = false;
        private boolean myMultiprocess = true;
        private boolean myReadNonSuspendedFrames = true;
        private boolean myStepIntoProjectOnly = false;
        private boolean myPerformSmartStepInto = true;
        private boolean myShouldStepOverGoIntoBlocks = true;

        public int getTimeout() {
            return this.myTimeout;
        }

        public void setTimeout(int timeout) {
            this.myTimeout = timeout;
        }

        public boolean isEvaluationControl() {
            return this.myEvaluationControl;
        }

        public void setEvaluationControl(boolean evaluationControl) {
            this.myEvaluationControl = evaluationControl;
        }

        public int getTimeLimit() {
            return this.myTimeLimit;
        }

        public void setTimeLimit(int timeLimit) {
            this.myTimeLimit = timeLimit;
        }

        public int getMemoryLimit() {
            return this.myMemoryLimit;
        }

        public void setMemoryLimit(int memoryLimit) {
            this.myMemoryLimit = memoryLimit;
        }

        public boolean isKeyValueHashPresentation() {
            return this.myKeyValueHashPresentation;
        }

        public void setKeyValueHashPresentation(boolean enable) {
            this.myKeyValueHashPresentation = enable;
        }

        public boolean isVerboseOutput() {
            return this.myVerboseOutput;
        }

        public void setVerboseOutput(boolean verboseOutput) {
            this.myVerboseOutput = verboseOutput;
        }

        public boolean isMultiprocess() {
            return this.myMultiprocess;
        }

        public void setMultiprocess(boolean multiprocess) {
            this.myMultiprocess = multiprocess;
        }

        public boolean isReadNonSuspendedFrames() {
            return this.myReadNonSuspendedFrames;
        }

        public void setReadNonSuspendedFrames(boolean readNonSuspendedFrames) {
            this.myReadNonSuspendedFrames = readNonSuspendedFrames;
        }

        public boolean isStepIntoProjectOnly() {
            return this.myStepIntoProjectOnly;
        }

        public void setStepIntoProjectOnly(boolean stepIntoProjectOnly) {
            this.myStepIntoProjectOnly = stepIntoProjectOnly;
        }

        public boolean isPerformSmartStepInto() {
            return this.myPerformSmartStepInto;
        }

        public void setPerformSmartStepInto(boolean performSmartStepInto) {
            this.myPerformSmartStepInto = performSmartStepInto;
        }

        public boolean shouldStepOverGoIntoBlocks() {
            return this.myShouldStepOverGoIntoBlocks;
        }

        public void setShouldStepOverGoIntoBlocks(boolean shouldStepOverGoIntoBlocks) {
            this.myShouldStepOverGoIntoBlocks = shouldStepOverGoIntoBlocks;
        }
    }
}

