/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.renderers;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionEditor;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.className.RubyClassTypeNameCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebuggerSupportUtils;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebugProcess;
import org.jetbrains.plugins.ruby.ruby.debugger.renderers.RubyNodeTypeRendererData;
import org.jetbrains.plugins.ruby.ruby.debugger.renderers.RubyTypeRendererEditorProvider;
import org.jetbrains.plugins.ruby.ruby.debugger.renderers.RubyTypeRenderersConfigurableUi;
import org.jetbrains.plugins.ruby.ruby.debugger.renderers.RubyTypeRenderersSettings;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyExpressionCodeFragment;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0002 !B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u0006\u0010\u0015\u001a\u00020\u0013J\b\u0010\u0016\u001a\u00020\u0007H\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0016\u0010\u0018\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aH\u0002J\u0012\u0010\u001b\u001a\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/ruby/ruby/debugger/renderers/RubyTypeRenderersConfigurableUi;", "", "<init>", "()V", "PANEL_SPLIT_PROPORTION", "", "project", "Lcom/intellij/openapi/project/Project;", "rendererChooser", "Lcom/intellij/ide/util/ElementsChooser;", "Lorg/jetbrains/plugins/ruby/ruby/debugger/renderers/RubyNodeTypeRendererData;", "rendererPanel", "Lorg/jetbrains/plugins/ruby/ruby/debugger/renderers/RubyTypeRenderersConfigurableUi$MyNodeTypeRendererPanel;", "currentRenderer", "createComponent", "Ljavax/swing/JComponent;", "isModified", "", "apply", "", "applyRenderersToDebugger", "reset", "setupProject", "setupRendererChooser", "updateCurrentRenderer", "selectedElements", "", "setCurrentRenderer", "renderer", "updateCurrentRendererName", "newName", "", "RendererChooserToolbarDecorator", "MyNodeTypeRendererPanel", "intellij.ruby.backend"})
@SourceDebugExtension(value={"SMAP\nRubyTypeRenderersConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RubyTypeRenderersConfigurable.kt\norg/jetbrains/plugins/ruby/ruby/debugger/renderers/RubyTypeRenderersConfigurableUi\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,374:1\n1869#2,2:375\n*S KotlinDebug\n*F\n+ 1 RubyTypeRenderersConfigurable.kt\norg/jetbrains/plugins/ruby/ruby/debugger/renderers/RubyTypeRenderersConfigurableUi\n*L\n91#1:375,2\n*E\n"})
final class RubyTypeRenderersConfigurableUi {
    private final float PANEL_SPLIT_PROPORTION;
    @NotNull
    private final Project project = this.setupProject();
    @NotNull
    private final ElementsChooser<RubyNodeTypeRendererData> rendererChooser = this.setupRendererChooser();
    @NotNull
    private final MyNodeTypeRendererPanel rendererPanel = new MyNodeTypeRendererPanel();
    @Nullable
    private RubyNodeTypeRendererData currentRenderer;

    public RubyTypeRenderersConfigurableUi() {
        this.PANEL_SPLIT_PROPORTION = 0.3f;
    }

    @NotNull
    public final JComponent createComponent() {
        Splitter splitter;
        ToolbarDecorator chooserDecorator = new RendererChooserToolbarDecorator(this.rendererChooser).getDecorator();
        Splitter $this$createComponent_u24lambda_u240 = splitter = new Splitter(false);
        boolean bl = false;
        $this$createComponent_u24lambda_u240.setProportion(this.PANEL_SPLIT_PROPORTION);
        $this$createComponent_u24lambda_u240.setFirstComponent((JComponent)chooserDecorator.createPanel());
        $this$createComponent_u24lambda_u240.setSecondComponent((JComponent)this.rendererPanel.getPanel());
        $this$createComponent_u24lambda_u240.setHonorComponentsMinimumSize(true);
        Splitter splitter2 = splitter;
        return (JComponent)splitter2;
    }

    public final boolean isModified() {
        if (this.rendererPanel.isModified()) {
            return true;
        }
        if (this.rendererChooser.getElementCount() != RubyTypeRenderersSettings.getInstance().getRenderers().size()) {
            return true;
        }
        List<RubyNodeTypeRendererData> list = RubyTypeRenderersSettings.getInstance().getRenderers();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getRenderers(...)");
        Iterable $this$forEach$iv = CollectionsKt.withIndex((Iterable)list);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexedValue it = (IndexedValue)element$iv;
            boolean bl = false;
            RubyNodeTypeRendererData element = (RubyNodeTypeRendererData)this.rendererChooser.getElementAt(it.getIndex());
            if (element.equalContent((RubyNodeTypeRendererData)it.getValue())) continue;
            return true;
        }
        return false;
    }

    public final void apply() {
        this.rendererPanel.apply();
        List renderers = new ArrayList();
        int n = this.rendererChooser.getElementCount();
        for (int i = 0; i < n; ++i) {
            RubyNodeTypeRendererData element = (RubyNodeTypeRendererData)this.rendererChooser.getElementAt(i);
            renderers.add(new RubyNodeTypeRendererData(element));
        }
        RubyTypeRenderersSettings.getInstance().setRenderers(renderers);
        this.applyRenderersToDebugger();
    }

    private final void applyRenderersToDebugger() {
        block0: {
            XDebugSession debugSession;
            XDebugSession xDebugSession = debugSession = XDebuggerManager.getInstance((Project)this.project).getCurrentSession();
            XDebugProcess debugProcess = xDebugSession != null ? xDebugSession.getDebugProcess() : null;
            RubyDebugProcess rubyDebugProcess = debugProcess instanceof RubyDebugProcess ? (RubyDebugProcess)debugProcess : null;
            if (rubyDebugProcess == null) break block0;
            RubyDebugProcess it = rubyDebugProcess;
            boolean bl = false;
            ApplicationManager.getApplication().executeOnPooledThread(() -> RubyTypeRenderersConfigurableUi.applyRenderersToDebugger$lambda$0$0(debugProcess, debugSession));
        }
    }

    public final void reset() {
        this.rendererChooser.removeAllElements();
        this.currentRenderer = null;
        for (RubyNodeTypeRendererData render : RubyTypeRenderersSettings.getInstance().getRenderers()) {
            RubyNodeTypeRendererData newRenderer = new RubyNodeTypeRendererData(render);
            this.rendererChooser.addElement((Object)newRenderer, newRenderer.isEnabled());
        }
        if (this.rendererChooser.getElementCount() != 0) {
            RubyNodeTypeRendererData firstRenderer = (RubyNodeTypeRendererData)this.rendererChooser.getElementAt(0);
            this.rendererChooser.selectElements((Collection)CollectionsKt.listOf((Object)firstRenderer));
        }
        this.rendererPanel.reset();
    }

    private final Project setupProject() {
        Project project;
        ProjectManager projectManager = ProjectManager.getInstance();
        Object[] objectArray = projectManager.getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getOpenProjects(...)");
        Object[] openProjects = objectArray;
        if (!(openProjects.length == 0)) {
            project = (Project)ArraysKt.first((Object[])openProjects);
        } else {
            Project project2 = projectManager.getDefaultProject();
            Intrinsics.checkNotNull((Object)project2);
            project = project2;
        }
        return project;
    }

    private final ElementsChooser<RubyNodeTypeRendererData> setupRendererChooser() {
        ElementsChooser<RubyNodeTypeRendererData> elementChooser2 = new ElementsChooser<RubyNodeTypeRendererData>(){

            protected String getItemText(RubyNodeTypeRendererData value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                String string = value.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                return string;
            }
        };
        elementChooser2.getEmptyText().setText(RBundle.message((String)"ruby.debugger.type.renderers.configurable.empty"));
        elementChooser2.addElementsMarkListener(RubyTypeRenderersConfigurableUi::setupRendererChooser$lambda$0);
        elementChooser2.addListSelectionListener(arg_0 -> RubyTypeRenderersConfigurableUi.setupRendererChooser$lambda$1(this, elementChooser2, arg_0));
        if (elementChooser2.getElementCount() > 0) {
            RubyNodeTypeRendererData first = (RubyNodeTypeRendererData)elementChooser2.getElementAt(0);
            elementChooser2.selectElements((Collection)CollectionsKt.listOf((Object)first));
        }
        return (ElementsChooser)elementChooser2;
    }

    private final void updateCurrentRenderer(List<? extends RubyNodeTypeRendererData> selectedElements) {
        if (selectedElements.size() == 1) {
            this.setCurrentRenderer(selectedElements.get(0));
        } else {
            this.setCurrentRenderer(null);
        }
    }

    private final void setCurrentRenderer(RubyNodeTypeRendererData renderer) {
        if (this.currentRenderer == renderer) {
            return;
        }
        if (this.rendererPanel.isModified()) {
            this.rendererPanel.apply();
        }
        this.currentRenderer = renderer;
        this.rendererPanel.reset();
    }

    private final void updateCurrentRendererName(String newName) {
        block0: {
            RubyNodeTypeRendererData rubyNodeTypeRendererData = this.currentRenderer;
            if (rubyNodeTypeRendererData == null) break block0;
            RubyNodeTypeRendererData it = rubyNodeTypeRendererData;
            boolean bl = false;
            it.setName(newName);
            this.rendererChooser.refresh((Object)it);
        }
    }

    private static final void applyRenderersToDebugger$lambda$0$0(XDebugProcess $debugProcess, XDebugSession $debugSession) {
        ((RubyDebugProcess)$debugProcess).setTypeRenderer();
        RubyDebuggerSupportUtils.invalidateSessionFrames($debugSession);
        $debugSession.rebuildViews();
    }

    private static final void setupRendererChooser$lambda$0(RubyNodeTypeRendererData element, boolean isMarked) {
        element.setEnabled(isMarked);
    }

    private static final void setupRendererChooser$lambda$1(RubyTypeRenderersConfigurableUi this$0, setupRendererChooser.elementChooser.1 $elementChooser, ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            List list = $elementChooser.getSelectedElements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedElements(...)");
            this$0.updateCurrentRenderer(list);
        }
    }

    public static final /* synthetic */ void access$updateCurrentRendererName(RubyTypeRenderersConfigurableUi $this, String newName) {
        $this.updateCurrentRendererName(newName);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000f\u001a\u00020\u000eJ\b\u0010\u0010\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0012J\u0006\u0010\u001a\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/ruby/ruby/debugger/renderers/RubyTypeRenderersConfigurableUi$MyNodeTypeRendererPanel;", "", "<init>", "(Lorg/jetbrains/plugins/ruby/ruby/debugger/renderers/RubyTypeRenderersConfigurableUi;)V", "textFieldWidth", "", "textFieldHeight", "myRendererNameTextField", "Lcom/intellij/ui/components/JBTextField;", "myClassTypeTextField", "Lcom/intellij/util/textCompletion/TextFieldWithCompletion;", "myMainExpressionEditor", "Lcom/intellij/xdebugger/impl/ui/XDebuggerExpressionEditor;", "myPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "getPanel", "createPanel", "addRendererNameChangeListener", "", "textField", "updateSelfTypeContext", "classFQN", "", "isModified", "", "apply", "reset", "intellij.ruby.backend"})
    private final class MyNodeTypeRendererPanel {
        private final int textFieldWidth = JBUIScale.scale((int)370);
        private final int textFieldHeight = JBUIScale.scale((int)29);
        @NotNull
        private final JBTextField myRendererNameTextField = new JBTextField();
        @NotNull
        private final TextFieldWithCompletion myClassTypeTextField = new TextFieldWithCompletion(RubyTypeRenderersConfigurableUi.access$getProject$p(RubyTypeRenderersConfigurableUi.this), (TextCompletionProvider)new RubyClassTypeNameCompletionProvider(RubyTypeRenderersConfigurableUi.access$getProject$p(RubyTypeRenderersConfigurableUi.this)), "", true, true, true);
        @NotNull
        private final XDebuggerExpressionEditor myMainExpressionEditor = new XDebuggerExpressionEditor(RubyTypeRenderersConfigurableUi.access$getProject$p(RubyTypeRenderersConfigurableUi.this), (XDebuggerEditorsProvider)new RubyTypeRendererEditorProvider(), "TypeRendererMainExpression", null, XExpressionImpl.EMPTY_EXPRESSION, false, false, true);
        @NotNull
        private final DialogPanel myPanel = this.createPanel();

        @NotNull
        public final DialogPanel getPanel() {
            return this.myPanel;
        }

        private final DialogPanel createPanel() {
            DialogPanel panel2 = BuilderKt.panel(arg_0 -> MyNodeTypeRendererPanel.createPanel$lambda$0(this, arg_0));
            return panel2;
        }

        private final void addRendererNameChangeListener(JBTextField textField) {
            textField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(textField, RubyTypeRenderersConfigurableUi.this){
                final /* synthetic */ JBTextField $textField;
                final /* synthetic */ RubyTypeRenderersConfigurableUi this$0;
                {
                    this.$textField = $textField;
                    this.this$0 = $receiver;
                }

                protected void textChanged(javax.swing.event.DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    String newName = this.$textField.getText();
                    Intrinsics.checkNotNull((Object)newName);
                    RubyTypeRenderersConfigurableUi.access$updateCurrentRendererName(this.this$0, newName);
                }
            });
        }

        private final void updateSelfTypeContext(String classFQN) {
            String contextText = StringsKt.trimIndent((String)("\n        class " + classFQN + "\n          def foo\n            pass\n          end\n        end\n        "));
            RubyExpressionCodeFragment rubyExpressionCodeFragment = RubyElementFactory.createExpressionCodeFragment(RubyTypeRenderersConfigurableUi.this.project, contextText, null, true);
            Intrinsics.checkNotNullExpressionValue((Object)rubyExpressionCodeFragment, (String)"createExpressionCodeFragment(...)");
            RubyExpressionCodeFragment contextWithSelf = rubyExpressionCodeFragment;
            int offset = StringsKt.indexOf$default((CharSequence)contextText, (String)"pass", (int)0, (boolean)false, (int)6, null);
            XSourcePosition srcPosition = XDebuggerUtil.getInstance().createPositionByOffset(contextWithSelf.getVirtualFile(), offset);
            this.myMainExpressionEditor.setSourcePosition(srcPosition);
        }

        public final boolean isModified() {
            RubyNodeTypeRendererData rubyNodeTypeRendererData = RubyTypeRenderersConfigurableUi.this.currentRenderer;
            if (rubyNodeTypeRendererData != null) {
                RubyNodeTypeRendererData it = rubyNodeTypeRendererData;
                boolean bl = false;
                return !Intrinsics.areEqual((Object)it.getName(), (Object)this.myRendererNameTextField.getText()) || !Intrinsics.areEqual((Object)it.getType(), (Object)this.myClassTypeTextField.getText()) || !Intrinsics.areEqual((Object)it.getMainExpression(), (Object)this.myMainExpressionEditor.getExpression().getExpression());
            }
            return false;
        }

        public final void apply() {
            block0: {
                this.myPanel.apply();
                RubyNodeTypeRendererData rubyNodeTypeRendererData = RubyTypeRenderersConfigurableUi.this.currentRenderer;
                if (rubyNodeTypeRendererData == null) break block0;
                RubyNodeTypeRendererData it = rubyNodeTypeRendererData;
                boolean bl = false;
                it.setName(this.myRendererNameTextField.getText());
                it.setType(this.myClassTypeTextField.getText());
                it.setMainExpression(this.myMainExpressionEditor.getExpression().getExpression());
            }
        }

        public final void reset() {
            RubyNodeTypeRendererData rubyNodeTypeRendererData = RubyTypeRenderersConfigurableUi.this.currentRenderer;
            if (rubyNodeTypeRendererData != null) {
                RubyNodeTypeRendererData it = rubyNodeTypeRendererData;
                boolean bl = false;
                this.myRendererNameTextField.setText(it.getName());
                this.myClassTypeTextField.setText(it.getType());
                this.myMainExpressionEditor.setExpression((XExpression)XExpressionImpl.fromText((String)it.getMainExpression()));
                this.myPanel.setVisible(true);
            } else {
                MyNodeTypeRendererPanel $this$reset_u24lambda_u241 = this;
                boolean bl = false;
                $this$reset_u24lambda_u241.myPanel.setVisible(false);
            }
        }

        private static final Unit createPanel$lambda$0(MyNodeTypeRendererPanel this$0, Panel $this$panel) {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            Panel.row$default((Panel)$this$panel, null, arg_0 -> MyNodeTypeRendererPanel.createPanel$lambda$0$0(this$0, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> MyNodeTypeRendererPanel.createPanel$lambda$0$1(this$0, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> MyNodeTypeRendererPanel.createPanel$lambda$0$2(this$0, arg_0), (int)1, null);
            return Unit.INSTANCE;
        }

        private static final Unit createPanel$lambda$0$0(MyNodeTypeRendererPanel this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Cell cell = $this$row.cell((JComponent)this$0.myRendererNameTextField).align((Align)AlignX.FILL.INSTANCE);
            String string = RBundle.message((String)"ruby.debugger.type.renderers.configurable.renderer.name.label");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            cell.label(string, LabelPosition.LEFT).applyToComponent(arg_0 -> MyNodeTypeRendererPanel.createPanel$lambda$0$0$0(this$0, arg_0));
            return Unit.INSTANCE;
        }

        private static final Unit createPanel$lambda$0$0$0(MyNodeTypeRendererPanel this$0, JBTextField $this$applyToComponent) {
            Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
            this$0.addRendererNameChangeListener($this$applyToComponent);
            $this$applyToComponent.setPreferredSize(new Dimension(this$0.textFieldWidth, this$0.textFieldHeight));
            return Unit.INSTANCE;
        }

        private static final Unit createPanel$lambda$0$1(MyNodeTypeRendererPanel this$0, Row $this$row) {
            Cell cell;
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Cell $this$createPanel_u24lambda_u240_u241_u240 = cell = $this$row.cell((JComponent)this$0.myClassTypeTextField);
            boolean bl = false;
            String string = RBundle.message((String)"ruby.debugger.type.renderers.configurable.renderer.type.label");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $this$createPanel_u24lambda_u240_u241_u240.label(string, LabelPosition.TOP);
            $this$createPanel_u24lambda_u240_u241_u240.align((Align)AlignX.FILL.INSTANCE);
            Cell.comment$default((Cell)$this$createPanel_u24lambda_u240_u241_u240, (String)RBundle.message((String)"ruby.debugger.type.renderers.configurable.renderer.type.comment"), (int)0, null, (int)6, null);
            ((TextFieldWithCompletion)$this$createPanel_u24lambda_u240_u241_u240.getComponent()).setPreferredSize(new Dimension(this$0.textFieldWidth, this$0.textFieldHeight));
            ((TextFieldWithCompletion)$this$createPanel_u24lambda_u240_u241_u240.getComponent()).addDocumentListener(new DocumentListener(this$0, (Cell<? extends TextFieldWithCompletion>)$this$createPanel_u24lambda_u240_u241_u240){
                final /* synthetic */ MyNodeTypeRendererPanel this$0;
                final /* synthetic */ Cell<TextFieldWithCompletion> $this_apply;
                {
                    this.this$0 = $receiver;
                    this.$this_apply = $receiver2;
                }

                public void documentChanged(DocumentEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    String string = ((TextFieldWithCompletion)this.$this_apply.getComponent()).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    MyNodeTypeRendererPanel.access$updateSelfTypeContext(this.this$0, string);
                }
            });
            return Unit.INSTANCE;
        }

        private static final Unit createPanel$lambda$0$2(MyNodeTypeRendererPanel this$0, Row $this$row) {
            Cell cell;
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            JComponent jComponent = this$0.myMainExpressionEditor.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            Cell $this$createPanel_u24lambda_u240_u242_u240 = cell = $this$row.cell(jComponent);
            boolean bl = false;
            String string = RBundle.message((String)"ruby.debugger.type.renderers.configurable.renderer.mainExpression.label");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $this$createPanel_u24lambda_u240_u242_u240.label(string, LabelPosition.TOP);
            Cell.comment$default((Cell)$this$createPanel_u24lambda_u240_u242_u240, (String)RBundle.message((String)"ruby.debugger.type.renderers.configurable.renderer.mainExpression.comment"), (int)0, null, (int)6, null);
            $this$createPanel_u24lambda_u240_u242_u240.align((Align)AlignX.FILL.INSTANCE);
            $this$createPanel_u24lambda_u240_u242_u240.getComponent().setPreferredSize(new Dimension(this$0.textFieldWidth, this$0.textFieldHeight));
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ void access$updateSelfTypeContext(MyNodeTypeRendererPanel $this, String classFQN) {
            $this.updateSelfTypeContext(classFQN);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0003\u000e\u000f\u0010B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/ruby/ruby/debugger/renderers/RubyTypeRenderersConfigurableUi$RendererChooserToolbarDecorator;", "", "myRendererChooser", "Lcom/intellij/ide/util/ElementsChooser;", "Lorg/jetbrains/plugins/ruby/ruby/debugger/renderers/RubyNodeTypeRendererData;", "<init>", "(Lcom/intellij/ide/util/ElementsChooser;)V", "decorator", "Lcom/intellij/ui/ToolbarDecorator;", "Lorg/jetbrains/annotations/NotNull;", "getDecorator", "()Lcom/intellij/ui/ToolbarDecorator;", "getNewRendererName", "", "AddAction", "RemoveAction", "MoveAction", "intellij.ruby.backend"})
    @SourceDebugExtension(value={"SMAP\nRubyTypeRenderersConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RubyTypeRenderersConfigurable.kt\norg/jetbrains/plugins/ruby/ruby/debugger/renderers/RubyTypeRenderersConfigurableUi$RendererChooserToolbarDecorator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,374:1\n774#2:375\n865#2,2:376\n*S KotlinDebug\n*F\n+ 1 RubyTypeRenderersConfigurable.kt\norg/jetbrains/plugins/ruby/ruby/debugger/renderers/RubyTypeRenderersConfigurableUi$RendererChooserToolbarDecorator\n*L\n219#1:375\n219#1:376,2\n*E\n"})
    private static final class RendererChooserToolbarDecorator {
        @NotNull
        private final ElementsChooser<RubyNodeTypeRendererData> myRendererChooser;
        @NotNull
        private final ToolbarDecorator decorator;

        public RendererChooserToolbarDecorator(@NotNull ElementsChooser<RubyNodeTypeRendererData> myRendererChooser) {
            Intrinsics.checkNotNullParameter(myRendererChooser, (String)"myRendererChooser");
            this.myRendererChooser = myRendererChooser;
            ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JComponent)this.myRendererChooser.getComponent());
            Intrinsics.checkNotNullExpressionValue((Object)toolbarDecorator, (String)"createDecorator(...)");
            this.decorator = toolbarDecorator;
            this.decorator.setToolbarPosition(ActionToolbarPosition.TOP);
            this.decorator.setAddAction((AnActionButtonRunnable)new AddAction());
            this.decorator.setRemoveAction((AnActionButtonRunnable)new RemoveAction());
            this.decorator.setMoveUpAction((AnActionButtonRunnable)new MoveAction(true));
            this.decorator.setMoveDownAction((AnActionButtonRunnable)new MoveAction(false));
        }

        @NotNull
        public final ToolbarDecorator getDecorator() {
            return this.decorator;
        }

        /*
         * WARNING - void declaration
         */
        private final String getNewRendererName() {
            void $this$filterTo$iv$iv;
            String string = RBundle.message((String)"ruby.debugger.type.renderers.configurable.default.renderer.name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = string;
            List existingNames = new ArrayList();
            int n = this.myRendererChooser.getElementCount();
            for (int i = 0; i < n; ++i) {
                Object object = (RubyNodeTypeRendererData)this.myRendererChooser.getElementAt(i);
                if (object == null || (object = ((RubyNodeTypeRendererData)object).getName()) == null) continue;
                Object name = object;
                boolean bl = false;
                existingNames.add(name);
            }
            if (existingNames.isEmpty()) {
                return string2;
            }
            Iterable $this$filter$iv = existingNames;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)string2, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            int duplicatedNames = ((List)destination$iv$iv).size();
            return duplicatedNames > 0 ? string2 + " (" + duplicatedNames + ")" : string2;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/ruby/ruby/debugger/renderers/RubyTypeRenderersConfigurableUi$RendererChooserToolbarDecorator$AddAction;", "Lcom/intellij/ui/AnActionButtonRunnable;", "<init>", "(Lorg/jetbrains/plugins/ruby/ruby/debugger/renderers/RubyTypeRenderersConfigurableUi$RendererChooserToolbarDecorator;)V", "run", "", "button", "Lcom/intellij/ui/AnActionButton;", "intellij.ruby.backend"})
        private final class AddAction
        implements AnActionButtonRunnable {
            public void run(@Nullable AnActionButton button) {
                RubyNodeTypeRendererData renderer = new RubyNodeTypeRendererData(RendererChooserToolbarDecorator.this.getNewRendererName());
                RendererChooserToolbarDecorator.this.myRendererChooser.addElement((Object)renderer, renderer.isEnabled());
                RendererChooserToolbarDecorator.this.myRendererChooser.moveElement((Object)renderer, 0);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/ruby/ruby/debugger/renderers/RubyTypeRenderersConfigurableUi$RendererChooserToolbarDecorator$MoveAction;", "Lcom/intellij/ui/AnActionButtonRunnable;", "myMoveUp", "", "<init>", "(Lorg/jetbrains/plugins/ruby/ruby/debugger/renderers/RubyTypeRenderersConfigurableUi$RendererChooserToolbarDecorator;Z)V", "getMyMoveUp", "()Z", "run", "", "button", "Lcom/intellij/ui/AnActionButton;", "intellij.ruby.backend"})
        private final class MoveAction
        implements AnActionButtonRunnable {
            private final boolean myMoveUp;

            public MoveAction(boolean myMoveUp) {
                this.myMoveUp = myMoveUp;
            }

            public final boolean getMyMoveUp() {
                return this.myMoveUp;
            }

            public void run(@Nullable AnActionButton button) {
                int selectedRow = RendererChooserToolbarDecorator.this.myRendererChooser.getSelectedElementRow();
                if (selectedRow < 0) {
                    return;
                }
                int newRow = selectedRow + (this.myMoveUp ? -1 : 1);
                if (newRow < 0) {
                    newRow = RendererChooserToolbarDecorator.this.myRendererChooser.getElementCount() - 1;
                } else if (newRow >= RendererChooserToolbarDecorator.this.myRendererChooser.getElementCount()) {
                    newRow = 0;
                }
                RendererChooserToolbarDecorator.this.myRendererChooser.moveElement(RendererChooserToolbarDecorator.this.myRendererChooser.getElementAt(selectedRow), newRow);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/ruby/ruby/debugger/renderers/RubyTypeRenderersConfigurableUi$RendererChooserToolbarDecorator$RemoveAction;", "Lcom/intellij/ui/AnActionButtonRunnable;", "<init>", "(Lorg/jetbrains/plugins/ruby/ruby/debugger/renderers/RubyTypeRenderersConfigurableUi$RendererChooserToolbarDecorator;)V", "run", "", "button", "Lcom/intellij/ui/AnActionButton;", "intellij.ruby.backend"})
        @SourceDebugExtension(value={"SMAP\nRubyTypeRenderersConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RubyTypeRenderersConfigurable.kt\norg/jetbrains/plugins/ruby/ruby/debugger/renderers/RubyTypeRenderersConfigurableUi$RendererChooserToolbarDecorator$RemoveAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,374:1\n1869#2,2:375\n*S KotlinDebug\n*F\n+ 1 RubyTypeRenderersConfigurable.kt\norg/jetbrains/plugins/ruby/ruby/debugger/renderers/RubyTypeRenderersConfigurableUi$RendererChooserToolbarDecorator$RemoveAction\n*L\n238#1:375,2\n*E\n"})
        private final class RemoveAction
        implements AnActionButtonRunnable {
            /*
             * WARNING - void declaration
             */
            public void run(@Nullable AnActionButton button) {
                void $this$forEach$iv;
                List list = RendererChooserToolbarDecorator.this.myRendererChooser.getSelectedElements();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedElements(...)");
                Iterable iterable = list;
                RendererChooserToolbarDecorator rendererChooserToolbarDecorator = RendererChooserToolbarDecorator.this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RubyNodeTypeRendererData it = (RubyNodeTypeRendererData)element$iv;
                    boolean bl = false;
                    rendererChooserToolbarDecorator.myRendererChooser.removeElement((Object)it);
                }
            }
        }
    }
}

