/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueModifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyStackFrame;
import org.rubyforge.debugcommons.model.RubyHashItemInfo;
import org.rubyforge.debugcommons.model.RubyValue;
import org.rubyforge.debugcommons.model.RubyVariable;
import org.rubyforge.debugcommons.model.RubyVariableInfo;

public class RubyValueModifier
extends XValueModifier {
    private final RubyStackFrame myFrame;
    private final String myName;
    @NotNull
    private final RubyValue myValue;

    public RubyValueModifier(RubyStackFrame frame, String name, @NotNull RubyValue value) {
        if (value == null) {
            RubyValueModifier.$$$reportNull$$$0(0);
        }
        this.myFrame = frame;
        this.myName = name;
        this.myValue = value;
    }

    @NotNull
    public static String wrapInObjectId(@NotNull RubyVariableInfo variable) {
        if (variable == null) {
            RubyValueModifier.$$$reportNull$$$0(1);
        }
        String string = "ObjectSpace._id2ref(" + variable.getObjectId() + ")";
        if (string == null) {
            RubyValueModifier.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setValue(@NotNull XExpression expression, final @NotNull XValueModifier.XModificationCallback callback) {
        if (expression == null) {
            RubyValueModifier.$$$reportNull$$$0(3);
        }
        if (callback == null) {
            RubyValueModifier.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            XDebuggerEvaluator evaluator = this.myFrame.getEvaluator();
            this.myFrame.getRubyFrame().clearCachedVariables();
            if (evaluator == null) {
                callback.errorOccurred(RBundle.message((String)"dialog.message.no.evaluator.available.for.frame", (Object[])new Object[]{this.myFrame}));
                return;
            }
            RubyVariable parent = this.myValue.getOwner().getParent();
            Object command = parent == null || "self".equals(parent.getName()) ? this.myName + " = " + expression.getExpression() : this.getSetValueCommand(parent, expression.getExpression());
            evaluator.evaluate((String)command, new XDebuggerEvaluator.XEvaluationCallback(){

                public void evaluated(@NotNull XValue result) {
                    if (result == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    callback.valueModified();
                }

                public void errorOccurred(@NotNull String errorMessage) {
                    if (errorMessage == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    callback.errorOccurred(errorMessage);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "result";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorMessage";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyValueModifier$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "evaluated";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "errorOccurred";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, this.myFrame.getSourcePosition());
        });
    }

    @NotNull
    private String getSetValueCommand(@NotNull RubyVariable parent, @NotNull String expressionString) {
        String expr;
        RubyVariableInfo parentVariableInfo;
        if (parent == null) {
            RubyValueModifier.$$$reportNull$$$0(5);
        }
        if (expressionString == null) {
            RubyValueModifier.$$$reportNull$$$0(6);
        }
        if ((parentVariableInfo = parent.getVariableInfo()) instanceof RubyHashItemInfo && (expr = this.getHashSetValueExpression(parent, expressionString)) != null) {
            String string = expr;
            if (string == null) {
                RubyValueModifier.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (StringUtil.startsWithChar((CharSequence)this.myName, (char)'[') && StringUtil.endsWithChar((CharSequence)this.myName, (char)']') && "Array".equals(parent.getVariableInfo().getType())) {
            return this.getArraySetValueExpression(parentVariableInfo, expressionString);
        }
        return this.getRegularSetValueExpression(parentVariableInfo, expressionString);
    }

    @Nullable
    private String getHashSetValueExpression(@NotNull RubyVariable hashItemVariable, @NotNull String expression) {
        if (hashItemVariable == null) {
            RubyValueModifier.$$$reportNull$$$0(8);
        }
        if (expression == null) {
            RubyValueModifier.$$$reportNull$$$0(9);
        }
        if (hashItemVariable.getParent() == null) {
            return null;
        }
        RubyHashItemInfo hashItemInfo = (RubyHashItemInfo)hashItemVariable.getVariableInfo();
        RubyVariableInfo hashInfo = hashItemVariable.getParent().getVariableInfo();
        RubyVariableInfo itemVariableInfo = this.myValue.getOwner().getVariableInfo();
        if (hashItemInfo.getValueInfo() == itemVariableInfo) {
            return RubyValueModifier.wrapInObjectId(hashInfo) + "[" + RubyValueModifier.wrapInObjectId(hashItemInfo.getKeyInfo()) + "] = " + expression;
        }
        if (hashItemInfo.getKeyInfo() == itemVariableInfo) {
            return RubyValueModifier.wrapInObjectId(hashInfo) + "[" + expression + "] = (" + RubyValueModifier.wrapInObjectId(hashInfo) + ").delete " + RubyValueModifier.wrapInObjectId(itemVariableInfo);
        }
        return null;
    }

    @NotNull
    private String getRegularSetValueExpression(@NotNull RubyVariableInfo parentVariable, @NotNull String expressionString) {
        if (parentVariable == null) {
            RubyValueModifier.$$$reportNull$$$0(10);
        }
        if (expressionString == null) {
            RubyValueModifier.$$$reportNull$$$0(11);
        }
        String string = RubyValueModifier.wrapInObjectId(parentVariable) + ".instance_eval(\"" + this.myName + " = " + StringUtil.escapeQuotes((String)expressionString) + "\")";
        if (string == null) {
            RubyValueModifier.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private String getArraySetValueExpression(@NotNull RubyVariableInfo parentVariable, @NotNull String expressionString) {
        if (parentVariable == null) {
            RubyValueModifier.$$$reportNull$$$0(13);
        }
        if (expressionString == null) {
            RubyValueModifier.$$$reportNull$$$0(14);
        }
        String string = RubyValueModifier.wrapInObjectId(parentVariable) + this.myName + " = " + expressionString;
        if (string == null) {
            RubyValueModifier.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 12, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 2: 
            case 7: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyValueModifier";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionString";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashItemVariable";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyValueModifier";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInObjectId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSetValueCommand";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegularSetValueExpression";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getArraySetValueExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "wrapInObjectId";
                break;
            }
            case 2: 
            case 7: 
            case 12: 
            case 15: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSetValueCommand";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getHashSetValueExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRegularSetValueExpression";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getArraySetValueExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 12, 15 -> new IllegalStateException(string);
        };
    }
}

