/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XSuspendContext;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebugProcess;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyExecutionStack;
import org.rubyforge.debugcommons.RubyDebugEvent;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.RubyDebugTarget;
import org.rubyforge.debugcommons.model.RubyThread;

public class RubySuspendContext
extends XSuspendContext {
    private static final Logger LOG = Logger.getInstance(RubySuspendContext.class);
    private final AtomicNotNullLazyValue<Pair<RubyExecutionStack, XExecutionStack[]>> myDataProvider;
    private final RubyDebugEvent myDebugEvent;

    public RubySuspendContext(@NotNull Project project, @NotNull RubyDebugProcess process, @NotNull RubyDebugEvent event) {
        if (project == null) {
            RubySuspendContext.$$$reportNull$$$0(0);
        }
        if (process == null) {
            RubySuspendContext.$$$reportNull$$$0(1);
        }
        if (event == null) {
            RubySuspendContext.$$$reportNull$$$0(2);
        }
        this.myDebugEvent = event;
        this.myDataProvider = AtomicNotNullLazyValue.createValue(() -> {
            String threadName = Thread.currentThread().getName();
            LOG.debug("Computing suspend context data on ", new Object[]{threadName});
            Ref rubyExecutionStackRef = Ref.create();
            LinkedList executionStacks = new LinkedList();
            for (RubyDebuggerProxy debuggerProxy : process.myRubyDebuggerProxies) {
                if (!debuggerProxy.waitForDebuggerProxyReady()) {
                    LOG.debug("Proxy is not ready ", new Object[]{debuggerProxy});
                    continue;
                }
                RubyDebugTarget debugTarget = debuggerProxy.getDebugTarget();
                RubyThread[] rubyThreads = debugTarget.getThreads();
                Arrays.stream(rubyThreads).map(rubyThread -> debugTarget.getThreadById(rubyThread.getId())).filter(Objects::nonNull).map(rubyThread -> {
                    RubyExecutionStack stack = new RubyExecutionStack(project, process, debuggerProxy, (RubyThread)rubyThread, this.myDebugEvent);
                    if (this.myDebugEvent.getRubyThread() == rubyThread) {
                        rubyExecutionStackRef.set((Object)stack);
                    }
                    return stack;
                }).forEach(stack -> executionStacks.add(stack));
            }
            Pair result = Pair.create((Object)((Object)((RubyExecutionStack)((Object)((Object)rubyExecutionStackRef.get())))), (Object)executionStacks.toArray(XExecutionStack.EMPTY_ARRAY));
            LOG.debug("Computed suspend context on ", new Object[]{threadName, " for ", ((XExecutionStack[])result.second).length, " threads, active stack ", result.first});
            return result;
        });
    }

    public XExecutionStack getActiveExecutionStack() {
        return (XExecutionStack)((Pair)this.myDataProvider.getValue()).getFirst();
    }

    public XExecutionStack @NotNull [] getExecutionStacks() {
        XExecutionStack[] xExecutionStackArray = (XExecutionStack[])((Pair)this.myDataProvider.getValue()).getSecond();
        if (xExecutionStackArray == null) {
            RubySuspendContext.$$$reportNull$$$0(3);
        }
        return xExecutionStackArray;
    }

    public String toString() {
        return "RubySuspendContext{mySuspensionEvent=" + String.valueOf(this.myDebugEvent) + ", isDataComputed=" + this.myDataProvider.isComputed() + "} ";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubySuspendContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubySuspendContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionStacks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

