/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyLocationMapper;
import org.rubyforge.debugcommons.model.RubySuspensionLocation;

public class RubySourcePosition
implements XSourcePosition,
ExecutionPointHighlighter.HighlighterProvider {
    @NotNull
    private final XSourcePosition myBasePosition;
    @Nullable
    private final TextRange myHighlightRange;
    @Nullable
    private final RubySuspensionLocation myLocation;

    public RubySourcePosition(@NotNull XSourcePosition basePosition, @Nullable RubySuspensionLocation location, @NotNull Project project) {
        if (basePosition == null) {
            RubySourcePosition.$$$reportNull$$$0(0);
        }
        if (project == null) {
            RubySourcePosition.$$$reportNull$$$0(1);
        }
        this.myLocation = location;
        this.myBasePosition = basePosition;
        if (location == null) {
            this.myHighlightRange = null;
            return;
        }
        this.myHighlightRange = new RubyLocationMapper(this.getLine(), this.getFile(), project).getLocationTextRange(location);
    }

    @Nullable
    public RubySuspensionLocation getLocation() {
        return this.myLocation;
    }

    @Contract(value="null,_,_ -> null; !null,_,_ -> !null")
    @Nullable
    public static RubySourcePosition createPosition(@Nullable XSourcePosition basePosition, @Nullable RubySuspensionLocation location, @NotNull Project project) {
        if (project == null) {
            RubySourcePosition.$$$reportNull$$$0(2);
        }
        return basePosition == null ? null : new RubySourcePosition(basePosition, location, project);
    }

    public int getLine() {
        return this.myBasePosition.getLine();
    }

    public int getOffset() {
        return this.myBasePosition.getOffset();
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myBasePosition.getFile();
        if (virtualFile == null) {
            RubySourcePosition.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @NotNull
    public Navigatable createNavigatable(@NotNull Project project) {
        if (project == null) {
            RubySourcePosition.$$$reportNull$$$0(4);
        }
        Navigatable navigatable = XDebuggerUtilImpl.createNavigatable((Project)project, (XSourcePosition)this);
        if (navigatable == null) {
            RubySourcePosition.$$$reportNull$$$0(5);
        }
        return navigatable;
    }

    @Nullable
    public TextRange getHighlightRange() {
        return this.myHighlightRange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RubySourcePosition)) {
            return false;
        }
        RubySourcePosition position = (RubySourcePosition)o;
        if (!this.myBasePosition.equals((Object)position.myBasePosition)) {
            return false;
        }
        if (!Objects.equals(this.myHighlightRange, position.myHighlightRange)) {
            return false;
        }
        return Objects.equals(this.myLocation, position.myLocation);
    }

    public int hashCode() {
        int result = this.myBasePosition.hashCode();
        result = 31 * result + (this.myHighlightRange != null ? this.myHighlightRange.hashCode() : 0);
        result = 31 * result + (this.myLocation != null ? this.myLocation.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "RubySourcePosition{myBasePosition=" + String.valueOf(this.myBasePosition) + ", myHighlightRange=" + String.valueOf(this.myHighlightRange) + ", myLocation=" + String.valueOf(this.myLocation) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePosition";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubySourcePosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubySourcePosition";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createNavigatable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPosition";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNavigatable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }
}

