/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ControlFlowHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RControlFlow;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubySmartStepIntoVariant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RExpressionSubstitution;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.impl.RControlFlowBuilderService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RUnaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RDotReferenceImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBraceBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBraceCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.controlStructures.RLambda;
import org.rubyforge.debugcommons.model.RubyStepVariant;
import org.rubyforge.debugcommons.model.RubySuspensionLocation;

public class RubyLocationMapper {
    private static final Logger LOG = Logger.getInstance(RubyLocationMapper.class);
    @NotNull
    private static final String GO_IN_BLOCK_SYMBOL = "!";
    private final int myZeroBazedLineNumber;
    @NotNull
    private final VirtualFile myVirtualFile;
    @NotNull
    private final Project myProject;
    @Nullable
    private final List<PsiElement> myLineElements;

    public RubyLocationMapper(int zeroBasedLineNumber, @NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            RubyLocationMapper.$$$reportNull$$$0(0);
        }
        if (project == null) {
            RubyLocationMapper.$$$reportNull$$$0(1);
        }
        this.myZeroBazedLineNumber = zeroBasedLineNumber;
        this.myVirtualFile = file;
        this.myProject = project;
        this.myLineElements = this.getLineElements();
    }

    @Nullable
    public List<PsiElement> getElementsByControlFlowHolder(@NotNull ControlFlowHolder holder) {
        Document document;
        if (holder == null) {
            RubyLocationMapper.$$$reportNull$$$0(2);
        }
        if ((document = FileDocumentManager.getInstance().getDocument(this.myVirtualFile)) == null) {
            return null;
        }
        RControlFlow flow = RControlFlowBuilderService.instance().buildControlFlow(holder);
        return Arrays.stream(flow.getInstructions()).map(Instruction::getElement).filter(Objects::nonNull).filter(psi -> document.getLineNumber(psi.getTextRange().getStartOffset()) == this.myZeroBazedLineNumber || document.getLineNumber(psi.getTextRange().getEndOffset()) == this.myZeroBazedLineNumber).collect(Collectors.toList());
    }

    @Nullable
    public ControlFlowHolder getControlFlowHolder() {
        PsiElement end;
        PsiElement context;
        PsiElement skipWhitespacesElement;
        if (this.myZeroBazedLineNumber < 0) {
            return null;
        }
        PsiFile file = RubyLocationMapper.getPsiFile(this.myVirtualFile, this.myProject);
        Document document = FileDocumentManager.getInstance().getDocument(this.myVirtualFile);
        if (document == null || file == null) {
            return null;
        }
        if (this.myZeroBazedLineNumber >= document.getLineCount()) {
            return null;
        }
        PsiElement start = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)document.getLineStartOffset(this.myZeroBazedLineNumber));
        if (RubySpaceUtil.isAnySpace((PsiElement)start) && (skipWhitespacesElement = PsiTreeUtil.nextVisibleLeaf((PsiElement)start)) != null) {
            start = skipWhitespacesElement;
        }
        if (!((context = PsiTreeUtil.findCommonParent((PsiElement)start, (PsiElement)(end = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)document.getLineEndOffset(this.myZeroBazedLineNumber))))) instanceof ControlFlowHolder)) {
            context = PsiTreeUtil.getParentOfType((PsiElement)context, ControlFlowHolder.class);
        }
        return (ControlFlowHolder)context;
    }

    @Nullable
    private List<PsiElement> getLineElements() {
        ControlFlowHolder holder = this.getControlFlowHolder();
        if (holder == null) {
            return null;
        }
        return this.getElementsByControlFlowHolder(holder);
    }

    public static PsiElement getCommandNameRecursively(RPossibleCall call) {
        PsiElement next;
        PsiElement rootPsiCommand;
        PsiElement command = rootPsiCommand = call.getPsiCommand();
        while (command instanceof RPossibleCall && (next = ((RPossibleCall)command).getPsiCommand()) != command) {
            command = next;
        }
        return (PsiElement)ObjectUtils.chooseNotNull((Object)command, (Object)rootPsiCommand);
    }

    private static boolean compareElementAndMethodIdentifier(@NotNull PsiElement element, @NotNull String methodIdentifier) {
        RPossibleCall rPossibleCall;
        PsiElement rPossibleCallElement;
        if (element == null) {
            RubyLocationMapper.$$$reportNull$$$0(3);
        }
        if (methodIdentifier == null) {
            RubyLocationMapper.$$$reportNull$$$0(4);
        }
        if (element instanceof RDotReferenceImpl && element.getParent() instanceof RCall && !(element.getParent() instanceof RArrayIndexing) && !((RCall)element.getParent()).getArguments().isEmpty()) {
            return false;
        }
        if (element instanceof RLambda && "lambda".equals(methodIdentifier)) {
            return true;
        }
        if (element instanceof RUnaryExpression && ((RUnaryExpression)element).getOperationName().equals(methodIdentifier)) {
            return true;
        }
        if (element instanceof RBraceBlockCall) {
            return false;
        }
        if (element.getParent().getParent() instanceof RExpressionSubstitution && "to_s".equals(methodIdentifier)) {
            return true;
        }
        if (element instanceof RAssignmentExpression && "[]=".equals(methodIdentifier)) {
            return true;
        }
        return element instanceof RPossibleCall && (rPossibleCallElement = RubyLocationMapper.getCommandNameRecursively(rPossibleCall = (RPossibleCall)element)) != null && rPossibleCallElement.getText().equals(methodIdentifier);
    }

    @Nullable
    private Pair<List<PsiElement>, Integer> getLocationIndexInControlFlow(@NotNull List<String> locationMethods, @NotNull List<PsiElement> elements, @NotNull Integer locationIndex) {
        if (locationMethods == null) {
            RubyLocationMapper.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            RubyLocationMapper.$$$reportNull$$$0(6);
        }
        if (locationIndex == null) {
            RubyLocationMapper.$$$reportNull$$$0(7);
        }
        if (locationIndex >= locationMethods.size()) {
            return null;
        }
        int elementIndex = 0;
        for (PsiElement element : elements) {
            String variantMid;
            if (RubyLocationMapper.compareElementAndMethodIdentifier(element, variantMid = locationMethods.get(locationIndex))) {
                List<PsiElement> blockElements;
                RCodeBlock rCodeBlock;
                Integer n = locationIndex;
                locationIndex = locationIndex + 1;
                if (locationIndex >= locationMethods.size()) {
                    return new Pair(elements, (Object)elementIndex);
                }
                variantMid = locationMethods.get(locationIndex);
                if (GO_IN_BLOCK_SYMBOL.equals(variantMid) && (rCodeBlock = RubyLocationMapper.getChildCodeBlock(element)) != null && (blockElements = this.getElementsByControlFlowHolder((ControlFlowHolder)rCodeBlock)) != null) {
                    return this.getLocationIndexInControlFlow(locationMethods, blockElements, locationIndex + 1);
                }
            }
            ++elementIndex;
        }
        return null;
    }

    @Nullable
    private static RCodeBlock getChildCodeBlock(@NotNull PsiElement element) {
        PsiElement parentElement;
        if (element == null) {
            RubyLocationMapper.$$$reportNull$$$0(8);
        }
        if ((parentElement = element.getParent()) instanceof RBlockCall) {
            return ((RBlockCall)parentElement).getBlock();
        }
        if (element instanceof RLambda) {
            return ((RLambda)element).getBody();
        }
        if (parentElement instanceof RCall && parentElement.getParent() instanceof RBlockCall) {
            return ((RBlockCall)parentElement.getParent()).getBlock();
        }
        return null;
    }

    @Nullable
    public TextRange getLocationTextRange(@Nullable RubySuspensionLocation location) {
        if (location == null || this.myLineElements == null) {
            return null;
        }
        Pair<List<PsiElement>, Integer> baseLocation = this.getLocationIndexInControlFlow(location.getLocationMethods(), this.myLineElements, 0);
        if (baseLocation == null) {
            LOG.warn("Base location not found for " + String.valueOf(location));
            return null;
        }
        PsiElement element = (PsiElement)((List)baseLocation.first).get((Integer)baseLocation.second);
        RBraceBlockCall rBraceBlockCall = (RBraceBlockCall)PsiTreeUtil.getParentOfType((PsiElement)element, RBraceBlockCall.class);
        RCodeBlock rBraceCodeBlock = rBraceBlockCall != null ? rBraceBlockCall.getBlock() : (RCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)element, RBraceCodeBlock.class);
        if (rBraceCodeBlock != null) {
            if (location.getType() == RubySuspensionLocation.Type.BLOCK) {
                return rBraceCodeBlock.getCompoundStatement().getTextRange();
            }
            if (location.getType() == RubySuspensionLocation.Type.LEAVE) {
                return PsiTreeUtil.getDeepestLast((PsiElement)rBraceCodeBlock).getTextRange();
            }
        }
        if (element instanceof RUnaryExpression) {
            return element.getFirstChild().getTextRange();
        }
        if (element.getParent().getParent() instanceof RExpressionSubstitution) {
            return element.getParent().getTextRange();
        }
        if (element instanceof RLambda) {
            RBraceCodeBlock lambdaBody = ((RLambda)element).getBody();
            return lambdaBody == null ? element.getTextRange() : lambdaBody.getTextRange();
        }
        if (!(element instanceof RPossibleCall)) {
            LOG.warn("Got " + String.valueOf(element) + " instead of RPossibleCall");
            return element.getTextRange();
        }
        RPossibleCall call = (RPossibleCall)element;
        PsiElement psiCommand = RubyLocationMapper.getCommandNameRecursively(call);
        if (psiCommand == null) {
            LOG.warn("Psi command was null for " + String.valueOf(call));
            return call.getTextRange();
        }
        return psiCommand.getTextRange();
    }

    @Nullable
    public List<RubySmartStepIntoVariant> getStepVariantsElements(@Nullable RubySuspensionLocation baseLocation, @NotNull List<RubyStepVariant> variants) {
        PsiElement element;
        Pair<List<PsiElement>, Integer> base;
        if (variants == null) {
            RubyLocationMapper.$$$reportNull$$$0(9);
        }
        if (this.myLineElements == null || variants.isEmpty()) {
            return null;
        }
        List<PsiElement> elements = this.myLineElements;
        int index = 0;
        int variantIndex = 0;
        if (baseLocation != null && (base = this.getLocationIndexInControlFlow(baseLocation.getLocationMethods(), this.myLineElements, 0)) != null) {
            element = (PsiElement)((List)base.first).get((Integer)base.second);
            if (baseLocation.getType() == RubySuspensionLocation.Type.BLOCK && element.getParent() instanceof RBlockCall) {
                elements = this.getElementsByControlFlowHolder((ControlFlowHolder)((RBlockCall)element.getParent()).getBlock());
                index = 0;
            } else {
                elements = (List<PsiElement>)base.first;
                index = (Integer)base.second;
            }
        }
        if (elements == null) {
            return null;
        }
        LinkedList<RubySmartStepIntoVariant> answer = new LinkedList<RubySmartStepIntoVariant>();
        while (index < elements.size()) {
            element = elements.get(index);
            if (variantIndex >= variants.size()) break;
            RubyStepVariant variant = variants.get(variantIndex);
            if (RubyLocationMapper.compareElementAndMethodIdentifier(element, variant.getText()) && variant.getType() == RubySuspensionLocation.Type.METHOD) {
                PsiElement methodPsi = null;
                if (element instanceof RPossibleCall) {
                    methodPsi = RubyLocationMapper.getCommandNameRecursively((RPossibleCall)element);
                }
                if (element instanceof RUnaryExpression) {
                    methodPsi = element.getFirstChild();
                }
                if (methodPsi != null) {
                    answer.add(new RubySmartStepIntoVariant(variant, methodPsi));
                    RBlockCall blockCall = element.getParent() instanceof RBlockCall ? (RBlockCall)element.getParent() : RBlockCallNavigator.getByCall((RPsiElement)((RPsiElement)element.getParent()));
                    if (++variantIndex < variants.size() && variants.get(variantIndex).getType() == RubySuspensionLocation.Type.BLOCK && blockCall != null) {
                        RCodeBlock blockPsi = blockCall.getBlock();
                        answer.add(new RubySmartStepIntoVariant(variants.get(variantIndex), (PsiElement)blockPsi));
                        ++variantIndex;
                    }
                }
            }
            ++index;
        }
        return answer;
    }

    @RequiresReadLock
    @Nullable
    private static PsiFile getPsiFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            RubyLocationMapper.$$$reportNull$$$0(10);
        }
        if (project == null) {
            RubyLocationMapper.$$$reportNull$$$0(11);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (file.isValid()) {
            return PsiManager.getInstance((Project)project).findFile(file);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodIdentifier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationMethods";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationIndex";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyLocationMapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementsByControlFlowHolder";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "compareElementAndMethodIdentifier";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getLocationIndexInControlFlow";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildCodeBlock";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getStepVariantsElements";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

