/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.debugger.breakpoints.RubyLineBreakpointProperties;
import org.jetbrains.plugins.ruby.ruby.debugger.breakpoints.RubyLineBreakpointType;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.MyIRubyBlockBreakpoint;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.MyIRubyLineBreakpoint;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebugProcess;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyPosition;
import org.rubyforge.debugcommons.model.IRubyBreakpoint;

public class RubyLineBreakpointHandler
extends XBreakpointHandler<XLineBreakpoint<RubyLineBreakpointProperties>> {
    final HashMap<XLineBreakpoint<RubyLineBreakpointProperties>, MyIRubyLineBreakpoint> mySource2BreakpointMap;
    final HashMap<RubyPosition, XLineBreakpoint<RubyLineBreakpointProperties>> mySourceAndXBreakpointMap;
    protected RubyDebugProcess myDebugProcess;

    public RubyLineBreakpointHandler(@NotNull RubyDebugProcess debugProcess) {
        if (debugProcess == null) {
            RubyLineBreakpointHandler.$$$reportNull$$$0(0);
        }
        super(RubyLineBreakpointType.class);
        this.mySource2BreakpointMap = new HashMap();
        this.mySourceAndXBreakpointMap = new HashMap();
        this.myDebugProcess = debugProcess;
    }

    private static MyIRubyLineBreakpoint createBreakpoint(@NotNull RubyPosition position, @Nullable String condition, @NotNull RubyLineBreakpointProperties properties) {
        Integer blockOrdinal;
        if (position == null) {
            RubyLineBreakpointHandler.$$$reportNull$$$0(1);
        }
        if (properties == null) {
            RubyLineBreakpointHandler.$$$reportNull$$$0(2);
        }
        if ((blockOrdinal = properties.getBlockOrdinal()) != null && blockOrdinal >= 0) {
            return new MyIRubyBlockBreakpoint(position, condition, blockOrdinal, false);
        }
        if (blockOrdinal == null) {
            return new MyIRubyLineBreakpoint(position, condition, true);
        }
        return new MyIRubyLineBreakpoint(position, condition, false);
    }

    public void registerBreakpoint(@NotNull XLineBreakpoint<RubyLineBreakpointProperties> xBreakpoint) {
        XSourcePosition position;
        if (xBreakpoint == null) {
            RubyLineBreakpointHandler.$$$reportNull$$$0(3);
        }
        if ((position = xBreakpoint.getSourcePosition()) != null) {
            RubyPosition rubyBreakpointPosition = this.myDebugProcess.getPositionConverter().createRemotePosition(position);
            MyIRubyLineBreakpoint rBreakpoint = this.mySource2BreakpointMap.get(xBreakpoint);
            if (rBreakpoint == null) {
                rBreakpoint = RubyLineBreakpointHandler.createBreakpoint(rubyBreakpointPosition, RubyLineBreakpointHandler.getExpression(xBreakpoint), (RubyLineBreakpointProperties)xBreakpoint.getProperties());
            } else {
                rBreakpoint.setEnabled(true);
            }
            this.addBreakPoint(rubyBreakpointPosition, xBreakpoint, rBreakpoint);
            this.myDebugProcess.addBreakPoint((IRubyBreakpoint)rBreakpoint);
        }
    }

    @Nullable
    private static String getExpression(@NotNull XLineBreakpoint<RubyLineBreakpointProperties> xBreakpoint) {
        XExpression expression;
        if (xBreakpoint == null) {
            RubyLineBreakpointHandler.$$$reportNull$$$0(4);
        }
        return (expression = xBreakpoint.getConditionExpression()) != null ? expression.getExpression() : null;
    }

    public void unregisterBreakpoint(@NotNull XLineBreakpoint<RubyLineBreakpointProperties> xBreakpoint, boolean temporary) {
        XSourcePosition position;
        if (xBreakpoint == null) {
            RubyLineBreakpointHandler.$$$reportNull$$$0(5);
        }
        if ((position = xBreakpoint.getSourcePosition()) != null) {
            RubyPosition rubyBreakpointPosition = this.myDebugProcess.getPositionConverter().createRemotePosition(position);
            MyIRubyLineBreakpoint rBreakpoint = this.mySource2BreakpointMap.get(xBreakpoint);
            if (rBreakpoint != null) {
                this.myDebugProcess.removeBreakPoint((IRubyBreakpoint)rBreakpoint);
            }
            if (!temporary) {
                this.removeXBreakPoint(xBreakpoint, rubyBreakpointPosition);
            }
        }
    }

    protected void removeXBreakPoint(XLineBreakpoint<RubyLineBreakpointProperties> xBreakpoint, RubyPosition rubyBreakpointPosition) {
        this.mySource2BreakpointMap.remove(xBreakpoint);
        this.mySourceAndXBreakpointMap.remove(rubyBreakpointPosition);
    }

    protected void addBreakPoint(RubyPosition rubyBreakpointPosition, XLineBreakpoint<RubyLineBreakpointProperties> xBreakpoint, MyIRubyLineBreakpoint rBreakpoint) {
        this.mySource2BreakpointMap.put(xBreakpoint, rBreakpoint);
        this.mySourceAndXBreakpointMap.put(rubyBreakpointPosition, xBreakpoint);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xBreakpoint";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyLineBreakpointHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createBreakpoint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "registerBreakpoint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterBreakpoint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

