/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebugProcess;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyStackFrame;
import org.rubyforge.debugcommons.RubyDebugEvent;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.RubyThread;
import org.rubyforge.debugcommons.model.UnableToStepSuspensionPoint;

public class RubyExecutionStack
extends XExecutionStack {
    private static final Logger LOG = Logger.getInstance(RubyExecutionStack.class);
    private final AtomicNotNullLazyValue<Pair<RubyStackFrame, List<RubyStackFrame>>> myDataProvider;
    @NotNull
    private final RubyThread myRubyThread;
    @NotNull
    private final RubyDebugEvent myDebugEvent;

    public RubyExecutionStack(Project project, @NotNull RubyDebugProcess rubyDebugProcess, @NotNull RubyDebuggerProxy debuggerProxy, @NotNull RubyThread rubyThread, @NotNull RubyDebugEvent debugEvent) {
        if (rubyDebugProcess == null) {
            RubyExecutionStack.$$$reportNull$$$0(0);
        }
        if (debuggerProxy == null) {
            RubyExecutionStack.$$$reportNull$$$0(1);
        }
        if (rubyThread == null) {
            RubyExecutionStack.$$$reportNull$$$0(2);
        }
        if (debugEvent == null) {
            RubyExecutionStack.$$$reportNull$$$0(3);
        }
        super(RubyExecutionStack.getDisplayName(rubyThread), rubyThread.isSuspended() ? AllIcons.Debugger.ThreadAtBreakpoint : AllIcons.Debugger.ThreadSuspended);
        this.myDebugEvent = debugEvent;
        this.myRubyThread = rubyThread;
        this.myDataProvider = AtomicNotNullLazyValue.createValue(() -> {
            String threadName = Thread.currentThread().getName();
            RubyStackFrame topFrame = null;
            List frames = Collections.emptyList();
            LOG.debug("Computing RubyExecution stack for ", new Object[]{rubyThread, " at ", threadName});
            if (!debuggerProxy.waitForDebuggerProxyReady()) {
                LOG.warn("Couldn't evaluate execution stack during timeout");
            } else if (this.myDebugEvent.getOrigin().isPaused() && rubyThread.supportsFrameReading()) {
                frames = new ArrayList();
                try {
                    RubyFrame[] rubyFrames = rubyThread.getFrames();
                    RubyFrame topRubyFrame = rubyThread.getTopFrame();
                    for (RubyFrame rubyFrame : rubyFrames) {
                        RubyStackFrame frame = new RubyStackFrame(project, rubyDebugProcess, debuggerProxy, rubyFrame);
                        frames.add(frame);
                        if (topRubyFrame != rubyFrame) continue;
                        topFrame = frame;
                    }
                    if (topFrame != null) {
                        topFrame.myIsUnableToStepSuspensionStack = this.myDebugEvent.getSuspensionPoint() instanceof UnableToStepSuspensionPoint;
                    }
                }
                catch (RubyDebuggerException e) {
                    LOG.warn("Error listing frames for " + String.valueOf(rubyThread), (Throwable)e);
                }
            } else {
                RubyDebuggerProxy eventProxy = this.myDebugEvent.getOrigin();
                LOG.debug("We cannot load stack frames from processes that are not paused (or at all). rubyThread=", new Object[]{rubyThread, ", isPaused=", eventProxy.isPaused(), ", supportsFrameReading=", rubyThread.supportsFrameReading(), ", eventProxy=", eventProxy, " at ", threadName});
            }
            Pair result = Pair.create(topFrame, frames);
            LOG.debug("Computed frames for ", new Object[]{rubyThread, " as ", result, " on ", threadName});
            return result;
        });
    }

    @NlsContexts.ListItem
    private static String getDisplayName(@NotNull RubyThread rubyThread) {
        int pid;
        if (rubyThread == null) {
            RubyExecutionStack.$$$reportNull$$$0(4);
        }
        @NlsSafe Object pidTinfo = (pid = rubyThread.getPid()) != -1 ? " (pid " + pid + ")" : "";
        return RBundle.message((String)"list.item.thread.id.status.process.info", (Object[])new Object[]{rubyThread.getId(), rubyThread.getStatus(), pidTinfo});
    }

    public XStackFrame getTopFrame() {
        return (XStackFrame)((Pair)this.myDataProvider.getValue()).getFirst();
    }

    public void computeStackFrames(int frameCount, XExecutionStack.XStackFrameContainer container) {
        List framesData = (List)((Pair)this.myDataProvider.getValue()).getSecond();
        if (frameCount <= framesData.size()) {
            List<RubyStackFrame> frames = framesData.subList(frameCount, framesData.size());
            if (!XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowLibraryStackFrames()) {
                boolean isNeedToKeepFirstFrame = frameCount == 0;
                container.addStackFrames(RubyExecutionStack.getFilteredStackFrames(frames, isNeedToKeepFirstFrame), true);
                return;
            }
            container.addStackFrames(frames, true);
        } else {
            container.errorOccurred(RBundle.message((String)"ruby.debugger.no.stack.frames.available"));
        }
    }

    public boolean equals(Object other) {
        return other instanceof RubyExecutionStack && this.getDisplayName().equals(((RubyExecutionStack)((Object)other)).getDisplayName());
    }

    public int hashCode() {
        return this.getDisplayName().hashCode();
    }

    public String toString() {
        return "RubyExecutionStack{myRubyThread=" + String.valueOf(this.myRubyThread) + ", myDebugEvent=" + String.valueOf(this.myDebugEvent) + ", myDataProvider.computed=" + this.myDataProvider.isComputed() + "} ";
    }

    @NotNull
    private static List<RubyStackFrame> getFilteredStackFrames(@NotNull List<RubyStackFrame> stackFrames, boolean needToKeepFirstFrame) {
        if (stackFrames == null) {
            RubyExecutionStack.$$$reportNull$$$0(5);
        }
        if (stackFrames.isEmpty()) {
            List<RubyStackFrame> list = Collections.emptyList();
            if (list == null) {
                RubyExecutionStack.$$$reportNull$$$0(6);
            }
            return list;
        }
        ArrayList<RubyStackFrame> filteredStackFrames = new ArrayList<RubyStackFrame>();
        if (needToKeepFirstFrame) {
            filteredStackFrames.add(stackFrames.get(0));
        }
        int numberFramesToSkip = needToKeepFirstFrame ? 1 : 0;
        List<RubyStackFrame> tailFrames = stackFrames.stream().skip(numberFramesToSkip).filter(f -> f.isInProjectFrame()).toList();
        filteredStackFrames.addAll(tailFrames);
        ArrayList<RubyStackFrame> arrayList = filteredStackFrames;
        if (arrayList == null) {
            RubyExecutionStack.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyDebugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerProxy";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyThread";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugEvent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrames";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyExecutionStack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyExecutionStack";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredStackFrames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredStackFrames";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

