/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.debugger.breakpoints.RubyExceptionBreakpointProperties;
import org.jetbrains.plugins.ruby.ruby.debugger.breakpoints.RubyExceptionBreakpointType;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.MyIRubyExceptionBreakpoint;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebugProcess;
import org.rubyforge.debugcommons.RubyDebugEvent;
import org.rubyforge.debugcommons.model.ExceptionSuspensionPoint;
import org.rubyforge.debugcommons.model.IRubyBreakpoint;
import org.rubyforge.debugcommons.model.SuspensionPoint;

public class RubyExceptionBreakpointHandler
extends XBreakpointHandler<XBreakpoint<RubyExceptionBreakpointProperties>> {
    final HashMap<String, MyIRubyExceptionBreakpoint> myName2BreakpointMap;
    final HashMap<String, XBreakpoint<RubyExceptionBreakpointProperties>> myName2XBreakpointMap;
    protected RubyDebugProcess myDebugProcess;

    public RubyExceptionBreakpointHandler(@NotNull RubyDebugProcess debugProcess) {
        if (debugProcess == null) {
            RubyExceptionBreakpointHandler.$$$reportNull$$$0(0);
        }
        super(RubyExceptionBreakpointType.class);
        this.myName2BreakpointMap = new HashMap();
        this.myName2XBreakpointMap = new HashMap();
        this.myDebugProcess = debugProcess;
    }

    public void registerBreakpoint(@NotNull XBreakpoint<RubyExceptionBreakpointProperties> xBreakpoint) {
        if (xBreakpoint == null) {
            RubyExceptionBreakpointHandler.$$$reportNull$$$0(1);
        }
        RubyExceptionBreakpointProperties breakpointProperties = (RubyExceptionBreakpointProperties)xBreakpoint.getProperties();
        assert (breakpointProperties != null) : "properties cannot be null";
        String exception = breakpointProperties.myException;
        assert (exception != null) : "exception name cannot be null";
        MyIRubyExceptionBreakpoint rBreakpoint = this.myName2BreakpointMap.get(exception);
        if (rBreakpoint == null) {
            rBreakpoint = new MyIRubyExceptionBreakpoint(exception);
        }
        this.addBreakPoint(exception, rBreakpoint, xBreakpoint);
        this.myDebugProcess.addBreakPoint((IRubyBreakpoint)rBreakpoint);
    }

    public void unregisterBreakpoint(@NotNull XBreakpoint<RubyExceptionBreakpointProperties> xBreakpoint, boolean temporary) {
        if (xBreakpoint == null) {
            RubyExceptionBreakpointHandler.$$$reportNull$$$0(2);
        }
        RubyExceptionBreakpointProperties breakpointProperties = (RubyExceptionBreakpointProperties)xBreakpoint.getProperties();
        assert (breakpointProperties != null) : "properties cannot be null";
        String exception = breakpointProperties.myException;
        MyIRubyExceptionBreakpoint rBreakpoint = this.myName2BreakpointMap.get(exception);
        if (rBreakpoint != null) {
            this.myDebugProcess.removeBreakPoint((IRubyBreakpoint)rBreakpoint);
        }
        if (!temporary) {
            this.removeBreakPoint(exception);
        }
    }

    protected void removeBreakPoint(String exception) {
        this.myName2BreakpointMap.remove(exception);
        this.myName2XBreakpointMap.remove(exception);
    }

    protected void addBreakPoint(String exception, MyIRubyExceptionBreakpoint rBreakpoint, XBreakpoint<RubyExceptionBreakpointProperties> xBreakpoint) {
        this.myName2BreakpointMap.put(exception, rBreakpoint);
        this.myName2XBreakpointMap.put(exception, xBreakpoint);
    }

    @Nullable
    XBreakpoint<RubyExceptionBreakpointProperties> findExceptionBreakpoint(RubyDebugEvent event) {
        SuspensionPoint point = event.getSuspensionPoint();
        return point instanceof ExceptionSuspensionPoint ? this.myName2XBreakpointMap.get(((ExceptionSuspensionPoint)point).getExceptionType()) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xBreakpoint";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyExceptionBreakpointHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerBreakpoint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterBreakpoint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

