/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebuggerSupportUtils;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyStackFrame;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubySuspendContext;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyDebugValueFactory;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypesCore;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.ExpressionInfo;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.RubyFullValue;
import org.rubyforge.debugcommons.model.RubyVariable;

public class RubyDebuggerEvaluator
extends XDebuggerEvaluator {
    private final Project myProject;
    protected RubyStackFrame myFrame;
    private final RubyDebuggerProxy myDebuggerProxy;
    private static final Logger LOG = Logger.getInstance(RubyDebuggerEvaluator.class);

    public RubyDebuggerEvaluator(Project project, @NotNull RubyStackFrame frame, RubyDebuggerProxy debuggerProxy) {
        if (frame == null) {
            RubyDebuggerEvaluator.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myFrame = frame;
        this.myDebuggerProxy = debuggerProxy;
    }

    public static boolean evaluateCondition(RubySuspendContext rubySuspendContext, @Nullable XExpression condition) {
        XStackFrame topFrame;
        if (condition == null || StringUtil.isEmptyOrSpaces((String)condition.getExpression())) {
            return true;
        }
        XExecutionStack activeExecutionStack = rubySuspendContext.getActiveExecutionStack();
        if (activeExecutionStack != null && (topFrame = activeExecutionStack.getTopFrame()) != null) {
            try {
                RubyVariable rubyVariable = ((RubyStackFrame)topFrame).getRubyFrame().inspectExpression(condition.getExpression());
                if (rubyVariable == null) {
                    return false;
                }
                String s = RubyDebuggerSupportUtils.getRubyValuePresentationString(rubyVariable.getValue());
                return !RubyTokenTypesCore.kFALSE.toString().equals(s) && !RubyTokenTypesCore.kNIL.toString().equals(s);
            }
            catch (RubyDebuggerException e) {
                LOG.info((Throwable)e);
            }
        }
        return true;
    }

    @NotNull
    public static String evaluateExpression(@NotNull RubySuspendContext rubySuspendContext, @Nullable String expression) {
        XStackFrame topFrame;
        XExecutionStack activeExecutionStack;
        if (rubySuspendContext == null) {
            RubyDebuggerEvaluator.$$$reportNull$$$0(1);
        }
        if ((activeExecutionStack = rubySuspendContext.getActiveExecutionStack()) != null && (topFrame = activeExecutionStack.getTopFrame()) != null) {
            String result = RubyDebuggerEvaluator.evaluateExpression(topFrame, expression);
            return result != null ? result : "";
        }
        return "";
    }

    @Nullable
    public static String evaluateExpression(@NotNull XStackFrame frame, @Nullable String expression) {
        if (frame == null) {
            RubyDebuggerEvaluator.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmptyOrSpaces((String)expression)) {
            return null;
        }
        RubyFrame rubyFrame = ((RubyStackFrame)frame).getRubyFrame();
        RubyDebuggerProxy debuggerProxy = rubyFrame.getProxy();
        String escapedExpression = RubyDebuggerProxy.escapeNewlinesForDebugger((String)expression);
        try {
            if (debuggerProxy.isSupportsLoadingFullValue()) {
                RubyFullValue rubyFullValue = ((RubyStackFrame)frame).getRubyFrame().loadFullValue(escapedExpression, true);
                return rubyFullValue.getFullValue();
            }
            String adjustedExpression = "(" + expression + ").inspect";
            RubyVariable rubyVariable = ((RubyStackFrame)frame).getRubyFrame().inspectExpression(adjustedExpression);
            if (rubyVariable == null) {
                return null;
            }
            return rubyVariable.getValue().getValueString();
        }
        catch (RubyDebuggerException e) {
            LOG.info("Exception while evaluating expression: " + expression, (Throwable)e);
            return null;
        }
    }

    public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            RubyDebuggerEvaluator.$$$reportNull$$$0(3);
        }
        if (callback == null) {
            RubyDebuggerEvaluator.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().executeOnPooledThread(ClientId.decorateRunnable(() -> {
            if (!this.myDebuggerProxy.waitForDebuggerProxyReady()) {
                callback.errorOccurred(RBundle.message((String)"ruby.debugger.is.not.ready"));
                return;
            }
            try {
                RubyVariable rubyVariable = this.myDebuggerProxy.inspectExpression(this.myFrame.getRubyFrame(), expression);
                if (rubyVariable == null) {
                    callback.errorOccurred(RBundle.message((String)"ruby.debugger.could.not.evaluate", (Object[])new Object[]{expression}));
                    return;
                }
                callback.evaluated((XValue)RubyDebugValueFactory.create(this.myProject, expressionPosition, this.myFrame, null, expression, rubyVariable));
                RubyDebuggerSupportUtils.invalidateSessionFrames(XDebuggerManager.getInstance((Project)this.myProject).getCurrentSession());
            }
            catch (RubyDebuggerException e) {
                LOG.info((Throwable)e);
                String builder2 = RBundle.message((String)"ruby.debugger.could.not.evaluate", (Object[])new Object[]{expression}) + "\n" + e.getMessage();
                callback.errorOccurred(builder2);
            }
        }));
    }

    @Nullable
    public ExpressionInfo getExpressionInfo(@NotNull String expression) {
        if (expression == null) {
            RubyDebuggerEvaluator.$$$reportNull$$$0(5);
        }
        if (!this.myDebuggerProxy.waitForDebuggerProxyReady()) {
            return null;
        }
        try {
            return this.myDebuggerProxy.getExpressionInfo(this.myFrame.getRubyFrame(), expression);
        }
        catch (RubyDebuggerException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    public TextRange getExpressionRangeAtOffset(Project project, Document document, int offset, boolean sideEffectsAllowed) {
        return RubyDebuggerSupportUtils.getExpressionAtOffset(project, document, offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubySuspendContext";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyDebuggerEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateExpression";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpressionInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

