/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathMappingSettings;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.debugger.SourcePositionConverter;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyPosition;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubySourcePosition;
import org.rubyforge.debugcommons.model.RubySuspensionLocation;

public class RemotePositionConverter
implements SourcePositionConverter {
    private final PathMappingSettings myMappingSettings;
    @NotNull
    private final Project myProject;

    public RemotePositionConverter(@NotNull Project project, String localRoot, String remoteRoot, @Nullable PathMappingSettings gemsMappings) {
        if (project == null) {
            RemotePositionConverter.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myMappingSettings = new PathMappingSettings();
        this.myMappingSettings.addMapping(FileUtil.toSystemIndependentName((String)localRoot), FileUtil.toSystemIndependentName((String)remoteRoot));
        if (gemsMappings != null) {
            this.myMappingSettings.addAll(gemsMappings);
        }
    }

    public RemotePositionConverter(@NotNull Project project, @NotNull PathMappingSettings mappingSettings) {
        if (project == null) {
            RemotePositionConverter.$$$reportNull$$$0(1);
        }
        if (mappingSettings == null) {
            RemotePositionConverter.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myMappingSettings = new PathMappingSettings(mappingSettings.getPathMappings());
    }

    @Override
    @NotNull
    public RubyPosition createRemotePosition(@NotNull XSourcePosition xSourcePosition) {
        if (xSourcePosition == null) {
            RemotePositionConverter.$$$reportNull$$$0(3);
        }
        VirtualFile file = xSourcePosition.getFile();
        RubySuspensionLocation location = null;
        if (xSourcePosition instanceof RubySourcePosition) {
            location = ((RubySourcePosition)xSourcePosition).getLocation();
        }
        return new RubyPosition(this.getRemotePath(file), xSourcePosition.getLine() + 1, location);
    }

    @Override
    @NotNull
    public String getRemotePath(@NotNull VirtualFile file) {
        if (file == null) {
            RemotePositionConverter.$$$reportNull$$$0(4);
        }
        Object remotePath = this.myMappingSettings.convertToRemote(file.getPath());
        if (file.isDirectory() && !((String)remotePath).endsWith("/")) {
            remotePath = (String)remotePath + "/";
        }
        String string = remotePath;
        if (string == null) {
            RemotePositionConverter.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public XSourcePosition createLocalPosition(@NotNull RubyPosition rubyPosition) {
        if (rubyPosition == null) {
            RemotePositionConverter.$$$reportNull$$$0(6);
        }
        return (XSourcePosition)ReadAction.compute(() -> {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(this.myMappingSettings.convertToLocal(rubyPosition.getPath()));
            return RubySourcePosition.createPosition(XDebuggerUtil.getInstance().createPosition(file, rubyPosition.getLine() - 1), rubyPosition.getLocation(), this.myProject);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xSourcePosition";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RemotePositionConverter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RemotePositionConverter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemotePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createRemotePosition";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRemotePath";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createLocalPosition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

