/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import com.google.common.collect.Maps;
import com.intellij.execution.Platform;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import java.io.File;
import java.text.Normalizer;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.debugger.SourcePositionConverter;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyPosition;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubySourcePosition;
import org.rubyforge.debugcommons.model.RubySuspensionLocation;

public class LocalPositionConverter
implements SourcePositionConverter {
    private static final Logger LOG = Logger.getInstance(LocalPositionConverter.class);
    @NotNull
    private final Project myProject;
    private final boolean myUseCanonicalPaths;
    private final Map<String, String> myCanonicalPath2Path;

    public LocalPositionConverter(@NotNull Project project, boolean useCanonicalPaths) {
        if (project == null) {
            LocalPositionConverter.$$$reportNull$$$0(0);
        }
        this.myCanonicalPath2Path = Maps.newHashMap();
        this.myProject = project;
        this.myUseCanonicalPaths = useCanonicalPaths;
    }

    @Override
    @NotNull
    public RubyPosition createRemotePosition(@NotNull XSourcePosition xSourcePosition) {
        if (xSourcePosition == null) {
            LocalPositionConverter.$$$reportNull$$$0(1);
        }
        String path = this.getRemotePath(xSourcePosition.getFile());
        this.myCanonicalPath2Path.put(path, xSourcePosition.getFile().getPath());
        RubySuspensionLocation location = null;
        if (xSourcePosition instanceof RubySourcePosition) {
            location = ((RubySourcePosition)xSourcePosition).getLocation();
        }
        return new RubyPosition(path, xSourcePosition.getLine() + 1, location);
    }

    @Override
    @NotNull
    public String getRemotePath(@NotNull VirtualFile file) {
        if (file == null) {
            LocalPositionConverter.$$$reportNull$$$0(2);
        }
        Object path = null;
        if (this.myUseCanonicalPaths) {
            path = file.getCanonicalPath();
        }
        if (path == null) {
            path = file.getPath();
        }
        if (file.isDirectory() && ((String)path).charAt(((String)path).length() - 1) != Platform.current().fileSeparator) {
            path = (String)path + Platform.current().fileSeparator;
        }
        if (SystemInfo.isMac) {
            String string = Normalizer.normalize((CharSequence)path, Normalizer.Form.NFD);
            if (string == null) {
                LocalPositionConverter.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            LocalPositionConverter.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public XSourcePosition createLocalPosition(@NotNull RubyPosition rubyPosition) {
        if (rubyPosition == null) {
            LocalPositionConverter.$$$reportNull$$$0(5);
        }
        LOG.debug("Creating local position for ", new Object[]{rubyPosition, " on ", Thread.currentThread().getName()});
        String filePath = this.findPathByRubyPosition(rubyPosition.getPath());
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (virtualFile == null) {
            LOG.debug("Unable to find file without refresh: ", new Object[]{filePath});
            if (ApplicationManager.getApplication().isReadAccessAllowed() && LOG.isDebugEnabled()) {
                LOG.debug("Unable to refresh under read action", new Throwable());
            } else {
                virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath);
                if (virtualFile == null) {
                    LOG.debug("Could not find file with refresh: ", new Object[]{filePath, " java exists status: ", new File(filePath).exists()});
                }
            }
        }
        if (virtualFile != null) {
            LOG.debug("Found file: ", new Object[]{virtualFile});
        }
        VirtualFile finalFile = virtualFile;
        return (XSourcePosition)ReadAction.compute(() -> RubySourcePosition.createPosition(XDebuggerUtil.getInstance().createPosition(finalFile, rubyPosition.getLine() - 1), rubyPosition.getLocation(), this.myProject));
    }

    @NotNull
    private String findPathByRubyPosition(@NotNull String rubyPath) {
        if (rubyPath == null) {
            LocalPositionConverter.$$$reportNull$$$0(6);
        }
        if (this.myCanonicalPath2Path.containsKey(rubyPath)) {
            String string = this.myCanonicalPath2Path.get(rubyPath);
            if (string == null) {
                LocalPositionConverter.$$$reportNull$$$0(7);
            }
            return string;
        }
        String fileName = new File(rubyPath).getName();
        LOG.debug("Looking for \"", new Object[]{rubyPath, "\" in filename index by name: ", fileName});
        Collection files = (Collection)ReadAction.compute(() -> FilenameIndex.getVirtualFilesByName((String)fileName, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject)));
        for (VirtualFile file : files) {
            if (!rubyPath.equals(file.getCanonicalPath())) continue;
            this.myCanonicalPath2Path.put(rubyPath, file.getPath());
            String string = file.getPath();
            if (string == null) {
                LocalPositionConverter.$$$reportNull$$$0(8);
            }
            return string;
        }
        LOG.debug("Unable to find \"", new Object[]{rubyPath, "\" by name, returning as is"});
        String string = rubyPath;
        if (string == null) {
            LocalPositionConverter.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xSourcePosition";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/LocalPositionConverter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyPosition";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/LocalPositionConverter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemotePath";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findPathByRubyPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createRemotePosition";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRemotePath";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createLocalPosition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findPathByRubyPosition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

