/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.debugger.breakpoints.RubyExceptionBreakpointProperties;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyClassResolveUtil;
import org.jetbrains.plugins.ruby.ruby.ui.TreeRClassChooserDialog;

public final class RubyExceptionBreakpointType
extends XBreakpointType<XBreakpoint<RubyExceptionBreakpointProperties>, RubyExceptionBreakpointProperties> {
    public RubyExceptionBreakpointType() {
        super("ruby-exception", RBundle.message((String)"ruby.debugger.exception.breakpoint.title"));
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_exception_breakpoint;
        if (icon == null) {
            RubyExceptionBreakpointType.$$$reportNull$$$0(0);
        }
        return icon;
    }

    public String getDisplayText(XBreakpoint<RubyExceptionBreakpointProperties> breakpoint) {
        RubyExceptionBreakpointProperties breakpointProperties = (RubyExceptionBreakpointProperties)breakpoint.getProperties();
        assert (breakpointProperties != null) : "properties cannot be null";
        if (breakpointProperties.isDefaultBreakpoint()) {
            return RBundle.message((String)"ruby.debugger.exception.breakpoint.default.display.text");
        }
        return RBundle.message((String)"ruby.debugger.exception.breakpoint.display.text", (Object[])new Object[]{breakpointProperties.myException});
    }

    public RubyExceptionBreakpointProperties createProperties() {
        return new RubyExceptionBreakpointProperties("Exception");
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_exception_breakpoint;
        if (icon == null) {
            RubyExceptionBreakpointType.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        Icon icon = AllIcons.Debugger.Db_exception_breakpoint;
        if (icon == null) {
            RubyExceptionBreakpointType.$$$reportNull$$$0(2);
        }
        return icon;
    }

    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    public XBreakpoint<RubyExceptionBreakpointProperties> addBreakpoint(Project project, JComponent parentComponent) {
        TreeRClassChooserDialog dialog = new TreeRClassChooserDialog(project, RBundle.message((String)"ruby.debugger.choose.exception.class.dialog.title"), GlobalSearchScope.allScope((Project)project));
        if (!dialog.showDialog()) {
            return null;
        }
        RClass rClass = dialog.getSelectedClass();
        if (rClass != null) {
            String qualifiedName = RubyClassResolveUtil.getQualifiedName(rClass);
            assert (qualifiedName != null) : "Qualified name of the class shouldn't be null";
            return XDebuggerManager.getInstance((Project)project).getBreakpointManager().addBreakpoint((XBreakpointType)this, (XBreakpointProperties)new RubyExceptionBreakpointProperties(qualifiedName));
        }
        return null;
    }

    public XBreakpoint<RubyExceptionBreakpointProperties> createDefaultBreakpoint(@NotNull XBreakpointType.XBreakpointCreator<RubyExceptionBreakpointProperties> creator) {
        if (creator == null) {
            RubyExceptionBreakpointType.$$$reportNull$$$0(3);
        }
        return creator.createBreakpoint((XBreakpointProperties)new RubyExceptionBreakpointProperties());
    }

    public String getBreakpointsDialogHelpTopic() {
        return "reference.dialogs.breakpoints";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/breakpoints/RubyExceptionBreakpointType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInactiveDependentIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/breakpoints/RubyExceptionBreakpointType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultBreakpoint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }
}

