/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.attach;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.attach.EnvironmentAwareHost;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebugRunner;
import org.jetbrains.plugins.ruby.ruby.debugger.attach.RubyAttachCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.rubyforge.debugcommons.model.RubyDebugTarget;

public class RubyAttachProcessDebugRunner
extends RubyDebugRunner {
    private static final Logger LOG = Logger.getInstance(RubyAttachProcessDebugRunner.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Sdk mySdk;
    @NotNull
    private final EnvironmentAwareHost myHost;
    @NotNull
    private final ProcessInfo myInfo;

    public RubyAttachProcessDebugRunner(@NotNull Project project, @NotNull Sdk sdk, @NotNull EnvironmentAwareHost host, @NotNull ProcessInfo info) {
        if (project == null) {
            RubyAttachProcessDebugRunner.$$$reportNull$$$0(0);
        }
        if (sdk == null) {
            RubyAttachProcessDebugRunner.$$$reportNull$$$0(1);
        }
        if (host == null) {
            RubyAttachProcessDebugRunner.$$$reportNull$$$0(2);
        }
        if (info == null) {
            RubyAttachProcessDebugRunner.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.mySdk = sdk;
        this.myHost = host;
        this.myInfo = info;
    }

    public XDebugSession launch() throws ExecutionException {
        FileDocumentManager.getInstance().saveAllDocuments();
        return this.launchDebug();
    }

    @NotNull
    private static String getPidPresentation(@NotNull ProcessInfo processInfo) {
        if (processInfo == null) {
            RubyAttachProcessDebugRunner.$$$reportNull$$$0(4);
        }
        String string = processInfo.getPid() + " : " + processInfo.getExecutableCannonicalPath().orElse("ruby");
        if (string == null) {
            RubyAttachProcessDebugRunner.$$$reportNull$$$0(5);
        }
        return string;
    }

    private XDebugSession launchDebug() throws ExecutionException {
        RubyAttachCommandLineState state = RubyAttachCommandLineState.create(this.myProject, this.myHost, this.myInfo, this.mySdk);
        ExecutionEnvironment environment = state.getEnvironment();
        LOG.debug("Initializing debugger service");
        RubyDebugRunner.RubyDebugSessionBuilder builder2 = new RubyAttachDebugSessionBuilder(state, environment).setSupportsNonSuspendedFramesReading(false).clearIncludeExcludeDirs().setEnableFileFilering(false).showTab(RubyAttachProcessDebugRunner.getPidPresentation(this.myInfo)).setRubyDebuggerProxy().setAcceptor().setRubyDebugTarget().connectProxy();
        LOG.debug("Debugger service initialized. Starting RubyDebugProcess");
        return builder2.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/attach/RubyAttachProcessDebugRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/attach/RubyAttachProcessDebugRunner";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPidPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPidPresentation";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private static class RubyAttachDebugSessionBuilder
    extends RubyDebugRunner.RubyDebugSessionBuilder {
        RubyAttachDebugSessionBuilder(@NotNull RubyAbstractCommandLineState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
            if (state == null) {
                RubyAttachDebugSessionBuilder.$$$reportNull$$$0(0);
            }
            if (environment == null) {
                RubyAttachDebugSessionBuilder.$$$reportNull$$$0(1);
            }
            super(state, environment);
        }

        @NotNull
        public RubyAttachDebugSessionBuilder setSupportsNonSuspendedFramesReading(boolean doesSupport) {
            this.mySupportsNonSuspendedFramesReading = doesSupport;
            RubyAttachDebugSessionBuilder rubyAttachDebugSessionBuilder = this;
            if (rubyAttachDebugSessionBuilder == null) {
                RubyAttachDebugSessionBuilder.$$$reportNull$$$0(2);
            }
            return rubyAttachDebugSessionBuilder;
        }

        @Override
        @NotNull
        public RubyAttachDebugSessionBuilder setRubyDebugTarget() {
            this.myRubyDebugTarget = new RubyDebugTarget(this.myRubyDebuggerProxy, this.myLocalHostString, this.myDebuggerPort.intValue());
            RubyAttachDebugSessionBuilder rubyAttachDebugSessionBuilder = this;
            if (rubyAttachDebugSessionBuilder == null) {
                RubyAttachDebugSessionBuilder.$$$reportNull$$$0(3);
            }
            return rubyAttachDebugSessionBuilder;
        }

        @NotNull
        public RubyAttachDebugSessionBuilder clearIncludeExcludeDirs() {
            this.mySourceRoots = Collections.emptyList();
            this.myExcludedDirs = Collections.emptyList();
            RubyAttachDebugSessionBuilder rubyAttachDebugSessionBuilder = this;
            if (rubyAttachDebugSessionBuilder == null) {
                RubyAttachDebugSessionBuilder.$$$reportNull$$$0(4);
            }
            return rubyAttachDebugSessionBuilder;
        }

        @NotNull
        public RubyAttachDebugSessionBuilder setEnableFileFilering(boolean fileFiltering) {
            this.myEnableFileFiltering = fileFiltering;
            RubyAttachDebugSessionBuilder rubyAttachDebugSessionBuilder = this;
            if (rubyAttachDebugSessionBuilder == null) {
                RubyAttachDebugSessionBuilder.$$$reportNull$$$0(5);
            }
            return rubyAttachDebugSessionBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/attach/RubyAttachProcessDebugRunner$RubyAttachDebugSessionBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/attach/RubyAttachProcessDebugRunner$RubyAttachDebugSessionBuilder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setSupportsNonSuspendedFramesReading";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRubyDebugTarget";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clearIncludeExcludeDirs";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setEnableFileFilering";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

