/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.attach;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.remote.RemoteCredentials;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.attach.EnvironmentAwareHost;
import com.intellij.xdebugger.attach.LocalAttachHost;
import com.intellij.xdebugger.attach.XAttachDebugger;
import com.intellij.xdebugger.attach.XAttachDebuggerProvider;
import com.intellij.xdebugger.attach.XAttachHost;
import com.intellij.xdebugger.attach.XAttachPresentationGroup;
import com.intellij.xdebugger.attach.osHandlers.AttachOSHandler;
import com.intellij.xdebugger.attach.osHandlers.UnixAttachOSHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.debugger.attach.RubyAttachDebugger;
import org.jetbrains.plugins.ruby.ruby.debugger.attach.RubyAttachGroup;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.support.UIUtil;

public class RubyAttachDebuggerProvider
implements XAttachDebuggerProvider {
    private static final Logger LOG = Logger.getInstance(RubyAttachDebuggerProvider.class);
    private static final Key<Set<ProcessInfo>> ORPHAN_PROCESSES_KEY = Key.create((String)"RubyAttachDebuggerProvider.NON_SDK_PROCESSES");
    private static final Key<List<XAttachDebugger>> SDK_BASED_ATTACH_DEBUGGERS_KEY = Key.create((String)"RubyAttachDebuggerProvider.DEBUGGERS");
    private static final Key<Map<XAttachHost, Map<Integer, String>>> RUBY_PROCESS_MAP_KEY = Key.create((String)"RubyAttachDebuggerProvider.pidsMap");
    private static final String RUBY_PROCESSES_OBTAINING_COMMAND = "lsof -c ruby | grep -E 'bin/ruby([[:digit:]]+\\.?)*$'";

    @NotNull
    public XAttachPresentationGroup<ProcessInfo> getPresentationGroup() {
        RubyAttachGroup rubyAttachGroup = RubyAttachGroup.INSTANCE;
        if (rubyAttachGroup == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(0);
        }
        return rubyAttachGroup;
    }

    public boolean isAttachHostApplicable(@NotNull XAttachHost attachHost) {
        if (attachHost == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(1);
        }
        return attachHost instanceof EnvironmentAwareHost;
    }

    @NotNull
    public List<? extends XAttachDebugger> getAvailableDebuggers(@NotNull Project project, @NotNull XAttachHost attachHost, @NotNull ProcessInfo processInfo, @NotNull UserDataHolder contextHolder) {
        if (project == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(2);
        }
        if (attachHost == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(3);
        }
        if (processInfo == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(4);
        }
        if (contextHolder == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(5);
        }
        LOG.debug("Computing ruby debuggers for: ", new Object[]{"project=", project, "; ", "host=", attachHost, "; ", "process=", processInfo, "; ", "context=", contextHolder});
        if (!(attachHost instanceof EnvironmentAwareHost)) {
            LOG.debug("Host is not environment aware: " + String.valueOf(attachHost));
            List list = Collections.emptyList();
            if (list == null) {
                RubyAttachDebuggerProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        AttachOSHandler osHandler = ((EnvironmentAwareHost)attachHost).getOsHandler();
        if (!(osHandler instanceof UnixAttachOSHandler)) {
            LOG.debug("We can attach to unix only, got ", new Object[]{osHandler});
            List list = Collections.emptyList();
            if (list == null) {
                RubyAttachDebuggerProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        Map<Integer, String> rubyProcessMap = RubyAttachDebuggerProvider.getRubyProcessMap(attachHost, contextHolder);
        LOG.debug("Current ruby processes on ", new Object[]{attachHost, ": ", rubyProcessMap});
        if (!rubyProcessMap.containsKey(processInfo.getPid())) {
            LOG.debug("Process ", new Object[]{processInfo, " does not look ours"});
            List list = Collections.emptyList();
            if (list == null) {
                RubyAttachDebuggerProvider.$$$reportNull$$$0(8);
            }
            return list;
        }
        Sdk processSdk = RubyAttachDebuggerProvider.findSdkByResolvedPathAndMachineInfo(RubyAttachDebuggerProvider.getExecutable(processInfo, rubyProcessMap), attachHost);
        if (processSdk != null) {
            LOG.debug("Process sdk detected as ", new Object[]{processSdk});
            List<RubyAttachDebugger> list = Collections.singletonList(new RubyAttachDebugger(processSdk));
            if (list == null) {
                RubyAttachDebuggerProvider.$$$reportNull$$$0(9);
            }
            return list;
        }
        LOG.debug("No sdk detected for ", new Object[]{processInfo, " falling back to sdks suggestion"});
        RubyAttachDebuggerProvider.registerOrphanProcess(processInfo, contextHolder);
        return RubyAttachDebuggerProvider.getCompatibleSdkAttachDebuggers(project, attachHost, contextHolder);
    }

    @NotNull
    private static Map<Integer, String> getRubyProcessMap(@NotNull XAttachHost host, @NotNull UserDataHolder contextHolder) {
        HashMap<XAttachHost, Map> hostProcessMap;
        if (host == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(10);
        }
        if (contextHolder == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(11);
        }
        if ((hostProcessMap = (HashMap<XAttachHost, Map>)RUBY_PROCESS_MAP_KEY.get(contextHolder)) == null) {
            hostProcessMap = new HashMap<XAttachHost, Map>();
            RUBY_PROCESS_MAP_KEY.set(contextHolder, hostProcessMap);
        }
        Map map = hostProcessMap.computeIfAbsent(host, it -> RubyAttachDebuggerProvider.computeRubyProcessesMap((EnvironmentAwareHost)it));
        if (map == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(12);
        }
        return map;
    }

    @NotNull
    private static List<XAttachDebugger> getCompatibleSdkAttachDebuggers(@NotNull Project project, @NotNull XAttachHost host, @NotNull UserDataHolder contextHolder) {
        List<XAttachDebugger> result;
        if (project == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(13);
        }
        if (host == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(14);
        }
        if (contextHolder == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(15);
        }
        if ((result = (List<XAttachDebugger>)contextHolder.getUserData(SDK_BASED_ATTACH_DEBUGGERS_KEY)) != null) {
            List<XAttachDebugger> list = result;
            if (list == null) {
                RubyAttachDebuggerProvider.$$$reportNull$$$0(16);
            }
            return list;
        }
        result = RubySdkType.getAllValidRubySdks().stream().filter(sdk -> RubyAttachDebuggerProvider.isSdkFromHost(project, sdk, host)).map(RubyAttachDebugger::new).sorted(Comparator.comparing(RubyAttachDebugger::getDebuggerDisplayName).reversed()).collect(Collectors.toList());
        result.add(0, new RubyFakeXAttachDebugger());
        contextHolder.putUserData(SDK_BASED_ATTACH_DEBUGGERS_KEY, result);
        List<XAttachDebugger> list = result;
        if (list == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(17);
        }
        return list;
    }

    private static void registerOrphanProcess(@NotNull ProcessInfo processInfo, @NotNull UserDataHolder contextHolder) {
        Set<ProcessInfo> nonSdkProcesses;
        if (processInfo == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(18);
        }
        if (contextHolder == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(19);
        }
        if ((nonSdkProcesses = RubyAttachDebuggerProvider.getProcessInfosWithoutSdk(contextHolder)) == null) {
            nonSdkProcesses = new HashSet<ProcessInfo>();
        }
        nonSdkProcesses.add(processInfo);
        RubyAttachDebuggerProvider.setProcessInfosWithoutSdk(contextHolder, nonSdkProcesses);
    }

    @Nullable
    public static Set<ProcessInfo> getProcessInfosWithoutSdk(@NotNull UserDataHolder dataHolder) {
        if (dataHolder == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(20);
        }
        return (Set)dataHolder.getUserData(ORPHAN_PROCESSES_KEY);
    }

    public static void setProcessInfosWithoutSdk(@NotNull UserDataHolder dataHolder, @NotNull Set<ProcessInfo> processes) {
        if (dataHolder == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(21);
        }
        if (processes == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(22);
        }
        dataHolder.putUserData(ORPHAN_PROCESSES_KEY, processes);
    }

    private static boolean isSdkFromHost(@NotNull Project project, @NotNull Sdk sdk, @NotNull XAttachHost hostInfo) {
        SdkAdditionalData sdkAdditionalData;
        if (project == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(23);
        }
        if (sdk == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(24);
        }
        if (hostInfo == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(25);
        }
        if (!((sdkAdditionalData = sdk.getSdkAdditionalData()) instanceof RubyRemoteSdkAdditionalData)) {
            return hostInfo instanceof LocalAttachHost;
        }
        RubyRemoteSdkAdditionalData remoteSdkAdditionalData = (RubyRemoteSdkAdditionalData)sdkAdditionalData;
        if (!(hostInfo instanceof EnvironmentAwareHost)) {
            return false;
        }
        EnvironmentAwareHost environmentAwareHost = (EnvironmentAwareHost)hostInfo;
        if (!RubyRemoteInterpreterManager.getInstance().producesSshSdkCredentials(sdk)) {
            return true;
        }
        try {
            RemoteCredentials credentials = remoteSdkAdditionalData.getRemoteCredentials(project, true);
            return environmentAwareHost.isSameHost((Object)credentials);
        }
        catch (ExecutionException | InterruptedException e) {
            LOG.warn("Could not obtain remote SDK credentials", e);
            return false;
        }
    }

    @NotNull
    private static Map<Integer, String> computeRubyProcessesMap(@NotNull EnvironmentAwareHost host) {
        if (host == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(26);
        }
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        ArrayList<String> commandsList = new ArrayList<String>();
        commandsList.add("/bin/sh");
        commandsList.add("-c");
        commandsList.add(RUBY_PROCESSES_OBTAINING_COMMAND);
        try {
            LOG.debug("Fetching ruby processes using: ", new Object[]{commandsList});
            ProcessOutput processOutput = host.getProcessOutput(new GeneralCommandLine(commandsList));
            if (processOutput.getExitCode() != 0) {
                LOG.warn("Error running lsof command: " + String.valueOf(processOutput));
            } else {
                LOG.debug("Fetched ruby processes as ", new Object[]{processOutput});
            }
            for (String line : processOutput.getStdoutLines()) {
                String[] pidAndExec = line.split("\\s+");
                if (pidAndExec.length != 9) {
                    LOG.warn("Bad line format from lsof, 9 fields expected, ignoring: " + line);
                    continue;
                }
                result.put(Integer.valueOf(pidAndExec[1]), pidAndExec[8]);
            }
        }
        catch (ExecutionException e) {
            LOG.warn("Could not obtain list of ruby processes: " + String.valueOf(commandsList) + ": " + e.getMessage());
            Map<Integer, String> map = Collections.emptyMap();
            if (map == null) {
                RubyAttachDebuggerProvider.$$$reportNull$$$0(27);
            }
            return map;
        }
        LOG.debug("Fetched ruby processes as ", new Object[]{result});
        HashMap<Integer, String> hashMap = result;
        if (hashMap == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(28);
        }
        return hashMap;
    }

    @Contract(value="null,_ -> null")
    @Nullable
    private static Sdk findSdkByResolvedPathAndMachineInfo(@Nullable String path, @NotNull XAttachHost host) {
        if (host == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(29);
        }
        if (path == null) {
            return null;
        }
        return (Sdk)ContainerUtil.find((Iterable)ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)RubySdkType.getInstance()), sdk -> {
            if (host instanceof LocalAttachHost && sdk.getSdkAdditionalData() instanceof RubyRemoteSdkAdditionalData) {
                return false;
            }
            if (!(host instanceof LocalAttachHost) && !(sdk.getSdkAdditionalData() instanceof RubyRemoteSdkAdditionalData)) {
                return false;
            }
            String homePath = sdk.getHomePath();
            if (sdk.getSdkAdditionalData() instanceof RubyRemoteSdkAdditionalData) {
                homePath = ((RubyRemoteSdkAdditionalData)sdk.getSdkAdditionalData()).getInterpreterPath();
            }
            if (homePath == null) {
                return false;
            }
            if (SystemInfoRt.isFileSystemCaseSensitive ? homePath.equals(path) : homePath.equalsIgnoreCase(path)) {
                return true;
            }
            try {
                String h = new File(homePath).getCanonicalPath();
                return SystemInfoRt.isFileSystemCaseSensitive ? h.equals(path) : h.equalsIgnoreCase(path);
            }
            catch (IOException e) {
                return false;
            }
        });
    }

    @Nullable
    private static String getExecutable(@NotNull ProcessInfo info, @NotNull Map<Integer, String> pidCache) {
        String result;
        if (info == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(30);
        }
        if (pidCache == null) {
            RubyAttachDebuggerProvider.$$$reportNull$$$0(31);
        }
        return (result = pidCache.get(info.getPid())) == null ? (String)info.getExecutableCannonicalPath().orElse(null) : result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 10, 11, 13, 14, 15, 18, 19, 20, 21, 22, 23, 24, 25, 26, 29, 30, 31 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/attach/RubyAttachDebuggerProvider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachHost";
                break;
            }
            case 2: 
            case 13: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processInfo";
                break;
            }
            case 5: 
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextHolder";
                break;
            }
            case 10: 
            case 14: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processes";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostInfo";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pidCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationGroup";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/attach/RubyAttachDebuggerProvider";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDebuggers";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRubyProcessMap";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompatibleSdkAttachDebuggers";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRubyProcessesMap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAttachHostApplicable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableDebuggers";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRubyProcessMap";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCompatibleSdkAttachDebuggers";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "registerOrphanProcess";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getProcessInfosWithoutSdk";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setProcessInfosWithoutSdk";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isSdkFromHost";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "computeRubyProcessesMap";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findSdkByResolvedPathAndMachineInfo";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getExecutable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 10, 11, 13, 14, 15, 18, 19, 20, 21, 22, 23, 24, 25, 26, 29, 30, 31 -> new IllegalArgumentException(string);
        };
    }

    @VisibleForTesting
    public static final class RubyFakeXAttachDebugger
    implements XAttachDebugger {
        @NotNull
        public String getDebuggerDisplayName() {
            String string = RBundle.message((String)"ruby.attach.add.sdk.for.host");
            if (string == null) {
                RubyFakeXAttachDebugger.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public String getDebuggerSelectedTitle() {
            return RBundle.message((String)"ruby.attach.add.sdk.for.host.title");
        }

        public void attachDebugSession(@NotNull Project project, @NotNull XAttachHost attachHost, @NotNull ProcessInfo processInfo) {
            if (project == null) {
                RubyFakeXAttachDebugger.$$$reportNull$$$0(1);
            }
            if (attachHost == null) {
                RubyFakeXAttachDebugger.$$$reportNull$$$0(2);
            }
            if (processInfo == null) {
                RubyFakeXAttachDebugger.$$$reportNull$$$0(3);
            }
            UIUtil.openRubyProjectSettings(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/attach/RubyAttachDebuggerProvider$RubyFakeXAttachDebugger";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attachHost";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebuggerDisplayName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/attach/RubyAttachDebuggerProvider$RubyFakeXAttachDebugger";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "attachDebugSession";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

