/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.attach;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.attach.EnvironmentAwareHost;
import com.intellij.xdebugger.attach.LocalAttachHost;
import com.intellij.xdebugger.attach.osHandlers.AttachOSHandler;
import com.intellij.xdebugger.attach.osHandlers.UnixAttachOSHandler;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebugMode;
import org.jetbrains.plugins.ruby.ruby.debugger.SourcePositionConverter;
import org.jetbrains.plugins.ruby.ruby.debugger.attach.SourcePositionDecorator;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunEnvironmentProvider;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationType;
import org.jetbrains.plugins.ruby.ruby.run.configuration.debugger.RubyDebugIdeGemHelper;
import org.jetbrains.plugins.ruby.ruby.run.configuration.rubyScript.RubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public final class RubyAttachCommandLineState
extends RubyAbstractCommandLineState {
    @NotNull
    private final ProcessInfo myInfo;
    @NotNull
    private final EnvironmentAwareHost myHost;

    private RubyAttachCommandLineState(@NotNull RubyRunConfiguration config, @NotNull ExecutionEnvironment env, @NotNull ProcessInfo info, @NotNull EnvironmentAwareHost host) {
        if (config == null) {
            RubyAttachCommandLineState.$$$reportNull$$$0(0);
        }
        if (env == null) {
            RubyAttachCommandLineState.$$$reportNull$$$0(1);
        }
        if (info == null) {
            RubyAttachCommandLineState.$$$reportNull$$$0(2);
        }
        if (host == null) {
            RubyAttachCommandLineState.$$$reportNull$$$0(3);
        }
        super(config, env, false);
        this.myInfo = info;
        this.myHost = host;
    }

    public RubyRunConfiguration getConfig() {
        return (RubyRunConfiguration)super.getConfig();
    }

    @Override
    protected RubyCommandLineData createRunCommandLine() throws ExecutionException {
        return this.createCommandLineData();
    }

    private boolean isSudoNeeded(@NotNull UnixAttachOSHandler osHandler, int pid) {
        if (osHandler == null) {
            RubyAttachCommandLineState.$$$reportNull$$$0(4);
        }
        if (this.myHost instanceof LocalAttachHost) {
            if (osHandler.getOSType() == AttachOSHandler.OSType.LINUX) {
                return osHandler.getPtraceScope() > 0 || !osHandler.isOurProcess(pid);
            }
            if (osHandler.getOSType() == AttachOSHandler.OSType.MACOSX) {
                return !osHandler.isOurProcess(pid);
            }
        }
        return true;
    }

    private RubyCommandLineData createCommandLineData() throws ExecutionException {
        RubyRunConfiguration config = this.getConfig();
        AttachOSHandler osHandler = this.myHost.getOsHandler();
        UnixAttachOSHandler unixOsHandler = (UnixAttachOSHandler)osHandler;
        boolean askForSudo = this.isSudoNeeded(unixOsHandler, this.myInfo.getPid());
        Sdk sdk = config.getSdk();
        assert (sdk != null) : "Sdk cannot be null here";
        RubyRunner runner = RunnerUtil.getRunner(sdk, config.getModule());
        HashMap<String, String> environment = new HashMap<String, String>(config.getEnvs());
        RunEnvironmentProvider.processRunConfig(sdk, config.getModule(), environment);
        RubyDebugAttachCommandLineDataBuilder commandLineDataBuilder = new RubyDebugAttachCommandLineDataBuilder(config, environment, runner, sdk, this.myHost, RubyDebugMode.ATTACH_MODE);
        Ref uid = new Ref((Object)-1);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> uid.set((Object)unixOsHandler.getUid()), RBundle.message((String)"ruby.debugger.attach.uid.progress.title"), false, config.getProject());
        } else {
            uid.set((Object)unixOsHandler.getUid());
        }
        ((RubyDebugAttachCommandLineDataBuilder)((RubyDebugAttachCommandLineDataBuilder)((RubyDebugAttachCommandLineDataBuilder)((RubyDebugAttachCommandLineDataBuilder)((RubyDebugAttachCommandLineDataBuilder)commandLineDataBuilder.setDebugConsoleAllowed(true)).setAskForSudo(askForSudo)).setRubyDebugIdeExecutable()).setGdbWrapperOptions(this.myInfo.getPid(), (Integer)uid.get()).setCommandDelimiter()).setRdebugOptions().setAddBundleExec(false)).putRunner();
        return commandLineDataBuilder.build();
    }

    public static RubyAttachCommandLineState create(@NotNull Project project, @NotNull EnvironmentAwareHost machine, @NotNull ProcessInfo info, @NotNull Sdk sdk) throws ExecutionException {
        if (project == null) {
            RubyAttachCommandLineState.$$$reportNull$$$0(5);
        }
        if (machine == null) {
            RubyAttachCommandLineState.$$$reportNull$$$0(6);
        }
        if (info == null) {
            RubyAttachCommandLineState.$$$reportNull$$$0(7);
        }
        if (sdk == null) {
            RubyAttachCommandLineState.$$$reportNull$$$0(8);
        }
        RubyRunConfiguration conf = (RubyRunConfiguration)RubyRunConfigurationType.getInstance().getRubyScriptFactory().createTemplateConfiguration(project);
        conf.setAlternativeSdk(sdk);
        conf.setShouldUseAlternativeSdk(true);
        ExecutionEnvironment env = ExecutionEnvironmentBuilder.create((Project)project, (Executor)DefaultDebugExecutor.getDebugExecutorInstance(), (RunProfile)conf).build();
        return new RubyAttachCommandLineState(conf, env, info, machine);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "osHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "machine";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/attach/RubyAttachCommandLineState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isSudoNeeded";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RubyDebugAttachCommandLineDataBuilder
    extends RubyAbstractCommandLineState.RubyDebugCommandLineDataBuilderBase<RubyDebugAttachCommandLineDataBuilder> {
        @NonNls
        private static final String RDEBUG_ATTACH_MODE = "--attach-mode";
        @NonNls
        private static final String PID = "--pid";
        @NonNls
        private static final String RUBY_PATH = "--ruby-path";
        @NonNls
        private static final String UID = "--uid";
        @NonNls
        private static final String INCLUDE_GEM = "--include-gem";
        @NotNull
        private final EnvironmentAwareHost myHost;

        RubyDebugAttachCommandLineDataBuilder(@NotNull AbstractRubyRunConfiguration config, @NotNull Map<String, String> environment, @NotNull RubyRunner runner, @NotNull Sdk sdk, @NotNull EnvironmentAwareHost host, @NotNull RubyDebugMode mode) throws ExecutionException {
            if (config == null) {
                RubyDebugAttachCommandLineDataBuilder.$$$reportNull$$$0(0);
            }
            if (environment == null) {
                RubyDebugAttachCommandLineDataBuilder.$$$reportNull$$$0(1);
            }
            if (runner == null) {
                RubyDebugAttachCommandLineDataBuilder.$$$reportNull$$$0(2);
            }
            if (sdk == null) {
                RubyDebugAttachCommandLineDataBuilder.$$$reportNull$$$0(3);
            }
            if (host == null) {
                RubyDebugAttachCommandLineDataBuilder.$$$reportNull$$$0(4);
            }
            if (mode == null) {
                RubyDebugAttachCommandLineDataBuilder.$$$reportNull$$$0(5);
            }
            super(config, environment, runner, sdk, mode);
            this.myHost = host;
        }

        @Override
        @NotNull
        public SourcePositionConverter getDefaultSourcePositionConverter() {
            return new SourcePositionDecorator(super.getDefaultSourcePositionConverter(), this.myHost);
        }

        @Override
        @NotNull
        public RubyDebugAttachCommandLineDataBuilder setRdebugOptions() throws ExecutionException {
            super.setRdebugOptions();
            this.myArgs.add(RDEBUG_ATTACH_MODE);
            RubyDebugAttachCommandLineDataBuilder rubyDebugAttachCommandLineDataBuilder = this;
            if (rubyDebugAttachCommandLineDataBuilder == null) {
                RubyDebugAttachCommandLineDataBuilder.$$$reportNull$$$0(6);
            }
            return rubyDebugAttachCommandLineDataBuilder;
        }

        @NotNull
        private RubyDebugAttachCommandLineDataBuilder setGdbWrapperOptions(int pid, int uid) {
            this.setPid(pid);
            this.setSdkPath();
            this.setUid(uid);
            this.includeAllDebugGems();
            RubyDebugAttachCommandLineDataBuilder rubyDebugAttachCommandLineDataBuilder = this;
            if (rubyDebugAttachCommandLineDataBuilder == null) {
                RubyDebugAttachCommandLineDataBuilder.$$$reportNull$$$0(7);
            }
            return rubyDebugAttachCommandLineDataBuilder;
        }

        private RubyAbstractCommandLineState.RubyDebugCommandLineDataBuilderBase setPid(int pid) {
            this.myArgs.add(PID);
            this.myArgs.add(String.valueOf(pid));
            return this;
        }

        private RubyAbstractCommandLineState.RubyDebugCommandLineDataBuilderBase setSdkPath() {
            this.myArgs.add(RUBY_PATH);
            if (this.mySdk.getSdkAdditionalData() instanceof RubyRemoteSdkAdditionalData) {
                this.myArgs.add(((RubyRemoteSdkAdditionalData)this.mySdk.getSdkAdditionalData()).getInterpreterPath());
            } else {
                this.myArgs.add(this.mySdk.getHomePath());
            }
            return this;
        }

        private RubyAbstractCommandLineState.RubyDebugCommandLineDataBuilderBase setUid(int uid) {
            if (this.myAskForSudo && uid != -1) {
                this.myArgs.add(UID);
                this.myArgs.add(String.valueOf(uid));
            }
            return this;
        }

        private RubyAbstractCommandLineState.RubyDebugCommandLineDataBuilderBase includeGem(@NotNull String gemPath) {
            if (gemPath == null) {
                RubyDebugAttachCommandLineDataBuilder.$$$reportNull$$$0(8);
            }
            this.myArgs.add(INCLUDE_GEM);
            this.myArgs.add(gemPath);
            return this;
        }

        private void convertGemIfRemoteAndAdd(@NotNull GemInfo gem) {
            VirtualFile libFolder;
            if (gem == null) {
                RubyDebugAttachCommandLineDataBuilder.$$$reportNull$$$0(9);
            }
            if ((libFolder = gem.getLibFolder()) == null || libFolder.getCanonicalPath() == null) {
                return;
            }
            String gemPath = libFolder.getCanonicalPath();
            if (this.mySdk.getSdkAdditionalData() instanceof RubyRemoteSdkAdditionalData) {
                gemPath = RubySdkUtil.convertToRemote(this.mySdk, this.myConfig.getModule(), libFolder.getCanonicalPath());
            }
            this.includeGem(gemPath);
        }

        private RubyAbstractCommandLineState.RubyDebugCommandLineDataBuilderBase includeAllDebugGems() {
            GemInfo backEndGem;
            GemInfo frontEndGem = RubyDebugIdeGemHelper.findGem(((RubyDebugIdeGemHelper)this.myDebugGemHelper).getDebugFrontEndGemName(), this.myConfig.getModule(), this.mySdk);
            if (frontEndGem != null) {
                this.convertGemIfRemoteAndAdd(frontEndGem);
            }
            if ((backEndGem = RubyDebugIdeGemHelper.findGem(((RubyDebugIdeGemHelper)this.myDebugGemHelper).getDebugBackendEndGemName(this.mySdk), this.myConfig.getModule(), this.mySdk)) != null) {
                this.convertGemIfRemoteAndAdd(backEndGem);
            }
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runner";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/attach/RubyAttachCommandLineState$RubyDebugAttachCommandLineDataBuilder";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gemPath";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/attach/RubyAttachCommandLineState$RubyDebugAttachCommandLineDataBuilder";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRdebugOptions";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setGdbWrapperOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "includeGem";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "convertGemIfRemoteAndAdd";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

