/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyProcessDispatcher;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RemotePositionConverter;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebugProcess;
import org.jetbrains.plugins.ruby.ruby.debugger.settings.RubyDebuggerSettings;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyProgramRunner;
import org.jetbrains.plugins.ruby.ruby.run.configuration.remote.RubyRemoteDebugConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.remote.RubyRemoteDebugConfigurationParams;
import org.jetbrains.plugins.ruby.support.UIUtil;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.Util;
import org.rubyforge.debugcommons.model.RubyDebugTarget;

public final class RubyRemoteDebugRunner
extends RubyProgramRunner {
    private static final Logger LOG = Logger.getInstance(RubyRemoteDebugRunner.class);
    @NonNls
    private static final String REMOTE_DEBUG_NOTIFICATION_GROUP_ID = "Remote Debug";
    @NotNull
    public static final String RUBY_REMOTE_DEBUGGER_SUPPORT_FULL_VALUE_EVALUATION = "ruby.remote.debugger.supports.fullValue.evaluation";
    @NotNull
    public static final String RUBY_REMOTE_DEBUGGER_SUPPORT_TYPE_RENDERER = "ruby.remote.debugger.supports.typeRenderers";

    @Override
    @NotNull
    public String getRunnerId() {
        return "RubyRemoteDebugRunner";
    }

    @Override
    public boolean preloaderAllowed() {
        return false;
    }

    @Override
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            RubyRemoteDebugRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            RubyRemoteDebugRunner.$$$reportNull$$$0(1);
        }
        return "Debug".equals(executorId) && profile instanceof RubyRemoteDebugConfiguration;
    }

    @Override
    protected void doExecute(final @NotNull RunProfileState state, final @NotNull ExecutionEnvironment env, @NotNull AsyncPromise<RunContentDescriptor> result) throws ExecutionException {
        RubyProcessDispatcher acceptor;
        Module rubyModule;
        if (state == null) {
            RubyRemoteDebugRunner.$$$reportNull$$$0(2);
        }
        if (env == null) {
            RubyRemoteDebugRunner.$$$reportNull$$$0(3);
        }
        if (result == null) {
            RubyRemoteDebugRunner.$$$reportNull$$$0(4);
        }
        if ((rubyModule = RubyRemoteDebugRunner.getModuleForConfiguration(env.getRunnerAndConfigurationSettings())) == null) {
            throw new ExecutionException(RBundle.message((String)"ruby.debugger.no.ruby.module"));
        }
        final ProcessHandler processHandler = RubyRemoteDebugRunner.runBeforeTask(state, env);
        LOG.debug("Initializing debugger service");
        final RubyRemoteDebugConfigurationParams params = RubyRemoteDebugRunner.getRemoteDebugConfigurationParams(env, processHandler);
        final int timeout = RubyDebuggerSettings.getInstance().getState().getTimeout();
        boolean supportsCatchpointRemoval = Registry.is((String)"ruby.remote.debugger.supports.catchpoint.removal", (boolean)true);
        boolean supportsFullValueEvaluation = Registry.is((String)RUBY_REMOTE_DEBUGGER_SUPPORT_FULL_VALUE_EVALUATION);
        boolean supportsTypeRenderers = Registry.is((String)RUBY_REMOTE_DEBUGGER_SUPPORT_TYPE_RENDERER);
        if (RubyDebuggerSettings.getInstance().getState().isMultiprocess()) {
            acceptor = new RubyProcessDispatcher(params.getRemoteHost(), Util.DEBUGGER_SERVER_LOCALHOST, params.getDispatcherPort(), false, supportsCatchpointRemoval, supportsFullValueEvaluation, supportsTypeRenderers, false);
            acceptor.start();
        } else {
            acceptor = null;
        }
        final RubyDebuggerProxy rubyDebuggerProxy = new RubyDebuggerProxy(timeout, false, true, supportsCatchpointRemoval, supportsFullValueEvaluation, supportsTypeRenderers);
        RubyDebugTarget rubyDebugTarget = new RubyDebugTarget(rubyDebuggerProxy, params.getRemoteHost(), params.getPort());
        try {
            rubyDebuggerProxy.setDebugTarget(rubyDebugTarget);
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            throw new ExecutionException(e.getMessage());
        }
        LOG.debug("Debugger service initialized. Starting RubyDebugProcess");
        XDebugSession session = (XDebugSession)RubyRemoteDebugRunner.computeOnEdtWithExecutionException(() -> XDebuggerManager.getInstance((Project)env.getProject()).startSession(env, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    1.$$$reportNull$$$0(0);
                }
                RubyRemoteDebugRunner.this.beforeDebuggerConnects();
                RubyDebugProcess rubyDebugProcess = RubyRemoteDebugRunner.createRubyDebugProcess(session, state, processHandler, rubyDebuggerProxy, timeout, params, env, acceptor, rubyModule);
                if (rubyDebugProcess == null) {
                    1.$$$reportNull$$$0(1);
                }
                return rubyDebugProcess;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyRemoteDebugRunner$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyRemoteDebugRunner$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }));
        result.setResult((Object)session.getRunContentDescriptor());
    }

    @NotNull
    private static RubyDebugProcess createRubyDebugProcess(@NotNull XDebugSession session, @NotNull RunProfileState state, @Nullable ProcessHandler processHandler, RubyDebuggerProxy rubyDebuggerProxy, int timeout, RubyRemoteDebugConfigurationParams params, final @NotNull ExecutionEnvironment env, RubyProcessDispatcher acceptor, @NotNull Module rubyModule) {
        if (session == null) {
            RubyRemoteDebugRunner.$$$reportNull$$$0(5);
        }
        if (state == null) {
            RubyRemoteDebugRunner.$$$reportNull$$$0(6);
        }
        if (env == null) {
            RubyRemoteDebugRunner.$$$reportNull$$$0(7);
        }
        if (rubyModule == null) {
            RubyRemoteDebugRunner.$$$reportNull$$$0(8);
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(rubyModule);
        PathMappingSettings gemsMappings = null;
        if (sdk != null && sdk.getSdkAdditionalData() != null && sdk.getSdkAdditionalData() instanceof RubyRemoteSdkAdditionalData) {
            gemsMappings = ((RubyRemoteSdkAdditionalData)sdk.getSdkAdditionalData()).getPathMappings();
        } else {
            Notification notification = new Notification(REMOTE_DEBUG_NOTIFICATION_GROUP_ID, RBundle.message((String)"run.configuration.remote.debug.wrong.sdk.title"), RBundle.message((String)"run.configuration.remote.debug.wrong.sdk.error"), NotificationType.WARNING);
            notification.addAction((AnAction)new DumbAwareAction(RBundle.message((String)"action.select.sdk.text")){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    UIUtil.openRubyProjectSettings(env.getProject());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/ruby/debugger/RubyRemoteDebugRunner$2", "actionPerformed"));
                }
            });
            Notifications.Bus.notify((Notification)notification);
        }
        return new RubyDebugProcess(session, state, processHandler, rubyDebuggerProxy, timeout, new RemotePositionConverter(rubyModule.getProject(), params.getLocalRoot(), params.getRemoteRoot(), gemsMappings), env, acceptor, true, true, false, Collections.emptyList(), Collections.emptyList());
    }

    private void beforeDebuggerConnects() {
    }

    @Nullable
    private static ProcessHandler runBeforeTask(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (state == null) {
            RubyRemoteDebugRunner.$$$reportNull$$$0(9);
        }
        if (env == null) {
            RubyRemoteDebugRunner.$$$reportNull$$$0(10);
        }
        return null;
    }

    private static RubyRemoteDebugConfigurationParams getRemoteDebugConfigurationParams(@NotNull ExecutionEnvironment env, @Nullable ProcessHandler remoteProcessHandler) {
        if (env == null) {
            RubyRemoteDebugRunner.$$$reportNull$$$0(11);
        }
        return (RubyRemoteDebugConfigurationParams)env.getRunProfile();
    }

    @Nullable
    private static Module getModuleForConfiguration(@Nullable RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            return null;
        }
        RubyRemoteDebugConfiguration configuration = (RubyRemoteDebugConfiguration)ObjectUtils.tryCast((Object)settings.getConfiguration(), RubyRemoteDebugConfiguration.class);
        if (configuration == null) {
            return null;
        }
        if (configuration.getConfigurationModule().getModule() != null) {
            return configuration.getConfigurationModule().getModule();
        }
        VirtualFile localRoot = (VirtualFile)ObjectUtils.doIfNotNull((Object)configuration.getLocalRoot(), it -> VfsUtil.findFile((Path)Paths.get(it, new String[0]), (boolean)false));
        Module localRootModule = (Module)ObjectUtils.doIfNotNull((Object)localRoot, it -> ModuleUtilCore.findModuleForFile((VirtualFile)it, (Project)configuration.getProject()));
        if (localRootModule != null) {
            return localRootModule;
        }
        return (Module)ObjectUtils.coalesce((Object)((Module)ContainerUtil.getFirstItem((List)configuration.getValidModules())), (Object)configuration.getDefaultModule());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyModule";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyRemoteDebugRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createRubyDebugProcess";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "runBeforeTask";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getRemoteDebugConfigurationParams";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

