/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyStackFrame;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyDebugValue;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyDebugValueFactory;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyExpressionCodeFragment;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.impl.RControlFlowBuilder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RNameUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.rubyforge.debugcommons.model.RubyValue;
import org.rubyforge.debugcommons.model.RubyVariable;

public final class RubyDebuggerSupportUtils {
    private RubyDebuggerSupportUtils() {
    }

    @NotNull
    public static String getRubyValuePresentationString(@NotNull RubyValue value) {
        String valueString;
        if (value == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(0);
        }
        if ((valueString = value.getValueString()).length() > 1000) {
            String string = valueString.substring(0, 1000);
            if (string == null) {
                RubyDebuggerSupportUtils.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = valueString;
        if (string == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getObtainFieldCommand(@NotNull String name, @NotNull RubyVariable variable) {
        if (name == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(3);
        }
        if (variable == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(4);
        }
        if (!"class".equals(variable.getVariableInfo().getKind())) {
            String string = ".instance_variable_get(:" + name + ")";
            if (string == null) {
                RubyDebuggerSupportUtils.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = ".class.class_variable_get(:" + name + ")";
        if (string == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static Document createDocument(@NotNull String text, @NotNull Project project, @Nullable VirtualFile contextVirtualFile, int contextOffset) {
        if (text == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(7);
        }
        if (project == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(8);
        }
        RPsiElement context = null;
        if (contextVirtualFile != null) {
            context = RubyDebuggerSupportUtils.getContextElement(contextVirtualFile, contextOffset, project);
        }
        RubyExpressionCodeFragment codeFragment = RubyElementFactory.createExpressionCodeFragment(project, text, (PsiElement)context, true);
        return PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)codeFragment);
    }

    @Nullable
    public static RPsiElement getContextElement(@NotNull VirtualFile virtualFile, int offset, @NotNull Project project) {
        if (virtualFile == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(9);
        }
        if (project == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(10);
        }
        if (!virtualFile.isValid()) {
            return null;
        }
        Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(virtualFile));
        if (document == null) {
            return null;
        }
        FileViewProvider viewProvider = PsiManager.getInstance((Project)project).findViewProvider(virtualFile);
        if (viewProvider == null) {
            return null;
        }
        PsiFile file = viewProvider.getPsi((Language)RubyLanguage.INSTANCE);
        if (file == null) {
            return null;
        }
        if (offset >= 0 && offset < document.getTextLength()) {
            int lineEndOffset = document.getLineEndOffset(document.getLineNumber(offset));
            while (offset < lineEndOffset) {
                IElementType type;
                PsiElement element = file.findElementAt(offset);
                if (element == null) {
                    return null;
                }
                if (!(element instanceof PsiWhiteSpace) && !(element instanceof PsiComment) && (type = PsiUtilCore.getElementType((PsiElement)element)) instanceof RubyElementType && type != RubyTokenTypes.tEOL) {
                    return RControlFlowBuilder.getControlFlowNodeElement(element);
                }
                offset = element.getTextRange().getEndOffset() + 1;
            }
        }
        return null;
    }

    @Nullable
    public static TextRange getExpressionAtOffset(@NotNull Project project, @NotNull Document document, int offset) {
        RIdentifier rIdentifier;
        PsiFile file;
        if (project == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(11);
        }
        if (document == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(12);
        }
        if ((file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) == null) {
            return null;
        }
        RExpression expr = RubyPsiUtil.getCoveringExpression(file.findElementAt(offset));
        if (expr == null) {
            return null;
        }
        if (expr instanceof RIdentifier && ((rIdentifier = (RIdentifier)expr).isParameterDeclaration() || rIdentifier.isLocalVariable())) {
            return rIdentifier.getTextRange();
        }
        if (expr instanceof RField || expr instanceof RGlobalVariable) {
            return expr.getTextRange();
        }
        if (TextUtil.isCIDOrColonQualifiedReference((String)expr.getText())) {
            return expr.getTextRange();
        }
        return null;
    }

    public static void addRubyVariablesToNode(Project project, XSourcePosition position, @NotNull XCompositeNode node, RubyVariable @NotNull [] variables, @NotNull RubyStackFrame frame, @Nullable RubyDebugValue value) {
        if (node == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(13);
        }
        if (frame == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(14);
        }
        if (variables == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(15);
        }
        RubyDebuggerSupportUtils.addRubyVariablesToNode(project, position, node, variables, frame, value, false);
    }

    public static void addRubyVariablesToNode(Project project, XSourcePosition position, @NotNull XCompositeNode node, RubyVariable @NotNull [] variables, @NotNull RubyStackFrame frame, @Nullable RubyDebugValue value, boolean alreadySorted) {
        if (node == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(16);
        }
        if (frame == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(17);
        }
        if (variables == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(18);
        }
        RubyDebuggerSupportUtils.addRubyVariablesToNode(project, position, node, variables, frame, value, alreadySorted, true);
    }

    public static void addRubyVariablesToNode(Project project, XSourcePosition position, @NotNull XCompositeNode node, RubyVariable @NotNull [] variables, @NotNull RubyStackFrame frame, @Nullable RubyDebugValue value, boolean alreadySorted, boolean isLastChildren) {
        if (node == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(19);
        }
        if (frame == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(20);
        }
        if (variables == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(21);
        }
        RubyDebuggerSupportUtils.addRubyVariablesToNode(node, ContainerUtil.map((Object[])variables, v -> RubyDebugValueFactory.create(project, position, frame, value, v.getName(), v)), alreadySorted, isLastChildren);
    }

    public static void addRubyVariablesToNode(@NotNull XCompositeNode node, @NotNull List<RubyDebugValue> debugValues, boolean alreadySorted, boolean isLastChildren) {
        if (node == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(22);
        }
        if (debugValues == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(23);
        }
        if (node.isObsolete()) {
            return;
        }
        XValueChildrenList values = new XValueChildrenList();
        node.setAlreadySorted(alreadySorted);
        for (RubyDebugValue value : debugValues) {
            String name = RubyDebuggerSupportUtils.convertToIdeEncoding(value.getName());
            if (StringUtil.isEmptyOrSpaces((String)name)) continue;
            values.add(name, (XValue)value);
        }
        node.addChildren(values, isLastChildren);
    }

    @RequiresReadLock
    public static OrderedSet<String> collectFieldsMentionedInContext(@NotNull RContainer scope) {
        if (scope == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(24);
        }
        ThreadingAssertions.softAssertReadAccess();
        final OrderedSet processedNames = new OrderedSet();
        scope.acceptChildren((PsiElementVisitor)new RubyDebuggerScopeVisitor(scope){

            public void visitRClassVariable(@NotNull RClassVariable rClassVariable) {
                if (rClassVariable == null) {
                    1.$$$reportNull$$$0(0);
                }
                String name = rClassVariable.getText();
                processedNames.add((Object)name);
            }

            public void visitRInstanceVariable(@NotNull RInstanceVariable rInstanceVariable) {
                if (rInstanceVariable == null) {
                    1.$$$reportNull$$$0(1);
                }
                String name = rInstanceVariable.getText();
                processedNames.add((Object)name);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rClassVariable";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rInstanceVariable";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebuggerSupportUtils$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRClassVariable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRInstanceVariable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return processedNames;
    }

    @RequiresReadLock
    public static OrderedSet<String> addGlobalsMentionedInContext(@NotNull RContainer scope) {
        if (scope == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(25);
        }
        ThreadingAssertions.softAssertReadAccess();
        final OrderedSet globals = new OrderedSet();
        scope.acceptChildren((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            public void visitRGlobalVariable(@NotNull RGlobalVariable rGlobalVariable) {
                if (rGlobalVariable == null) {
                    2.$$$reportNull$$$0(0);
                }
                String name = rGlobalVariable.getText();
                globals.add((Object)name);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rGlobalVariable", "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebuggerSupportUtils$2", "visitRGlobalVariable"));
            }
        });
        return globals;
    }

    @RequiresReadLock
    public static OrderedSet<String> collectContextInfoFromProviders(@NotNull RContainer scope, XSourcePosition xSourcePosition) {
        if (scope == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(26);
        }
        ThreadingAssertions.softAssertReadAccess();
        OrderedSet processedNames = new OrderedSet();
        for (ContextInfoProvider provider : (ContextInfoProvider[])ContextInfoProvider.EP_NAME.getExtensions()) {
            List<String> expressions = provider.getEvaluateExpression(scope, xSourcePosition);
            processedNames.addAll(expressions);
        }
        return processedNames;
    }

    @RequiresReadLock
    public static OrderedSet<String> collectConstantsMentionedInContext(@NotNull RContainer scope) {
        if (scope == null) {
            RubyDebuggerSupportUtils.$$$reportNull$$$0(27);
        }
        ThreadingAssertions.softAssertReadAccess();
        final OrderedSet processedNames = new OrderedSet();
        scope.acceptChildren((PsiElementVisitor)new RubyDebuggerScopeVisitor(scope){

            public void visitRReference(@NotNull RReference reference) {
                String classFqn;
                if (reference == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((classFqn = 3.getClassFqn(reference)) != null) {
                    processedNames.add((Object)classFqn);
                    return;
                }
                RPsiElement receiver = reference.getReceiver();
                if (receiver != null) {
                    receiver.accept((PsiElementVisitor)this);
                }
            }

            public void visitRConstant(@NotNull RConstant rConstant) {
                if (rConstant == null) {
                    3.$$$reportNull$$$0(1);
                }
                String fqn = rConstant.getText();
                processedNames.add((Object)fqn);
            }

            @Nullable
            private static String getClassFqn(RReference rReference) {
                FQN fqn = RNameUtilCore.getPath((PsiElement)rReference);
                for (String path : fqn.asList()) {
                    if (TextUtil.isConstId((String)path)) continue;
                    return null;
                }
                return fqn.getFullPath();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rConstant";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebuggerSupportUtils$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRReference";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRConstant";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return processedNames;
    }

    public static String convertToIdeEncoding(String value) {
        return new String(value.getBytes(StandardCharsets.UTF_8), EncodingManager.getInstance().getDefaultCharset());
    }

    public static void invalidateSessionFrames(XDebugSession session) {
        XStackFrame frame;
        if (session != null && (frame = session.getCurrentStackFrame()) instanceof RubyStackFrame) {
            ((RubyStackFrame)frame).getRubyThread().invalidateFrames();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebuggerSupportUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 13: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugValues";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebuggerSupportUtils";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRubyValuePresentationString";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getObtainFieldCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRubyValuePresentationString";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getObtainFieldCommand";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getContextElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionAtOffset";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addRubyVariablesToNode";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "collectFieldsMentionedInContext";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addGlobalsMentionedInContext";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "collectContextInfoFromProviders";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectConstantsMentionedInContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 6 -> new IllegalStateException(string);
        };
    }

    public static interface ContextInfoProvider {
        public static final ExtensionPointName<ContextInfoProvider> EP_NAME = ExtensionPointName.create((String)"org.jetbrains.plugins.ruby.debug.infoProvider");

        @NotNull
        public List<String> getEvaluateExpression(RContainer var1, XSourcePosition var2);
    }

    private static abstract class RubyDebuggerScopeVisitor
    extends RubyRecursiveElementVisitor {
        private final RContainer myScope;

        RubyDebuggerScopeVisitor(RContainer scope) {
            this.myScope = scope;
        }

        public void visitRClass(@NotNull RClass rClass) {
            if (rClass == null) {
                RubyDebuggerScopeVisitor.$$$reportNull$$$0(0);
            }
            if (rClass != this.myScope) {
                return;
            }
            super.visitRClass(rClass);
        }

        public void visitRModule(@NotNull RModule rModule) {
            if (rModule == null) {
                RubyDebuggerScopeVisitor.$$$reportNull$$$0(1);
            }
            if (rModule != this.myScope) {
                return;
            }
            super.visitRModule(rModule);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rModule";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebuggerSupportUtils$RubyDebuggerScopeVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRModule";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

