/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.compiler;

import com.intellij.DynamicBundle;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.compiler.JRubyCompilerSettings;
import org.jetbrains.plugins.ruby.ruby.run.configuration.beforeRun.jrubyc.JRubyCompileBeforeRunTask;

public class JRubyCompilerSettingsPanel {
    private JPanel mainPanel;
    private JTextField heapSizeField;
    private RawCommandLineEditor additionalParameters;
    private TextFieldWithBrowseButton targetPathBox;
    private JCheckBox clearTargetDirectoryBox;
    private JLabel targetLabel;
    private JLabel heapSizeLabel;
    private JLabel cmdParamsLabel;

    public JRubyCompilerSettingsPanel(@NotNull Project project, JRubyCompileBeforeRunTask task) {
        if (project == null) {
            JRubyCompilerSettingsPanel.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.initTargetBox(project);
        this.targetPathBox.setText(task.getTargetPath());
        this.additionalParameters.setText(task.getAdditionalOptions());
        this.heapSizeField.setText(task.getHeapSize());
        this.clearTargetDirectoryBox.setSelected(task.clearTargetDirectory());
        this.targetLabel.setLabelFor(this.targetPathBox.getTextField());
        this.heapSizeLabel.setLabelFor(this.heapSizeField);
        this.cmdParamsLabel.setLabelFor(this.additionalParameters.getTextField());
        DocumentAdapter adapter = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                JRubyCompilerSettingsPanel.this.validate(JRubyCompilerSettingsPanel.this.targetPathBox.getText(), JRubyCompilerSettingsPanel.this.heapSizeField.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/ruby/compiler/JRubyCompilerSettingsPanel$1", "textChanged"));
            }
        };
        this.targetPathBox.getTextField().getDocument().addDocumentListener((DocumentListener)adapter);
        this.heapSizeField.getDocument().addDocumentListener((DocumentListener)adapter);
    }

    protected void validate(String target, String heapSize) {
    }

    private void initTargetBox(final Project project) {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor fileChooserDescriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                fileChooserDescriptor2.setTitle(RBundle.message((String)"run.configuration.before.run.jruby.compiler.settings.target.path.title"));
                VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)fileChooserDescriptor2, (Component)JRubyCompilerSettingsPanel.this.targetPathBox, (Project)project, null);
                if (file != null) {
                    JRubyCompilerSettingsPanel.this.setTargetPath(file.getPresentableUrl());
                }
            }
        };
        this.targetPathBox.addActionListener(actionListener);
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public void setTargetPath(@NotNull @NlsSafe String directoryPath) {
        if (directoryPath == null) {
            JRubyCompilerSettingsPanel.$$$reportNull$$$0(1);
        }
        this.targetPathBox.setText(directoryPath);
    }

    public JRubyCompilerSettings apply() {
        return new JRubyCompilerSettings(this.heapSizeField.getText(), this.additionalParameters.getText(), this.targetPathBox.getText(), this.clearTargetDirectoryBox.isSelected());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryPath";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/compiler/JRubyCompilerSettingsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setTargetPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        RawCommandLineEditor rawCommandLineEditor;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JPanel jPanel;
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.targetLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/RBundle", JRubyCompilerSettingsPanel.class).getString("run.configuration.before.run.jruby.compiler.setting.target.path.text"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.heapSizeLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/RBundle", JRubyCompilerSettingsPanel.class).getString("run.configuration.before.run.jruby.compiler.setting.heap.size.text"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.cmdParamsLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/RBundle", JRubyCompilerSettingsPanel.class).getString("run.configuration.before.run.jruby.compiler.setting.additional.params.text"));
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.targetPathBox = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, new Dimension(150, -1), new Dimension(300, -1), null));
        this.heapSizeField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(300, -1), null));
        this.additionalParameters = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption(DynamicBundle.getBundle((String)"messages/RBundle", JRubyCompilerSettingsPanel.class).getString("run.configuration.before.run.jruby.compiler.setting.edit.params.text"));
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(2, 1, 1, 1, 0, 1, 7, 0, null, new Dimension(300, -1), null));
        this.clearTargetDirectoryBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/RBundle", JRubyCompilerSettingsPanel.class).getString("run.configuration.before.run.jruby.compiler.settings.clear.target.dir.text"));
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

