/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.usages;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.Scope;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.Access;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.RubyUsageAnalyzerCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.impl.AccessImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.impl.AssignAccessImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.impl.BlockParameterAccessImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.impl.CallAccessImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.impl.ConstantAccessImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.impl.FieldWriteAccessImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.impl.ForBlockParameterAccessImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.impl.MethodParameterAccessImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.impl.NumberedBlockParameterAccessImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.impl.ObjectClassAccessImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.impl.PredefinedParameterAssignAccessImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.impl.RClassAccessImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.impl.RModuleAccessImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.impl.RescueBlockParameterAccessImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.impl.SelfAssignAccessImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.impl.SingletonMethodAccessImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.ruby19.impl.BlockCallLocalVariableAccessImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.ruby19.impl.LambdaParameterAccessImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.ruby27.impl.PatternMatchingAssignAccessImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RForStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RRescueBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RClassObject;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RMultiAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RSelfAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.blocks.RRescueBlockNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.classes.RClassObjectNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RArgumentListNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.arguments.RArgumentNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RSelfAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.controlStructures.RLambda;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFid;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public final class UsageAnalyzer {
    private UsageAnalyzer() {
    }

    public static boolean isFirstDeclaration(@NotNull RPsiElement element) {
        if (element == null) {
            UsageAnalyzer.$$$reportNull$$$0(0);
        }
        if (!RubyPsiUtilCore.isDeclaration((PsiElement)element) || element.getName() == null) {
            return false;
        }
        ScopeHolder scopeHolder = ScopeUtilCore.findScopeHolder((PsiElement)element);
        while (scopeHolder != null && ScopeUtilCore.hasParentScopeHolder((PsiElement)scopeHolder)) {
            if (!UsageAnalyzer.isFirstDeclarationInCurrentScope(element, scopeHolder)) {
                return false;
            }
            scopeHolder = ScopeUtilCore.findScopeHolder((PsiElement)scopeHolder);
        }
        return scopeHolder != null && UsageAnalyzer.isFirstDeclarationInCurrentScope(element, scopeHolder);
    }

    @NotNull
    public static Access createUsageAccess(@NotNull RPsiElement usage) {
        String usageName;
        String usageName2;
        RClass klass;
        RClassObject classObject;
        RAssignmentExpression assignment;
        if (usage == null) {
            UsageAnalyzer.$$$reportNull$$$0(1);
        }
        if (usage instanceof RIdentifier) {
            RIdentifier identifier = (RIdentifier)usage;
            if (identifier.isNumberedParameter()) {
                return new NumberedBlockParameterAccessImpl(usage);
            }
            if (identifier.isRescueParameterDeclaration()) {
                RRescueBlock rescueBlock = RRescueBlockNavigator.getByRPsiElement((RPsiElement)identifier);
                return new RescueBlockParameterAccessImpl(usage, rescueBlock);
            }
            if (identifier.isBlockParameterDeclaration()) {
                RArgumentList argumentList = Objects.requireNonNull(RArgumentListNavigator.getByArgumentContents((RPsiElement)identifier), "Guaranteed by UsageAnalyzer.isBlockParameter");
                return new BlockParameterAccessImpl((RPsiElement)identifier, argumentList);
            }
            if (identifier.isForLoopVariable()) {
                RForStatement forStatement = Objects.requireNonNull((RForStatement)identifier.getParent());
                return new ForBlockParameterAccessImpl((RPsiElement)identifier, forStatement);
            }
            if (identifier.isMethodParameterDeclaration()) {
                RArgument argument = RArgumentNavigator.getByParameter((RPsiElement)identifier);
                RMethod method = (RMethod)PsiTreeUtil.getParentOfType((PsiElement)identifier, RMethod.class);
                assert (method != null) : "Method cannot be null here";
                if (argument != null && argument.getType().isOptional() && argument.getIdentifier() == usage) {
                    return new PredefinedParameterAssignAccessImpl(usage, argument, method);
                }
                return new MethodParameterAccessImpl((RPsiElement)identifier, argument, method);
            }
            if (identifier.isLambdaParameterDeclaration()) {
                RArgument argument = RArgumentNavigator.getByParameter((RPsiElement)identifier);
                RLambda lambda = (RLambda)PsiTreeUtil.getParentOfType((PsiElement)identifier, RLambda.class);
                assert (lambda != null) : "Lambda cannot be null here";
                return new LambdaParameterAccessImpl((RPsiElement)identifier, argument, (RPsiElement)lambda);
            }
            if (identifier.isBlockCallLocalDeclaration()) {
                RCodeBlock codeBlock = (RCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)identifier, RCodeBlock.class);
                assert (codeBlock != null) : "Code block cannot be null here";
                return new BlockCallLocalVariableAccessImpl((RPsiElement)identifier, (RPsiElement)codeBlock);
            }
        }
        if ((assignment = RAssignmentExpressionNavigator.getAssignmentByLeftPart((PsiElement)usage)) != null) {
            return UsageAnalyzer.createAssignAccess(usage, assignment);
        }
        RSelfAssignmentExpression selfAssignment = RSelfAssignmentExpressionNavigator.getSelfAssignmentByLeftPart((PsiElement)usage);
        if (selfAssignment != null) {
            return new SelfAssignAccessImpl(usage, (RAssignmentExpression)selfAssignment);
        }
        if (RubyUsageAnalyzerCore.isPatternMatchingAssignment((PsiElement)usage)) {
            return new PatternMatchingAssignAccessImpl(usage);
        }
        RReference reference = RReferenceNavigator.getReferenceByLeftPart((PsiElement)usage);
        if (reference != null) {
            RAssignmentExpression refAssign;
            RPsiElement value = reference.getValue();
            if ((value instanceof RConstant && !(reference instanceof RColonReference) || value instanceof RIdentifier) && (refAssign = RAssignmentExpressionNavigator.getAssignmentByLeftPart((PsiElement)reference)) != null) {
                return new FieldWriteAccessImpl(usage, value, reference);
            }
            if (value instanceof RConstant) {
                return new ConstantAccessImpl(usage, value, reference);
            }
            if (value instanceof RIdentifier || value instanceof RFid) {
                return new CallAccessImpl(usage, reference, value, RCallNavigator.getByCommand((PsiElement)reference));
            }
        }
        if ((classObject = RClassObjectNavigator.getByElement((PsiElement)usage)) != null) {
            PsiElement parent = classObject.getParent();
            if (parent instanceof RObjectClass) {
                return new ObjectClassAccessImpl(usage, (RObjectClass)parent);
            }
            RSingletonMethod singletonMethod = (RSingletonMethod)PsiTreeUtil.getParentOfType((PsiElement)usage, RSingletonMethod.class);
            if (singletonMethod != null) {
                return new SingletonMethodAccessImpl(usage, singletonMethod);
            }
        }
        if ((klass = (RClass)PsiTreeUtil.getParentOfType((PsiElement)usage, RClass.class)) != null && (usageName2 = usage.getName()) != null && Objects.equals(usageName2, klass.getName())) {
            return new RClassAccessImpl(usage, klass);
        }
        RModule module = (RModule)PsiTreeUtil.getParentOfType((PsiElement)usage, RModule.class);
        if (module != null && (usageName = usage.getName()) != null && Objects.equals(usageName, module.getName())) {
            return new RModuleAccessImpl(usage, module);
        }
        return new AccessImpl(usage);
    }

    @NotNull
    public static Access createAssignAccess(@NotNull RPsiElement usage, RAssignmentExpression assignment) {
        if (usage == null) {
            UsageAnalyzer.$$$reportNull$$$0(2);
        }
        if (assignment instanceof RMultiAssignmentExpression) {
            return UsageAnalyzer.createMultiAssignmentAccess(usage, (RMultiAssignmentExpression)assignment);
        }
        return new AssignAccessImpl(usage, assignment, assignment.getValue(), 0);
    }

    @NotNull
    private static Access createMultiAssignmentAccess(@NotNull RPsiElement usage, RMultiAssignmentExpression assignment) {
        if (usage == null) {
            UsageAnalyzer.$$$reportNull$$$0(3);
        }
        if (!assignment.isMultiLhs() && !assignment.isMultiRhs()) {
            return new AssignAccessImpl(usage, (RAssignmentExpression)assignment, assignment.getValue(), 0);
        }
        if (!assignment.isMultiLhs()) {
            assert (assignment.isMultiRhs());
            return new AssignAccessImpl(usage, (RAssignmentExpression)assignment, (RPsiElement)ContainerUtil.getFirstItem((List)assignment.getRhsElements()), 0);
        }
        int lhsIndex = (int)StreamEx.of((Collection)assignment.getLhsElements()).indexOf(it -> PsiTreeUtil.isAncestor((PsiElement)it, (PsiElement)usage, (boolean)false)).orElse(-1L);
        if (assignment.isMultiRhs()) {
            List rhsElements = assignment.getRhsElements();
            if (lhsIndex < 0 || lhsIndex >= rhsElements.size()) {
                return new AssignAccessImpl(usage, (RAssignmentExpression)assignment, null, lhsIndex);
            }
            return new AssignAccessImpl(usage, (RAssignmentExpression)assignment, (RPsiElement)rhsElements.get(lhsIndex), lhsIndex);
        }
        return new AssignAccessImpl(usage, (RAssignmentExpression)assignment, assignment.getValue(), lhsIndex);
    }

    private static boolean isFirstDeclarationInCurrentScope(@NotNull RPsiElement element, @NotNull ScopeHolder scopeHolder) {
        Scope scope;
        if (element == null) {
            UsageAnalyzer.$$$reportNull$$$0(4);
        }
        if (scopeHolder == null) {
            UsageAnalyzer.$$$reportNull$$$0(5);
        }
        if ((scope = (Scope)ObjectUtils.doIfNotNull((Object)scopeHolder, ScopeHolder::getScope)) == null || element.getName() == null) {
            return false;
        }
        PsiElement currentDeclaration = scope.getLocalVariable((PsiElement)element, element.getName());
        return currentDeclaration == null || currentDeclaration == element || !RubyPsiUtilCore.isBefore((PsiElement)currentDeclaration, (PsiElement)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/usages/UsageAnalyzer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isFirstDeclaration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createUsageAccess";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createAssignAccess";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createMultiAssignmentAccess";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isFirstDeclarationInCurrentScope";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

