/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RDelegatedType;

public class RProcType
extends RDelegatedType {
    @Nullable
    private final RType mySelfType;
    private final List<Parameter> myParameters;
    private final boolean myHasUntypedParameters;
    @Nullable
    private final RProcType myBlockType;
    private final RType myReturnType;

    public RProcType(@NotNull Project project, @NotNull List<Parameter> parameters, @Nullable RProcType blockType, @NotNull RType returnType) {
        if (project == null) {
            RProcType.$$$reportNull$$$0(0);
        }
        if (parameters == null) {
            RProcType.$$$reportNull$$$0(1);
        }
        if (returnType == null) {
            RProcType.$$$reportNull$$$0(2);
        }
        this(project, null, parameters, false, blockType, returnType);
    }

    public RProcType(@NotNull Project project, @Nullable RType selfType, @NotNull List<Parameter> parameters, @Nullable RProcType blockType, @NotNull RType returnType) {
        if (project == null) {
            RProcType.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            RProcType.$$$reportNull$$$0(4);
        }
        if (returnType == null) {
            RProcType.$$$reportNull$$$0(5);
        }
        this(project, selfType, parameters, false, blockType, returnType);
    }

    public RProcType(@NotNull Project project, boolean hasUntypedParameters, @NotNull RType returnType) {
        if (project == null) {
            RProcType.$$$reportNull$$$0(6);
        }
        if (returnType == null) {
            RProcType.$$$reportNull$$$0(7);
        }
        this(project, null, Collections.emptyList(), hasUntypedParameters, null, returnType);
    }

    private RProcType(@NotNull Project project, @Nullable RType selfType, @NotNull List<Parameter> parameters, boolean hasUntypedParameters, @Nullable RProcType blockType, @NotNull RType returnType) {
        if (project == null) {
            RProcType.$$$reportNull$$$0(8);
        }
        if (parameters == null) {
            RProcType.$$$reportNull$$$0(9);
        }
        if (returnType == null) {
            RProcType.$$$reportNull$$$0(10);
        }
        super(RTypeFactory.createTypeByFQN(project, "Proc"));
        this.mySelfType = selfType;
        this.myParameters = List.copyOf(parameters);
        this.myHasUntypedParameters = hasUntypedParameters;
        this.myBlockType = blockType;
        this.myReturnType = returnType;
    }

    @Nullable
    public RProcType getBlockType() {
        return this.myBlockType;
    }

    @NotNull
    public List<Parameter> getParameters() {
        List<Parameter> list = this.myParameters;
        if (list == null) {
            RProcType.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public RType getReturnType() {
        RType rType = this.myReturnType;
        if (rType == null) {
            RProcType.$$$reportNull$$$0(12);
        }
        return rType;
    }

    @Nullable
    public RType getSelfType() {
        return this.mySelfType;
    }

    @NotNull
    public String getName() {
        String parameters = StringUtil.join(this.myParameters, parameter -> {
            String typeName = (String)ObjectUtils.coalesce((Object)parameter.getType().getName(), (Object)"untyped");
            return switch (parameter.getParameterType().ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1 -> typeName;
                case 2 -> String.format("*%s", typeName).trim();
                case 3, 4 -> String.format("%s: %s", parameter.getName(), typeName).trim();
                case 5 -> String.format("**%s", typeName).trim();
            };
        }, (String)", ");
        String block = this.myBlockType != null ? String.format("{ %s }", this.myBlockType.getName()) : "";
        String string = StringUtil.collapseWhiteSpace((CharSequence)String.format("(%s) %s -> %s", parameters, block, ObjectUtils.coalesce((Object)this.myReturnType.getName(), (Object)"untyped")));
        if (string == null) {
            RProcType.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public String getPresentableName() {
        StringBuilder parameters = new StringBuilder();
        if (this.myHasUntypedParameters) {
            parameters.append("?");
        }
        parameters.append(StringUtil.join(this.myParameters, parameter -> {
            String typeName = (String)ObjectUtils.coalesce((Object)parameter.getType().getPresentableName(), (Object)"untyped");
            return switch (parameter.getParameterType().ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1 -> typeName;
                case 2 -> String.format("*%s", typeName).trim();
                case 3, 4 -> String.format("%s: %s", parameter.getName(), typeName).trim();
                case 5 -> String.format("**%s", typeName).trim();
            };
        }, (String)", "));
        String block = this.myBlockType != null ? String.format("{ %s }", this.myBlockType.getPresentableName()) : "";
        return StringUtil.collapseWhiteSpace((CharSequence)String.format("(%s) %s -> %s", parameters, block, ObjectUtils.coalesce((Object)this.myReturnType.getPresentableName(), (Object)"untyped")));
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass() || !super.equals(obj)) {
            return false;
        }
        RProcType other = (RProcType)((Object)obj);
        return Objects.equals(this.mySelfType, other.mySelfType) && this.myParameters.equals(other.myParameters) && this.myHasUntypedParameters == other.myHasUntypedParameters && Objects.equals((Object)this.myBlockType, (Object)other.myBlockType) && this.myReturnType.equals((Object)other.myReturnType);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.mySelfType);
        result = 31 * result + this.myParameters.hashCode();
        result = 31 * result + Boolean.hashCode(this.myHasUntypedParameters);
        result = 31 * result + Objects.hashCode((Object)this.myBlockType);
        result = 31 * result + this.myReturnType.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/impl/RProcType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/impl/RProcType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 13 -> new IllegalStateException(string);
        };
    }

    public static final class Parameter {
        private final ParameterType myParameterType;
        @Nullable
        private final String myName;
        private final RType myType;

        public Parameter(@NotNull ParameterType parameterType, @Nullable String name, @NotNull RType type) {
            if (parameterType == null) {
                Parameter.$$$reportNull$$$0(0);
            }
            if (type == null) {
                Parameter.$$$reportNull$$$0(1);
            }
            this.myParameterType = parameterType;
            this.myName = name;
            this.myType = type;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Parameter other = (Parameter)obj;
            return this.myParameterType.equals((Object)other.myParameterType) && Objects.equals(this.myName, other.myName) && this.myType.equals((Object)other.myType);
        }

        @Nullable
        public String getName() {
            return this.myName;
        }

        @NotNull
        public ParameterType getParameterType() {
            ParameterType parameterType = this.myParameterType;
            if (parameterType == null) {
                Parameter.$$$reportNull$$$0(2);
            }
            return parameterType;
        }

        @NotNull
        public RType getType() {
            RType rType = this.myType;
            if (rType == null) {
                Parameter.$$$reportNull$$$0(3);
            }
            return rType;
        }

        public int hashCode() {
            int result = this.myParameterType.hashCode();
            result = 31 * result + Objects.hashCode(this.myName);
            result = 31 * result + this.myType.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/impl/RProcType$Parameter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/impl/RProcType$Parameter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameterType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static enum ParameterType {
        POSITIONAL_REQUIRED,
        POSITIONAL_OPTIONAL,
        POSITIONAL_REST,
        KEYWORD_REQUIRED,
        KEYWORD_OPTIONAL,
        KEYWORD_REST;

    }
}

