/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.AnonymousClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RSingletonInstanceConvertableType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RSymbolType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RDelegatedType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;

public class RModuleType
extends RDelegatedType {
    private final NotNullLazyValue<RType> myGenericTypeLazy;

    public RModuleType(@NotNull RType genericType) {
        if (genericType == null) {
            RModuleType.$$$reportNull$$$0(0);
        }
        super(RModuleType.convertToSingletonTypeIfPossible(genericType));
        this.myGenericTypeLazy = NotNullLazyValue.createValue(() -> {
            RType type = this.getOriginalType();
            RType genericType = type instanceof RSingletonInstanceConvertableType ? ((RSingletonInstanceConvertableType)type).convertToNotSingletonType() : type;
            String genericTypePresentableName = genericType.getPresentableName();
            if ("Class".equals(genericTypePresentableName) || "Module".equals(genericTypePresentableName)) {
                return REmptyType.INSTANCE;
            }
            return genericType;
        });
    }

    @NotNull
    public String getName() {
        return "Module";
    }

    @NotNull
    public RType getOriginalType() {
        RType rType = super.getOriginalType();
        if (rType == null) {
            RModuleType.$$$reportNull$$$0(1);
        }
        return rType;
    }

    @NotNull
    public final String getPresentableName() {
        RType genericType = this.getGenericType();
        if (this.isWithoutGenericType() || RModuleType.isAnonymousType(genericType)) {
            String string = this.getName();
            if (string == null) {
                RModuleType.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = this.getName() + "<" + genericType.getPresentableName() + ">";
        if (string == null) {
            RModuleType.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isWithoutGenericType() {
        return RTypeUtilCore.isNullOrEmpty((RType)this.getGenericType());
    }

    @Contract(pure=true)
    @NotNull
    public RType getGenericType() {
        RType rType = (RType)this.myGenericTypeLazy.getValue();
        if (rType == null) {
            RModuleType.$$$reportNull$$$0(4);
        }
        return rType;
    }

    @Nullable
    public Symbol getClassOrModuleSymbol(@Nullable PsiElement invocationPoint) {
        Symbol symbol = RTypeUtilCore.getBirthTypeSymbol((RType)this.getOriginalType());
        if (symbol == null) {
            return null;
        }
        return SymbolUtil.findConstantByFQN(symbol.getProject(), FQN.of((String)this.getName()), invocationPoint);
    }

    @NotNull
    private static RType convertToSingletonTypeIfPossible(@NotNull RType genericType) {
        if (genericType == null) {
            RModuleType.$$$reportNull$$$0(5);
        }
        if (!(genericType instanceof RSingletonInstanceConvertableType)) {
            RType rType = genericType;
            if (rType == null) {
                RModuleType.$$$reportNull$$$0(6);
            }
            return rType;
        }
        RType type = ((RSingletonInstanceConvertableType)genericType).convertToSingletonTypeIfPossible();
        if (type == null) {
            RType rType = genericType;
            if (rType == null) {
                RModuleType.$$$reportNull$$$0(7);
            }
            return rType;
        }
        RType rType = type;
        if (rType == null) {
            RModuleType.$$$reportNull$$$0(8);
        }
        return rType;
    }

    private static boolean isAnonymousType(@Nullable RType type) {
        return type instanceof RSymbolType && ((RSymbolType)type).getSymbol() instanceof AnonymousClassModuleSymbol;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/impl/RModuleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/impl/RModuleType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToSingletonTypeIfPossible";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertToSingletonTypeIfPossible";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

