/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.types.collections;

import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.collections.RCollectionTypeBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;

public final class RHashType
extends RCollectionTypeBase {
    @NotNull
    private final RType myKeyType;
    @NotNull
    private final RType myValueType;
    @NotNull
    private final RType myEachType;

    public RHashType(@NotNull Project project, @NotNull RType baseType, @NotNull RType keyType, @NotNull RType valueType) {
        if (project == null) {
            RHashType.$$$reportNull$$$0(0);
        }
        if (baseType == null) {
            RHashType.$$$reportNull$$$0(1);
        }
        if (keyType == null) {
            RHashType.$$$reportNull$$$0(2);
        }
        if (valueType == null) {
            RHashType.$$$reportNull$$$0(3);
        }
        super(baseType);
        this.myKeyType = keyType;
        this.myValueType = valueType;
        this.myEachType = keyType != REmptyType.INSTANCE || valueType != REmptyType.INSTANCE ? RTypeFactory.createArrayType(project, Arrays.asList(keyType, valueType)) : REmptyType.INSTANCE;
    }

    public RHashType(@NotNull RType baseType, @NotNull RType keyType, @NotNull RType valueType, @NotNull RType eachType) {
        if (baseType == null) {
            RHashType.$$$reportNull$$$0(4);
        }
        if (keyType == null) {
            RHashType.$$$reportNull$$$0(5);
        }
        if (valueType == null) {
            RHashType.$$$reportNull$$$0(6);
        }
        if (eachType == null) {
            RHashType.$$$reportNull$$$0(7);
        }
        super(baseType);
        this.myKeyType = keyType;
        this.myValueType = valueType;
        this.myEachType = eachType;
    }

    @NotNull
    public RType getIndexType() {
        RType rType = this.myValueType;
        if (rType == null) {
            RHashType.$$$reportNull$$$0(8);
        }
        return rType;
    }

    @NotNull
    public RType getEachType() {
        RType rType = this.myEachType;
        if (rType == null) {
            RHashType.$$$reportNull$$$0(9);
        }
        return rType;
    }

    @NotNull
    public List<RType> getElementTypes() {
        List<RType> list = List.of(this.myKeyType, this.myValueType);
        if (list == null) {
            RHashType.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public RType getKeyType() {
        RType rType = this.myKeyType;
        if (rType == null) {
            RHashType.$$$reportNull$$$0(11);
        }
        return rType;
    }

    @Nullable
    public String getName() {
        if (this.myKeyType != REmptyType.INSTANCE || this.myValueType != REmptyType.INSTANCE) {
            return String.format("%s{%s->%s}", this.myOriginalType.getName(), this.myKeyType.getName(), this.myValueType.getName());
        }
        return this.myOriginalType.getName();
    }

    @Nullable
    public String getPresentableName() {
        if (this.myKeyType != REmptyType.INSTANCE || this.myValueType != REmptyType.INSTANCE) {
            String keyPresentableName = (String)ObjectUtils.coalesce((Object)this.myKeyType.getPresentableName(), (Object)RBundle.message((String)"editor.expressionTypeProvider.unknownType"));
            String valuePresentableName = (String)ObjectUtils.coalesce((Object)this.myValueType.getPresentableName(), (Object)RBundle.message((String)"editor.expressionTypeProvider.unknownType"));
            return String.format("%s{%s->%s}", this.myOriginalType.getPresentableName(), keyPresentableName, valuePresentableName);
        }
        return this.myOriginalType.getPresentableName();
    }

    @NotNull
    public RType getValueType() {
        RType rType = this.myValueType;
        if (rType == null) {
            RHashType.$$$reportNull$$$0(12);
        }
        return rType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RHashType type = (RHashType)((Object)o);
        return Objects.equals(this.myKeyType, type.myKeyType) && Objects.equals(this.myValueType, type.myValueType) && Objects.equals(this.myEachType, type.myEachType);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myKeyType.hashCode();
        result = 31 * result + this.myValueType.hashCode();
        result = 31 * result + this.myEachType.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseType";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyType";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eachType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/collections/RHashType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/collections/RHashType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEachType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTypes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

